Program Arc_Demo;

Uses
  crt;

Const
  VGA = $a000;
  n = 25;

Type
  Virt = array [1..64000] of byte;
  VirtPtr = ^Virt;

Var
  VirtScr : VirtPtr;
  Vaddr : word;
  absX, absY : integer;
  LandScape : array [0..n,0..n] of integer;
  cosX: array [0..1000] of byte;

Procedure SetMCGA;
Begin
  asm
    mov ax,0013h
    int 10h
  end;
End;

Procedure CLS(col : byte; where : word);
Begin
  FillChar(Mem[where:0], 64000, col)
End;

Procedure WaitRetrace; Assembler;
Label
  l1, l2;
Asm
  mov dx,3DAh
l1:
  in al,dx
  and al,08h
  jnz l1
l2:
  in al,dx
  and al,08h
  jnz l2
End;

Procedure SetUpVirtScr;
Begin
  GetMem(VirtScr, 64000);
  Vaddr := Seg(VirtScr^);
End;

Procedure DestroyVirtScr;
Begin
  FreeMem(VirtScr, 64000);
End;

Procedure PutPixel(x, y : integer; col : byte; where : word);
Begin
  Mem[where:X+(Y*320)] := col;
End;

Procedure Flip;
Begin
  Move(VirtScr^, Mem[VGA:0], 64000);
End;

Procedure Pal(ColorNo : byte; R, G, B : byte);
Begin
  Port[$3c8] := ColorNo;
  Port[$3c9] := R;
  Port[$3c9] := G;
  Port[$3c9] := B;
End;


Procedure line(a,b,c,d : integer;col : integer; where : word);
  function sgn(a:real):integer;
  begin
    if a>0 then sgn:=+1;
    if a<0 then sgn:=-1;
    if a=0 then sgn:=0;
  end;
var
  i,s,d1x,d1y,d2x,d2y,u,v,m,n:integer;
  count:integer;
begin
  count:=50;
  u:= c - a;
  v:= d - b;
  d1x:= SGN(u);
  d1y:= SGN(v);
  d2x:= SGN(u);
  d2y:= 0;
  m:= ABS(u);
  n := ABS(v);
  IF NOT (M>N) then
  BEGIN
    d2x := 0 ;
    d2y := SGN(v);
    m := ABS(v);
    n := ABS(u);
  END;
  s := m shr 1;
  FOR i := 0 TO m DO
  BEGIN
    if col = -2 then
      putpixel(a,b,count,where)
    else if col = -1 then
      putpixel(a,b,Random(256),where)
    else
      putpixel(a,b,col,where);
    inc (count);
    if count=101 then count:=50;
    s := s + n;
    IF not (s<m) THEN
    BEGIN
      s := s - m;
      a:= a + d1x;
      b := b + d1y;
    END
    ELSE
    BEGIN
      a := a + d2x;
      b := b + d2y;
    END;
  end;
END;

Procedure rotate(const x, y, z : integer; Alpha, Beta, Gamma : real;
                 var u, v : integer);
var x1, y1, z1, x2, y2, z2 : real;
begin
{1}  x1 := x * cos(alpha) - y * sin(alpha);
     y1 := x * sin(alpha) + y * cos(alpha);
     z1 := z;

{2}  x2 := x1 * cos(beta) - z1 * sin(beta);
     y2 := y1;
     z2 := x1 * sin(beta) + z1 * cos(beta);

{3}  x1 := x2;
     y1 := y2 * cos(Gamma) - z2 * sin(Gamma);
     z1 := y2 * sin(Gamma) + z2 * cos(Gamma);

   u := round(x1)+AbsX;
   v := round(z1)+AbsY;
end;

Procedure DrawLS(Alpha, Beta, Gamma : real; Col : byte);
var
  x, y : array[0..n,0..n] of Integer;
  i,j,ii,jj : integer;
begin
  alpha := pi * alpha / 180.0;
  beta := pi * beta / 180.0;
  gamma := pi * gamma / 180.0;
  For i := 0 to n do
    For j := 0 to n do
      rotate((i-n div 2)*8,(j-n div 2)*8,LandScape[i,j],Alpha,Beta,Gamma,x[i,j],y[i,j]);
  For i := 0 to n do
    For j := 0 to n do
    Begin
      if i <> n then line(x[i,j],y[i,j],x[i+1,j],y[i+1,j],col,Vaddr);
      if j <> n then line(x[i,j],y[i,j],x[i,j+1],y[i,j+1],col,Vaddr);
    End;
  PutPixel(x[0,0],y[0,0],192,Vaddr)
end;

Function Calc(i,j : integer) : integer;
var
  s1, s2, s3, i1, i2, j1, j2 : integer;
Begin
  i2 := i mod 5;
  i1 := i - i2;
  j2 := j mod 5;
  j1 := j - j2;
  s1 := (LandScape[i1,j1]*sqr(5-i2) + LandScape[i1+5,j1]*sqr(i2)) div (sqr(i2)+sqr(5-i2));
  s2 := (LandScape[i1,j1+5]*sqr(5-i2) + LandScape[i1+5,j1+5]*sqr(i2)) div (sqr(i2)+sqr(5-i2));
  Calc := (s1*sqr(5-j2) + s2*sqr(j2)) div (sqr(j2)+sqr(5-j2));
End;

Procedure Invert1(x1, y1, x2, y2 : integer);
var
  i, j : integer;
Begin
  For i := x1 to x2 do
    For j := y1 to y2 do
      PutPixel(i, j, (255-Mem[Vaddr:i+(j*320)])*2+Random(20), Vaddr);
ENd;

Procedure Invert2(x1, y1, x2, y2 : integer);
var
  i, j : integer;
Begin
  For i := x1 to x2 do
    For j := y1 to y2 do
      PutPixel(i, j, Mem[Vaddr:i+(j*320)]+128, Vaddr);
ENd;

{}

var
  Key : char;
  Ex : boolean;
  k3, k4, k5, i, j : integer;
  Alpha, Beta, Gamma : real;
  dx,dy,x1,x2,y1,y2 : integer;
  dxx,dyy,xx1,xx2,yy1,yy2 : integer;

Begin
  Randomize;
  SetMCGA;
  SetUpVirtScr;
  absX := 160;
  absY := 145;
  For i := 0 to n div 5 do
    For j := 0 to n div 5 do
    Begin
      LandScape[i*5,j*5] := -Random(100);
    End;
  For i := 0 to n do
    For j := 0 to n do
      if not((i mod 5 = 0) and (j mod 5 = 0)) then
        LandScape[i,j] := Calc(i, j);
  Alpha := 0;
  Beta  := 0;
  Gamma := 25;
  For i := 0 to 1000 do
    cosX[i] := trunc((cos(i/16)+1)*31.5);

  FOr i := 0 to 63 do
    Pal(i,63,63-i,0);
  FOr i := 64 to 127 do
    Pal(i,63,0,i-64);
  FOr i := 128 to 191 do
    Pal(i,63-i-128,0,63);
  FOr i := 192 to 255 do
    Pal(i,i-192,i-192,63-i-192);
  k4 := 0;
  k5 := 0;
  x1 := Random(220);
  y1 := Random(150);
  dx := 2;
  dy := 2;
  xx1 := Random(220);
  yy1 := Random(150);
  dxx := -2;
  dyy := -2;

  Repeat

    For i := 0 to 319 do
      for j := 0 to 199 do
        PutPixel(i,j,cosX[(i+k4+(cosX[cosX[k4]]+cosX[cosX[k4]])div 2)] + (cosX[j+i+k4+cosX[k4]]+cosX[319-i+k4+cosX[k4]+
        cosX[k4]])div 2+cosX[199-j+(cosX[cosX[cosX[k4]+j]+i+k4])div 2]+cosX[k4]-k5+j+i,Vaddr);
    Inc(k3);
    if k3 > trunc(Pi*64) then k3 := 0;
    k4 := k3 div 2;
    Inc(k5);
    if k5 = 256 then k5 := 0;

    DrawLS(Alpha, Beta, Gamma, 0);
    Alpha := Alpha + 1;
    If Alpha >= 360 then Alpha := 0;

    x2 := x1 + 100;
    y2 := y1 + 50;
    Invert1(x1,y1,x2,y2);
    Inc(x1, dx);
    Inc(y1, dy);
    If x1 >= 220 then dx := dx * (-1);
    If y1 >= 150 then dy := dy * (-1);
    If x1 <= 0 then dx := dx * (-1);
    If y1 <= 0 then dy := dy * (-1);

    xx2 := xx1 + 100;
    yy2 := yy1 + 50;
    Invert2(xx1,yy1,xx2,yy2);
    Inc(xx1, dxx);
    Inc(yy1, dyy);
    If xx1 >= 220 then dxx := dxx * (-1);
    If yy1 >= 150 then dyy := dyy * (-1);
    If xx1 <= 0 then dxx := dxx * (-1);
    If yy1 <= 0 then dyy := dyy * (-1);

    WaitRetrace;
    Flip;
    If KeyPressed then Key := ReadKey;
    If Key = #27 then Ex := true;
    Key := #0;
  Until Ex;
End.