Program Arc_Demo;

Uses
  crt;

Const
  VGA = $a000;

Type
  Virt = array [1..64000] of byte;
  VirtPtr = ^Virt;

Var
  VirtScr : VirtPtr;
  Vaddr : word;

Procedure SetMCGA;
Begin
  asm
    mov ax,0013h
    int 10h
  end;
End;

Procedure CLS(col : byte; where : word);
Begin
  FillChar(Mem[where:0], 64000, col)
End;

Procedure WaitRetrace; Assembler;
Label
  l1, l2;
Asm
  mov dx,3DAh
l1:
  in al,dx
  and al,08h
  jnz l1
l2:
  in al,dx
  and al,08h
  jnz l2
End;

Procedure SetUpVirtScr;
Begin
  GetMem(VirtScr, 64000);
  Vaddr := Seg(VirtScr^);
End;

Procedure DestroyVirtScr;
Begin
  FreeMem(VirtScr, 64000);
End;

Procedure PutPixel(x, y : integer; col : byte; where : word);
Begin
  Mem[where:X+(Y*320)] := col;
End;

Procedure Flip;
Begin
  Move(VirtScr, Mem[VGA:0], 64000);
End;

Procedure Pal(ColorNo : byte; R, G, B : byte);
Begin
  Port[$3c8] := ColorNo;
  Port[$3c9] := R;
  Port[$3c9] := G;
  Port[$3c9] := B;
End;

Procedure Funny_line(a,b,c,d:integer;where:word);
  function sgn(a:real):integer;
  begin
    if a>0 then sgn:=+1;
    if a<0 then sgn:=-1;
    if a=0 then sgn:=0;
  end;
var
  i,s,d1x,d1y,d2x,d2y,u,v,m,n:integer;
  count:integer;
begin
  count:=50;
  u:= c - a;
  v:= d - b;
  d1x:= SGN(u);
  d1y:= SGN(v);
  d2x:= SGN(u);
  d2y:= 0;
  m:= ABS(u);
  n := ABS(v);
  IF NOT (M>N) then
  BEGIN
    d2x := 0 ;
    d2y := SGN(v);
    m := ABS(v);
    n := ABS(u);
  END;
  s := m shr 1;
  FOR i := 0 TO m DO
  BEGIN
    putpixel(a,b,count,where);
    inc (count);
    if count=101 then count:=50;
    s := s + n;
    IF not (s<m) THEN
    BEGIN
      s := s - m;
      a:= a + d1x;
      b := b + d1y;
    END
    ELSE
    BEGIN
      a := a + d2x;
      b := b + d2y;
    END;
  end;
END;

Function SM : integer;
Begin
  SM := Random(21) - 10;
End;

{}

var
  A, A1 : array [1..100,1..2] of integer;
  Key : char;
  Ex : boolean;
  i : integer;

Begin
  Randomize;
  SetMCGA;
  SetUpVirtScr;
  CLS(0, Vaddr);

  Ex := false;
  A [1,1] := 160 - 50;
  A [1,2] := 100 - 50;
  A [2,1] := 160 + 50;
  A [2,2] := 100 - 50;
  A [3,1] := 160 + 50;
  A [3,2] := 100 + 50;
  A [4,1] := 160 - 50;
  A [4,2] := 100 + 50;
  A [5,1] := 160 - 50;
  A [5,2] := 100 - 50;

  Repeat
    Delay(10000);
    WaitRetrace;
    CLS(0, VGA);
    For i := 1 to 4 do
      begin
        A1[i,1] := A[i,1] + SM;
        A1[i,2] := A[i,2] + SM;
      end;
    A1[5,1] := A1[1,1];
    A1[5,2] := A1[1,2];
    For i := 1 to 4 do
      begin
        Funny_line(A1[i,1], A1[i,2], A1[i+1,1], A1[i+1,2], VGA);
      end;
    If KeyPressed then Key := ReadKey;
    If Key = #27 then Ex := true;
    Key := #0;
  Until Ex;
End.