Program Arc_Demo;

Uses
  crt;

Const
  VGA = $a000;

Type
  Virt = array [1..64000] of byte;
  VirtPtr = ^Virt;
  vector = array[1..3] of Real;
  projection = array[1..2] of vector;

Var
  VirtScr : VirtPtr;
  Vaddr : word;
  P : projection;
  absX, absY : integer;

Procedure SetMCGA;
Begin
  asm
    mov ax,0013h
    int 10h
  end;
End;

Procedure CLS(col : byte; where : word);
Begin
  FillChar(Mem[where:0], 64000, col)
End;

Procedure WaitRetrace; Assembler;
Label
  l1, l2;
Asm
  mov dx,3DAh
l1:
  in al,dx
  and al,08h
  jnz l1
l2:
  in al,dx
  and al,08h
  jnz l2
End;

Procedure SetUpVirtScr;
Begin
  GetMem(VirtScr, 64000);
  Vaddr := Seg(VirtScr^);
End;

Procedure DestroyVirtScr;
Begin
  FreeMem(VirtScr, 64000);
End;

Procedure PutPixel(x, y : integer; col : byte; where : word);
Begin
  Mem[where:X+(Y*320)] := col;
End;

Procedure Flip;
Begin
  Move(VirtScr^, Mem[VGA:0], 64000);
End;

Procedure Pal(ColorNo : byte; R, G, B : byte);
Begin
  Port[$3c8] := ColorNo;
  Port[$3c9] := R;
  Port[$3c9] := G;
  Port[$3c9] := B;
End;


Procedure line(a,b,c,d : integer;col : integer; where : word);
  function sgn(a:real):integer;
  begin
    if a>0 then sgn:=+1;
    if a<0 then sgn:=-1;
    if a=0 then sgn:=0;
  end;
var
  i,s,d1x,d1y,d2x,d2y,u,v,m,n:integer;
  count:integer;
begin
  count:=50;
  u:= c - a;
  v:= d - b;
  d1x:= SGN(u);
  d1y:= SGN(v);
  d2x:= SGN(u);
  d2y:= 0;
  m:= ABS(u);
  n := ABS(v);
  IF NOT (M>N) then
  BEGIN
    d2x := 0 ;
    d2y := SGN(v);
    m := ABS(v);
    n := ABS(u);
  END;
  s := m shr 1;
  FOR i := 0 TO m DO
  BEGIN
    if col = -2 then
      putpixel(a,b,count,where)
    else if col = -1 then
      putpixel(a,b,Random(256),where)
    else
      putpixel(a,b,col,where);
    inc (count);
    if count=101 then count:=50;
    s := s + n;
    IF not (s<m) THEN
    BEGIN
      s := s - m;
      a:= a + d1x;
      b := b + d1y;
    END
    ELSE
    BEGIN
      a := a + d2x;
      b := b + d2y;
    END;
  end;
END;

Procedure rotate(const x, y, z : integer; const Alpha, Beta, Gamma : real;
                 var u, v : integer);
var x1, y1, z1, x2, y2, z2 : real;
begin
{1}  x1 := x * cos(alpha) - y * sin(alpha);
     y1 := x * sin(alpha) + y * cos(alpha);
     z1 := z;

{2}  x2 := x1 * cos(beta) - z1 * sin(beta);
     y2 := y1;
     z2 := x1 * sin(beta) + z1 * cos(beta);

{3}  x1 := x2;
     y1 := y2 * cos(Gamma) - z2 * sin(Gamma);
     z1 := y2 * sin(Gamma) + z2 * cos(Gamma);

   u := round(x1);
   v := round(z1);
end;

Procedure DrawCube(Alpha, Beta, Gamma : real; Col : byte);
var
  x, y : array[1..8] of Integer;
begin
  alpha := pi * alpha / 180.0;
  beta := pi * beta / 180.0;
  gamma := pi * gamma / 180.0;
  rotate( 40,  40,  40, Alpha, Beta, Gamma, x[1], y[1]);
  rotate(-40,  40,  40, Alpha, Beta, Gamma, x[2], y[2]);
  rotate(-40, -40,  40, Alpha, Beta, Gamma, x[3], y[3]);
  rotate( 40, -40,  40, Alpha, Beta, Gamma, x[4], y[4]);
  rotate( 40,  40, -40, Alpha, Beta, Gamma, x[5], y[5]);
  rotate(-40,  40, -40, Alpha, Beta, Gamma, x[6], y[6]);
  rotate(-40, -40, -40, Alpha, Beta, Gamma, x[7], y[7]);
  rotate( 40, -40, -40, Alpha, Beta, Gamma, x[8], y[8]);
  line(absX + x[1], absY + y[1], absX + x[2], absY + y[2], col, Vaddr);
  line(absX + x[2], absY + y[2], absX + x[3], absY + y[3], col, Vaddr);
  line(absX + x[3], absY + y[3], absX + x[4], absY + y[4], col, Vaddr);
  line(absX + x[4], absY + y[4], absX + x[1], absY + y[1], col, Vaddr);
  line(absX + x[5], absY + y[5], absX + x[6], absY + y[6], col, Vaddr);
  line(absX + x[6], absY + y[6], absX + x[7], absY + y[7], col, Vaddr);
  line(absX + x[7], absY + y[7], absX + x[8], absY + y[8], col, Vaddr);
  line(absX + x[8], absY + y[8], absX + x[5], absY + y[5], col, Vaddr);
  line(absX + x[1], absY + y[1], absX + x[5], absY + y[5], col, Vaddr);
  line(absX + x[2], absY + y[2], absX + x[6], absY + y[6], col, Vaddr);
  line(absX + x[3], absY + y[3], absX + x[7], absY + y[7], col, Vaddr);
  line(absX + x[4], absY + y[4], absX + x[8], absY + y[8], col, Vaddr);
end;


{}

var
  Key : char;
  Ex : boolean;
  a,b,c : integer;
  lines : array [0..199] of integer;
  vectors : array [0..199] of boolean;
  q,i,j,k,x,y,z : integer;

Begin
  Randomize;
  SetMCGA;
  SetUpVirtScr;
  absX := 160;
  absY := 100;
  CLS(0, Vaddr);
  a := Random(360);
  b := Random(360);
  c := Random(360);
  i := Random(64);
  j := Random(64);
  k := Random(64);
  For i := 0 to 199 do
  begin
    if Random(2) = 0 then vectors[i] := true else vectors[i] := false;
    lines[i] := Random(320);
  end;

  Repeat
    CLS(0, VAddr);


{    For q := 0 to 199 do
    begin
      if vectors[q] then Inc(lines[q]) else Dec(lines[q]);
      Line(lines[q], q, lines[q] + 100, q, -2, Vaddr);
    end;}

    DrawCube(a, b, c, 15);
    DrawCube(a+Random(7)-3, b+Random(7)-3, c+Random(7)-3, 15);
    WaitRetrace;
    Flip;
    Inc(a);
    If a >= 360 then a := 1;
    Inc(b);
    If b >= 360 then b := 1;
    Inc(c);
    If c >= 360 then c := 1;

    if Random(100) = 0 then x := Random(64);
    if Random(100) = 0 then y := Random(64);
    if Random(100) = 0 then z := Random(64);

    if i < x then Inc(i);
    if i > x then Dec(i);
    if j < y then Inc(j);
    if j > y then Dec(j);
    if k < z then Inc(k);
    if k > z then Dec(k);
    Pal(15, i, j, k);
  Until KeyPressed;

  ReadKey;
End.