Program Arc_Demo;

Uses
  crt;

Const
  VGA = $a000;

Type
  Virt = array [1..64000] of byte;
  VirtPtr = ^Virt;

Var
  VirtScr : VirtPtr;
  Vaddr : word;

Procedure SetMCGA;
Begin
  asm
    mov ax,0013h
    int 10h
  end;
End;

Procedure CLS(col : byte; where : word);
Begin
  FillChar(Mem[where:0], 64000, col)
End;

Procedure WaitRetrace; Assembler;
Label
  l1, l2;
Asm
  mov dx,3DAh
l1:
  in al,dx
  and al,08h
  jnz l1
l2:
  in al,dx
  and al,08h
  jnz l2
End;

Procedure SetUpVirtScr;
Begin
  GetMem(VirtScr, 64000);
  Vaddr := Seg(VirtScr^);
End;

Procedure DestroyVirtScr;
Begin
  FreeMem(VirtScr, 64000);
End;

Procedure PutPixel(x, y : integer; col : byte; where : word);
Begin
  Mem[where:X+(Y*320)] := col;
End;

Procedure Flip;
Begin
  Move(VirtScr^, Mem[VGA:0], 64000);
End;

Procedure Pal(ColorNo : byte; R, G, B : byte);
Begin
  Port[$3c8] := ColorNo;
  Port[$3c9] := R;
  Port[$3c9] := G;
  Port[$3c9] := B;
End;

Procedure Funny_line(a,b,c,d:integer;ran:boolean;where:word);
  function sgn(a:real):integer;
  begin
    if a>0 then sgn:=+1;
    if a<0 then sgn:=-1;
    if a=0 then sgn:=0;
  end;
var
  i,s,d1x,d1y,d2x,d2y,u,v,m,n:integer;
  count:integer;
begin
  count:=50;
  u:= c - a;
  v:= d - b;
  d1x:= SGN(u);
  d1y:= SGN(v);
  d2x:= SGN(u);
  d2y:= 0;
  m:= ABS(u);
  n := ABS(v);
  IF NOT (M>N) then
  BEGIN
    d2x := 0 ;
    d2y := SGN(v);
    m := ABS(v);
    n := ABS(u);
  END;
  s := m shr 1;
  FOR i := 0 TO m DO
  BEGIN
    if ran then putpixel(a,b,Random(255),where)
      else putpixel(a,b,count,where);
    inc (count);
    if count=101 then count:=50;
    s := s + n;
    IF not (s<m) THEN
    BEGIN
      s := s - m;
      a:= a + d1x;
      b := b + d1y;
    END
    ELSE
    BEGIN
      a := a + d2x;
      b := b + d2y;
    END;
  end;
END;

Function SM(n : integer) : integer;
Begin
  SM := Random(n*10+1) - (n*10 div 2);
End;

{}

var
  x, y, x_old, y_old : integer;
  Key : char;
  Ex : boolean;
  i, j, ver, r1, r2, x_bon : integer;

Begin
  Randomize;
  SetMCGA;
  SetUpVirtScr;
  CLS(0, Vaddr);

{  For i := 0 to 255 do
    Pal(i, i div 3, i div 3, i+50);
  Pal(0,0,0,0);}

  Ex := false;
  x_old := 0;
  ver := 100;
  y_old := ver;

  Repeat
    For i := 0 to 2000 do
      begin
        PutPixel(Random(320), Random(i div 20), Random(255), Vaddr);
        PutPixel(Random(320), 199 - Random(i div 20), Random(255), Vaddr);
      end;
    For i := 1 to Random(10)+2 do
      begin
        x_bon := Random(320);
        funny_line(x_bon,0,x_bon,199,true, Vaddr);
      end;
    r1 := Random(80);
    r2 := Random(r1);
    ver := Random(r2 + 1) - r2 div 2 + 100;
    Delay(3000);
    WaitRetrace;
    Flip;
    CLS(0, Vaddr);
    For j := 1 to 4 do
      begin
        x_old := 0;
        y_old := 100;
        For i := 0 to 32 do
          begin
            x := i * 10 + SM(1);
            If x > 319 then x := 319;
            If x < 0 then x := 0;
            y := ver + SM(j+1);
            funny_line(x_old, y_old, x, y,false, Vaddr);
            x_old := x;
            y_old := y;
          end;
        end;
    If KeyPressed then Key := ReadKey;
    If Key = #27 then Ex := true;
    Key := #0;
  Until Ex;
End.