Program Arc_Demo;

Uses
  crt;

Const
  VGA = $a000;
  num_lines = 1;
  pause = 7000;

Type
  Virt = array [1..64000] of byte;
  VirtPtr = ^Virt;
  Alphabet = array [1..26, 1..100, 1..4] of integer;

Var
  VirtScr : VirtPtr;
  Vaddr : word;

Procedure SetMCGA;
Begin
  asm
    mov ax,0013h
    int 10h
  end;
End;

Procedure CLS(col : byte; where : word);
Begin
  FillChar(Mem[where:0], 64000, col)
End;

Procedure WaitRetrace; Assembler;
Label
  l1, l2;
Asm
  mov dx,3DAh
l1:
  in al,dx
  and al,08h
  jnz l1
l2:
  in al,dx
  and al,08h
  jnz l2
End;

Procedure SetUpVirtScr;
Begin
  GetMem(VirtScr, 64000);
  Vaddr := Seg(VirtScr^);
End;

Procedure DestroyVirtScr;
Begin
  FreeMem(VirtScr, 64000);
End;

Procedure PutPixel(x, y : integer; col : byte; where : word);
Begin
  Mem[where:X+(Y*320)] := col;
End;

Procedure Flip;
Begin
  Move(VirtScr, Mem[VGA:0], 64000);
End;

Procedure Pal(ColorNo : byte; R, G, B : byte);
Begin
  Port[$3c8] := ColorNo;
  Port[$3c9] := R;
  Port[$3c9] := G;
  Port[$3c9] := B;
End;

Procedure Funny_line(a,b,c,d:integer;where:word);
  function sgn(a:real):integer;
  begin
    if a>0 then sgn:=+1;
    if a<0 then sgn:=-1;
    if a=0 then sgn:=0;
  end;
var
  i,s,d1x,d1y,d2x,d2y,u,v,m,n:integer;
  count:integer;
begin
  count:=50;
  u:= c - a;
  v:= d - b;
  d1x:= SGN(u);
  d1y:= SGN(v);
  d2x:= SGN(u);
  d2y:= 0;
  m:= ABS(u);
  n := ABS(v);
  IF NOT (M>N) then
  BEGIN
    d2x := 0 ;
    d2y := SGN(v);
    m := ABS(v);
    n := ABS(u);
  END;
  s := m shr 1;
  FOR i := 0 TO m DO
  BEGIN
    putpixel(a,b,count,where);
    inc (count);
    if count=101 then count:=50;
    s := s + n;
    IF not (s<m) THEN
    BEGIN
      s := s - m;
      a:= a + d1x;
      b := b + d1y;
    END
    ELSE
    BEGIN
      a := a + d2x;
      b := b + d2y;
    END;
  end;
END;

Function SM : integer;
Begin
  SM := Random(21) - 10;
End;

Procedure InitAlphabet(var A : Alphabet);
begin
  A[13,1,1] := 0;
  A[13,1,2] := 5;
  A[13,1,3] := 0;
  A[13,1,4] := 0;

  A[13,2,1] := 0;
  A[13,2,2] := 0;
  A[13,2,3] := 2;
  A[13,2,4] := 2;

  A[13,3,1] := 2;
  A[13,3,2] := 2;
  A[13,3,3] := 4;
  A[13,3,4] := 0;

  A[13,4,1] := 4;
  A[13,4,2] := 0;
  A[13,4,3] := 4;
  A[13,4,4] := 5;

  A[13,5,1] := -1;
  A[13,5,2] := -1;
  A[13,5,3] := -1;
  A[13,5,4] := -1;

  A[19,1,1] := 0;
  A[19,1,2] := 0;
  A[19,1,3] := 0;
  A[19,1,4] := 3;

  A[19,2,1] := 0;
  A[19,2,2] := 3;
  A[19,2,3] := 1;
  A[19,2,4] := 5;

  A[19,3,1] := 1;
  A[19,3,2] := 5;
  A[19,3,3] := 3;
  A[19,3,4] := 5;

  A[19,4,1] := 3;
  A[19,4,2] := 5;
  A[19,4,3] := 4;
  A[19,4,4] := 3;

  A[19,5,1] := 4;
  A[19,5,2] := 3;
  A[19,5,3] := 4;
  A[19,5,4] := 0;

  A[19,6,1] := -1;
  A[19,6,2] := -1;
  A[19,6,3] := -1;
  A[19,6,4] := -1;

  A[21,1,1] := 4;
  A[21,1,2] := 0;
  A[21,1,3] := 0;
  A[21,1,4] := 0;

  A[21,2,1] := 0;
  A[21,2,2] := 0;
  A[21,2,3] := 0;
  A[21,2,4] := 2;

  A[21,3,1] := 0;
  A[21,3,2] := 2;
  A[21,3,3] := 4;
  A[21,3,4] := 2;

  A[21,4,1] := 4;
  A[21,4,2] := 2;
  A[21,4,3] := 4;
  A[21,4,4] := 5;

  A[21,5,1] := 4;
  A[21,5,2] := 5;
  A[21,5,3] := 0;
  A[21,5,4] := 5;

  A[21,6,1] := -1;
  A[21,6,2] := -1;
  A[21,6,3] := -1;
  A[21,6,4] := -1;

end;

Procedure DrawChar(x,y, m : integer;var A1 : alphabet; num : integer;
                   where : word);
var
  i, n,a,b,c,d : integer;
begin
  n := 0;
  While (A1[num,n+1,1] <> -1) and (A1[num,n+1,2] <> -1)
        and (A1[num,n+1,3] <> -1) and (A1[num,n+1,4] <> -1) do
    Inc(n);
  For i := 1 to n do
    begin
      if (i>1) and (A1[num,i,1] = A1[num,i-1,3]) and
         (A1[num,i,2] = A1[num,i-1,4]) then
        begin
          a := c;
          b := d;
        end
      else
        begin
          a := A1[num,i,1] * m + x + SM;
          b := A1[num,i,2] * m + y + SM;
        end;
      c :=  A1[num,i,3] * m + x + SM;
      d :=  A1[num,i,4] * m + y + SM;
      Funny_line(a,b,c,d,where);
    end;
end;

{}

var
  A, A1 : Alphabet;
  Key : char;
  Ex : boolean;
  i, num_l : integer;

Begin
  Randomize;
  SetMCGA;
  SetUpVirtScr;
  CLS(0, Vaddr);

  num_l := num_lines;
  Ex := false;
  InitAlphabet(A);

  Repeat
    Delay(pause);
    WaitRetrace;
    CLS(0, VGA);
    For i := 1 to num_l do
      begin
        DrawChar(10, 50, 20, A, 13, VGA);
        DrawChar(110, 50, 20, A, 19, VGA);
        DrawChar(210, 50, 20, A, 21, VGA);
      end;
 {   WaitRetrace;}
{    Flip;     }
    If KeyPressed then Key := ReadKey;
    If (Key = '+') and (num_l < 10) then Inc(num_l);
    If (Key = '-') and (num_l > 1) then Dec(num_l);
    If Key = #27 then Ex := true;
    Key := #0;
  Until Ex;
End.