unit Arc_sys;

interface

uses dos, graph, crt;

const
  VGA = $a000;               {Segment of a real screen (Video memory)}

Type
  Virt = array [1..64000] of byte;
  VirtPtr = ^Virt;

Var
  VirtScr : VirtPtr;
  Vaddr   : word;            {The segment of the virtual screen}

  VertPos : Integer;         {Starting vertical position of text}

{Searching file fn in directori dir including subdirectores}
function DirSearch(fn, dir : string) : string;

{Returns timer number}
function Clock : longint;

{Types string from screen center by symbols}
procedure WriteEx(str : string);

{Super Read procedure !!! :) }
procedure ReadEx(X,Y: integer;var Str: string;Num: integer;Mode: boolean);

{Initializes Labytinth Engine}
procedure InitEngine;

{Close Labyrinth Engine}
procedure CloseEngine;

{This waits for a vertical retrace to reduce snow on the screen}
procedure WaitRetrace;

{This procedure gets you into 320x200x256 mode}
Procedure SetMCGA;

{This procedure returns you to text mode}
Procedure SetTEXT;

{This clears the screen to the specified color}
Procedure CLS(col : byte; where : word);

{This sets up the memory needed for the virtual screen}
Procedure SetUpVirtScr;

{This frees the memory used by the virtual screen}
Procedure DestroyVirtScr;

{This puts a pixel on the screen by writing directly to memory}
Procedure PutPixel(x, y : integer; col : byte; where : word);

{This copies the entire screen at "source" to destination}
Procedure Flip(Source, Dest : word);

implementation

var
  old61        : pointer;
  mbk          : array [1..520] of byte;

{$L vesa.obj}
procedure vesa; external;

Procedure SetMCGA;
Begin
  asm
    mov   ax,0013h
    int   10h
  end;
End;

Procedure SetTEXT;
Begin
  asm
    mov   ax,0161
    int   10h
  end;
End;

Procedure CLS(col : byte; where : word);
Begin
  asm
    push  es
    mov   cx, 32000;
    mov   es,[where]
    xor   di,di
    mov   al,[col]
    mov   ah,al
    rep   stosw
    pop   es
  end;
End;

Procedure WaitRetrace; Assembler;
Label
  l1, l2;
Asm
  mov   dx,3DAh
l1:
  in    al,dx
  and   al,08h
  jnz   l1
l2:
  in    al,dx
  and   al,08h
  jnz   l2
End;

Procedure SetUpVirtScr;
Begin
  GetMem(VirtScr, 64000);
  Vaddr := Seg(VirtScr^);
End;

Procedure DestroyVirtScr;
Begin
  FreeMem(VirtScr, 64000);
End;

Procedure PutPixel(x, y : integer; col : byte; where : word);
Begin
  asm
    mov   ax,[where]
    mov   es,ax
    mov   bx,[X]
    mov   dx,[Y]
    mov   di,bx
    mov   bx, dx
    shl   dx, 8
    shl   bx, 6
    add   dx, bx
    add   di, dx
    mov   al, [Col]
    stosb
  end;
End;

Procedure Flip(Source, Dest : word);
Begin
  asm
    push    ds
    mov     ax, [Dest]
    mov     es, ax
    mov     ax, [Source]
    mov     ds, ax
    xor     si, si
    xor     di, di
    mov     cx, 32000
    rep     movsw
    pop     ds
  end;
End;

function DirSearch(fn, Dir : string) : string;
var
   SR : SearchRec;
   P  : String;
begin
   if dir[length(dir)] <> '\' then Dir := Dir + '\';
   FindFirst(Dir + fn, AnyFile, SR);
   if DosError = 0 then
      begin
         DirSearch := Dir + SR.Name;
         Exit;
      End;
   FindFirst(Dir + '*.*', Directory, SR);
   while DosError = 0 do
      begin
         if (SR.Attr and 16 <> 0 ) and (SR.Name[1]<>'.') then
            begin
               P := DirSearch(fn, Dir + SR.Name);
               if P <> '' then
                  begin
                     DirSearch := P;
                     exit;
                  end;
            end;
         FindNext(SR);
      end;
   DirSearch := '';
end;

function Clock : longint; assembler;
asm
  mov   es,[seg0040]
  mov   ax,es:[6Ch]
  mov   dx,es:[6Eh]
end;

procedure autodetect; far; assembler;
asm
  mov   ax, seg mbk
  mov   es, ax
  mov   di, offset mbk
  mov   ax, $4F00
  int   $10
  cmp   al, $4F
  jnz   @1
  or    ah, ah
  jnz   @1
  xor   ax, ax
  jmp   @2
 @1:
  mov   ax, -11
 @2:
end;

Procedure ReadEx(X, Y : integer; var Str : string; Num : integer;
                                                      Mode : boolean);
Const
   ABC = ['A'..'Z','a'..'z'];
   N12 = ['0'..'9'];
Var
   Key : char;
   S : set of char;
   XX : integer;
Begin
   SetTextJustify(LeftText,BottomText);
   SetFillStyle(SolidFill,0);
   Bar(X, Y, X + 8 * (Num + 1), Y-8);
   SetColor(15);
   XX := X;
   Line(X, Y, X+8, Y);
   Str := '';
   Repeat
      While KeyPressed do ReadKey;
      Key := ReadKey;
      If Mode then S := N12 else S := N12 + ABC;
      If (Key in S) and (length(Str) < Num) then
      Begin
         SetColor(0);
         Bar(X, Y, X + 8 * (Num + 1), Y-8);
         SetColor(15);
         Inc(XX, 8);
         Line(XX, Y, XX+8, Y);
         Str := Str + Key;
         OutTextXY(X,Y,Str);
      End;
      If (Key = #8) and (length(Str) > 0) then
      Begin
         SetColor(0);
         Bar(X, Y, X + 8 * (Num + 1), Y-8);
         SetColor(15);
         Dec(XX, 8);
         Line(XX, Y, XX+8, Y);
         Delete(Str, length(Str), 1);
         OutTextXY(X,Y,Str);
      End;
   Until Key = #13;
   SetColor(0);
   Line(XX, Y, XX+8, Y);
   SetColor(15);
End;

procedure InitEngine;
var
  Driver  : integer;
  a, mode : integer;
begin
  driver := detect;
  mode:=0;
  initgraph(driver, mode, '');
  a := graphresult;
  if a <> grOk then
    begin
      writeln(grapherrormsg(a));
      halt;
    end;
  SetMCGA;
  SetUpVirtScr;
end;

procedure CloseEngine;
begin
  setintvec($61,old61);
  closegraph;
  asm
    mov   ax, 3
    int   $10
  end;
  SetTEXT;
  DestroyVirtScr;
end;

procedure WriteEx(str : string);
const
   tmhor = 80;
var
   i : integer;
begin
   for i := 1 to Length(str) do
   begin
      Delay(1000);
      GoToXY((tmhor - i) div 2, VertPos);
      Write(Copy(str, 1, i));
   end;
   Inc(VertPos);
end;

var
   drv : integer;
   i   : word;
begin
   drv := installUserDriver('VESA',@autodetect);
   if drv = grError then
      begin
         writeln(#7 + 'VESA not found');
         halt;
      end;
   if registerBGIdriver(addr(VESA)) < 0 then
      begin
         writeln(grapherrormsg(graphresult));
         halt;
      end;
   VertPos := 0;
end.