unit arc_lbr;

interface

uses crt,graph;

const
   MaxX = 319;
   MaxY = 199;

function Dialog(caption, text : String) : boolean;
procedure Emblem(Pos : integer);
procedure Victory;
procedure Sorry;

implementation

procedure Sorry;
begin
   ClearDevice;
   SetColor(15);
   OutTextXY(MaxX div 2, MaxY div 3, 'Sorry, but it doesn''t work yet...');
   while KeyPressed do ReadKey;
   ReadKey;
end;

procedure Victory;
var i : integer;
Begin
   ClearDevice;
   For i := 1 to 200 do PutPixel(Random(320), Random(200), Random(256));
   SetTextStyle(5,HorizDir,1);
   SetTextJustify(CenterText,BottomText);
   SetColor(54);
   OutTextXY(MaxX div 2, MaxY div 2 - 10, 'Congratulations !!!');
   OutTextXY(MaxX div 2, MaxY div 2 + 10, 'You have completed this level !!!');
   SetColor(4);
   OutTextXY(MaxX div 2, MaxY div 2 + 50, 'Press escape to continue...');
   Repeat
      while KeyPressed do ReadKey;
   Until ReadKey = #27;
End;

function Dialog(caption, text : String) : boolean;
var
   Size : LongInt;
   x1, x2, y1, y2 : Integer;
   P : Pointer;
   Key : Char;
   Old : TextSettingsType;
begin
   GetTextSettings(Old);
   SetTextJustify(CenterText,BottomText);
   x1 := MaxX div 2 - 100;
   x2 := MaxX div 2 + 100;
   y1 := MaxY div 2 - 40;
   y2 := MaxY div 2 + 40;
   Size := ImageSize(x1, x2, y1, y2);
   GetMem(P, Size);
   GetImage(x1, y1, x2, y2, P^);
   SetFillStyle(SolidFill, 0);
   SetColor(1);
   Bar(x1, y1, x2, y2);
   Rectangle(x1, y1, x2, y2);
   MoveTo(x1 + 5, y1 + 20);
   LineRel(100, 0);
   LineRel(15, -15);
   LineTo(x2 - 5, y1 + 5);
   LineTo(x2 - 5, y2 - 5);
   LineTo(x1 + 5, y2 - 5);
   LineTo(x1 + 5, y1 + 20);
   SetTextStyle(0, HorizDir, 1);
   SetColor (15);
   OutTextXY(x1 + 55, y1 + 15, caption);
   SetTextStyle(2, HorizDir, 5);
   OutTextXY(MaxX div 2, y1 + 40, text);
   SetColor(4);
   OutTextXY(MaxX div 2, y1 + 60, 'Yes (Y)    /    No (N)');
   repeat
      Key := UpCase(ReadKey);
   until (Key = 'Y') OR (Key = 'N');
   PutImage(x1, y1, P^, NormalPut);
   FreeMem(P, Size);
   if Key = 'Y' then Dialog := true else Dialog := false;
   SetTextJustify(Old.Horiz,Old.Vert);
end;

procedure Emblem(Pos : integer);
begin
GoToXY(14, Pos + 0); Write('ͻ                                     ͻ');
GoToXY(14, Pos + 1); Write('ͻ                      *            ͻ');
GoToXY(14, Pos + 2); Write('ȼ      ķ   ķ  ķ  ķ    ȼ');
GoToXY(14, Pos + 3); Write('ͼ    Ľ Ķ Ľ      ͼ');
GoToXY(14, Pos + 4); Write('ͼ    Ľ     ͼ');

{}
end;

begin
end.