Program Labyrinth;

{$M 16384, 0, 655360}
{$I-}
uses crt, dos, Graph, arc_sys, arc_lbr, arc_kbd;

const
   ecw = 15;            {Wall Color         (level editor)}
   ecs = 0;             {Space Color        (level editor)}
   ecb = 1;             {Start Point Color  (level editor)}
   ecf = 2;             {Finish Point Color (level editor)}
   ecm = 40;            {Marker Color       (level editor)}

   gcw = 39;            {Wall Color         (game)}
   gcg = 184;           {Border Line Color  (game)}
   gcf = 54;            {Finish Point Color (game)}
   gc1 = 53;            {Ceiling Color      (game)}
   gc2 = 120;           {Floor Color        (game)}

var
   DisToHght : array [1..15000] of integer; {                   }
   AngToX    : array [1..1920]  of integer; {                   }
   AngToY    : array [1..1920]  of integer; {  arrays for basic }
   RenderMas : array [0..319]   of integer; {    calculations   }
   ColorMas  : array [0..319]   of byte;    {                   }

   KBD       : keyboardObj;                 {Keyboard object}

procedure Init;
const
   SVertPos = 23;      {Starting vertical position of text}
begin
   TextMode(259);      {Font 8x8}
   VertPos := SVertPos;
   ClrScr;
   TextColor(1);
   Emblem(7);
   TextColor(2);
   WriteEx('    "Labyrinth" (c)   Version 1,03 Final');
   WriteEx('"Labyrinth Engine" (c)   Version 1,02 Final  ');
   WriteEx('Made by Anton Maximov in 2005');
   WriteEx('All rights reserved');
   Inc(VertPos);
   WriteEx('This program uses VESA graphic driver in resolution 320x200x256');
   Inc(VertPos);
   TextColor(4);
   WriteEx('Welcome to Labyrinth !!!');
   TextColor(2);
   Inc(VertPos);
   WriteEx('Seting up graphic mode... Press any key to start');
   while KeyPressed do ReadKey;        {Clearing keyboard buffer}
   ReadKey;                            {and reading a key :)    }
   InitEngine;
end;

function Menu : Integer;       {This function is for all graphic modes}
                               {External values: MaxX, MaxY           }
                               {Uses: graph, crt                      }
const
   n = 5;              {Number of buttons}
var
   Bars       : array [1..n] of String;
   i,Sel,ButY : Integer;
   Key        : Char;
begin
   ClearDevice;
   Bars[1] := 'Start "Labyrinth"'; {                  }
   Bars[2] := 'Level Editor';      {                  }
   Bars[3] := 'Options';           {  Menu Buttons    }
   Bars[4] := 'Help';              {                  }
   Bars[5] := 'Exit';              {                  }
   SetTextJustify(1,0);
   SetTextStyle(4,HorizDir,7);
   SetColor(180);
   OutTextXY(MaxX div 2,MaxY div 4 - 6,'Labyrinth'); {                  }
   OutTextXY(MaxX div 2,MaxY div 4 - 4,'Labyrinth'); {                  }
   OutTextXY(MaxX div 2,MaxY div 4 - 2,'Labyrinth'); {  Main Caption    }
   SetColor(108);                                    {                  }
   OutTextXY(MaxX div 2,MaxY div 4,'Labyrinth');     {                  }
   SetTextStyle(5,HorizDir,1);
   Sel := 1;                {Selected button}
   ButY := MaxY * 2 div 5;  {Where buttons appear}
   while KeyPressed do ReadKey;
   repeat
      for i := 1 to n do
      begin
         SetColor(8);
         OutTextXY(MaxX div 2 + 1, ButY + 1 + i * 20, Bars[i]);
         SetColor(1);
         OutTextXY(MaxX div 2, ButY + i * 20, Bars[i]);
      end;
      SetColor(4);
      OutTextXY(MaxX div 2 + 1, ButY + 1 + Sel * 20, Bars[Sel]);
      SetColor(9);
      OutTextXY(MaxX div 2, ButY + Sel * 20, Bars[Sel]);
      Key := ReadKey;
      if Key = #72 then          {Up_key have been pressed}
      begin
         Dec(Sel);
         If Sel < 1 then Sel := n;
      end;
      if Key = #80 then          {Down_key have been prassed}
      begin
         Inc(Sel);
         if Sel > n then Sel := 1;
      end;

   until Key = #13;              {Enter_key have been pressed}
   Menu := Sel;             {Returns value}
end;

{===========================================================================}
{===========================================================================}

Procedure LevelEditor;

Var
   Height,Width,ZoneX,ZoneY : integer;
   MarkFlag,X,Y,i,j         : integer;
   StartX,StartY,EndX,EndY  : integer;
   Trigger,Ret,DoneEd, Err  : boolean;
   Level : array [1..50, 1..50] of word;
   FileName : String;
   Sp       : PathStr;
   Key      : char;
   LevFile  : Text;
   St,sX,sY : String;
   n        : longint;

   {Shows name of level file in left top of the screen}
   Procedure FileNameShow;
   Begin
      SetColor(2);
      Bar(5,0,105,10);
      Rectangle(5,0,105,10);
      SetColor(7);
      SetTextStyle(0,HorizDir,1);
      SetTextJustify(CenterText,BottomText);
      OutTextXY(55,10,FileName);
   End;

   {Shows a trigger flag in right top of the screen}
   Procedure TriggerShow;
   Begin
      SetColor(2);
      Rectangle(MaxX - 5,0,MaxX - 105,10);
      If Trigger then
      Begin
         SetFillStyle(SolidFill, 15);
         SetColor(0);
      End
         else
         Begin
            SetFillStyle(SolidFill, 0);
            SetColor(7);
         End;
      Bar(MaxX - 6, 1, MaxX- 104, 9);
      SetTextStyle(0,HorizDir,1);
      SetTextJustify(CenterText,BottomText);
      If Trigger then OutTextXY(MaxX - 55, 10, 'Trigger: On')
         Else OutTextXY(MaxX - 55, 10, 'Trigger: Off');
   End;

   {Shows coordinates in bottom of the screen}
   Procedure CorShow;
   Begin
     SetFillStyle(SolidFill,0);
     Bar(10,MaxY-10,MaxX-10,MaxY-2);
     SetColor(15);
     Str(X,sX);
     Str(Y,sY);
     OutTextXY(MaxX div 2, MaxY - 2, 'X: '+sX+'   Y:'+sY);
   End;

Begin
{===========================================================================}
   DoneEd := false;
   FileName := 'NONAME.LBR';
   Trigger := false;
   CLS(0, VGA);
   SetColor(1);
   Rectangle(1, 2, MaxX - 1, MaxY - 1);
   Rectangle(3, 8, MaxX - 3, MaxY - 13);
   SetColor(2);
   SetFillStyle(EmptyFill, 0);
   Bar(MaxX div 2 - 50, 0, MaxX div 2 + 50, 10);
   Rectangle(MaxX div 2 - 50, 0, MaxX div 2 + 50, 10);
   SetColor(9);
   SetTextStyle(0,HorizDir,1);
   SetTextJustify(CenterText,BottomText);
   OutTextXY(MaxX div 2, 10, 'Level Editor');
   TriggerShow;
   FileNameShow;
{===========================================================================}
   SetColor(15);
   OutTextXY(MaxX div 2,40,'1 - Open and edit old file');
   OutTextXY(MaxX div 2,50,'2 - Create a new file     ');
   OutTextXY(MaxX div 2,60,'3 - Back to menu          ');
   Repeat
      While KeyPressed do ReadKey;
      Key := ReadKey;
   Until (Key = '1') or (Key = '2') or (Key = '3');
   SetFillStyle(EmptyFill, 0);
   Bar(20,20,MaxX-20,MaxY-20);
{===========================================================================}
   If Key = '3' then Exit;
{===========================================================================}
   If Key = '1' then
   Begin
      OutTextXY(MaxX div 2,25,'Enter the name of a level file');
      OutTextXY(MaxX div 2,35,'(9 chars max):');
      SetColor(14);
      Rectangle(MaxX div 2 - 70, 39, MaxX div 2 + 70, 51);
      Line(MaxX div 2 - 59, 39, MaxX div 2 - 59, 51);
      Line(MaxX div 2 + 36, 39, MaxX div 2 + 36, 51);
      SetColor(15);
      OutTextXy(MaxX div 2 + 52, 50, '.LBR');
      OutTextXy(MaxX div 2 - 64, 50, '>');
      Repeat
         ReadEx(MaxX div 2 - 55, 50, FileName, 9, false);
      Until FileName <> '';
      SetTextJustify(CenterText,BottomText);
      FileName := FileName + '.LBR';
      Sp := FSearch(FileName, '');
      If Sp = '' then
      Begin
         OutTextXY(MaxX div 2, 70, 'File not found. Press any key...');
         While KeyPressed do ReadKey;
         ReadKey;
         Exit;
      End
      Else
      Begin
         OutTextXY(MaxX div 2,70,'OK. Start loading level.');
         OutTextXY(MaxX div 2,80,'Press any key...');
         While KeyPressed do ReadKey;
         ReadKey;
         Err := false;
         Repeat
            Assign(LevFile, FileName);
            Reset(LevFile);
            If NOT (IOResult > 0) then
            Begin
               ReadLn(LevFile,Width);
               ReadLn(LevFile,Height);
               ReadLn(LevFile,StartX);
               ReadLn(LevFile,StartY);
               ReadLn(LevFile,EndX);
               ReadLn(LevFile,EndY);
               For j := 1 to Height do
                  For i := 1 to Width do
                     ReadLn(LevFile,Level[i, j]);
               Close(LevFile);
               Ret := false;
            End
            Else
            Begin
               Ret := Dialog('Warning !!!','File ERROR !  Retry ?');
               SetTextStyle(0,HorizDir,1);
               SetColor(15);
               Err := NOT Ret;
            End;
         Until not Ret;
         If Err then
         Begin
            OutTextXY(MaxX div 2, 100, 'I/O Error. Press any key...');
            While KeyPressed do ReadKey;
            ReadKey;
            Exit;
         End;
      End;
      Bar(20,15,MaxX-20,MaxY-20);
   End;
{===========================================================================}
   If Key = '2' then
   Begin
      OutTextXY(MaxX div 2,25,'Enter the name of a new level file');
      OutTextXY(MaxX div 2,35,'(9 chars max):');
      SetColor(14);
      Rectangle(MaxX div 2 - 70, 39, MaxX div 2 + 70, 51);
      Line(MaxX div 2 - 59, 39, MaxX div 2 - 59, 51);
      Line(MaxX div 2 + 36, 39, MaxX div 2 + 36, 51);
      SetColor(15);
      OutTextXy(MaxX div 2 + 52, 50, '.LBR');
      OutTextXy(MaxX div 2 - 64, 50, '>');
      Repeat
         ReadEx(MaxX div 2 - 55, 50, FileName, 9, false);
      Until FileName <> '';
      SetTextJustify(CenterText,BottomText);
      FileName := FileName + '.LBR';
      OutTextXY(MaxX div 2,70,'Enter the width of labyrinth (5-50): ');
      SetColor(14);
      Rectangle(MaxX div 2 - 25, 79, MaxX div 2 + 25, 91);
      Line(MaxX div 2 - 14, 79, MaxX div 2 - 14, 91);
      SetColor(15);
      OutTextXy(MaxX div 2 - 19, 90, '>');
      Repeat
         ReadEx(MaxX div 2 - 10,90,St, 3, true);
         Val(St, Width, MarkFlag);
      Until (Width >= 5) and (Width <= 50);
      SetTextJustify(CenterText,BottomText);
      OutTextXY(MaxX div 2,110,'Enter the height of labyrinth (5-50): ');
      SetColor(14);
      Rectangle(MaxX div 2 - 25, 119, MaxX div 2 + 25, 131);
      Line(MaxX div 2 - 14, 79, MaxX div 2 - 14, 91);
      SetColor(15);
      OutTextXy(MaxX div 2 - 19, 130, '>');
      Repeat
         ReadEx(MaxX div 2 - 10,130,St, 3, true);
         Val(St, Height, MarkFlag);
      Until (Height >= 5) and (Height <= 50);
      SetTextJustify(CenterText,BottomText);
      Bar(5,15,MaxX-5,MaxY-20);
      For i := 1 to Width do
         For j := 1 to Height do
            Level[i, j] := ecs;
      For i := 1 to Width do
      Begin
         Level[i,1] := ecw;
         Level[i,Height] := ecw;
      End;
      For j := 1 to Width do
      Begin
         Level[1,j] := ecw;
         Level[Width,j] := ecw;
      End;
      StartX := 0;
      StartY := 0;
      EndX := 0;
      EndY := 0;
   End;
{===========================================================================}
   FileNameShow;
   SetTextStyle(0, HorizDir, 1);
   ZoneX := 15;
   ZoneY := 25;
   SetColor(14);
   Rectangle(ZoneX, ZoneY, ZoneX + 3 * Width, ZoneY + 3 * Height);
   For i := 1 to Height - 1 do
      Line(ZoneX, ZoneY + 3 * i, ZoneX + 3 * Width, ZoneY + 3 * i);
   For i := 1 to Width - 1 do
      Line(ZoneX + 3 * i, ZoneY, ZoneX + 3 * i, ZoneY + 3 * Height);
   SetColor(10);
   Rectangle(ZoneX - 2, ZoneY - 2,
      ZoneX + 3 * Width + 2, ZoneY + 3 * Height + 2);
{===========================================================================}
   For j := 1 to Height do
      For i := 1 to Width do
      Begin
         SetFillStyle(SolidFill, Level[i, j]);
         FloodFill(ZoneX - 1 + 3 * i, ZoneY - 1 + 3 * j, 14);
      End;
   if (StartX<>0)and(StartY<>0)and(EndX<>0)and(EndY<>0) then
   begin
      SetColor(ecb);
      Rectangle(ZoneX+3*StartX, ZoneY+3*StartY,
                ZoneX+3*StartX-3, ZoneY+3*StartY-3);
      SetColor(ecf);
      Rectangle(ZoneX+3*EndX, ZoneY+3*EndY,
                ZoneX+3*EndX-3, ZoneY+3*EndY-3);
   end;
{===========================================================================}
   SetColor(75);
   Rectangle(200,25,300,175);
   SetTextJustify(LeftText,BottomText);
   SetColor(103);
   OutTextXY(205,40,'Arrows');
   SetColor(15);
   OutTextXY(215,50,'Moving');
   SetColor(103);
   OutTextXY(205,60,'Space');
   SetColor(15);
   OutTextXY(215,70,'Set wall');
   SetColor(103);
   OutTextXY(205,80,'Tab');
   SetColor(15);
   OutTextXY(215,90,'Trigger');
   SetColor(103);
   OutTextXY(205,100,'1');
   SetColor(15);
   OutTextXY(215,110,'Set start');
   SetColor(103);
   OutTextXY(205,120,'2');
   SetColor(15);
   OutTextXY(215,130,'Set finish');
   SetColor(103);
   OutTextXY(205,140,'Enter');
   SetColor(15);
   OutTextXY(215,150,'Save');
   SetColor(103);
   OutTextXY(205,160,'Esc');
   SetColor(15);
   OutTextXY(215,170,'Exit');
   SetTextJustify(CenterText,BottomText);
{===========================================================================}
   X := 2; Y := 2;
   While KeyPressed do ReadKey;
   n := 0;
   MarkFlag := 0;
   CorShow;
   Repeat
      Key := #0;
      If (Clock > n + 5) then
      Begin
         n := Clock;
         MarkFlag := 1 - MarkFlag;
         If MarkFlag <> 0 then
            SetColor(ecm)
         else
            SetColor(Level[X, Y]);
         Rectangle(ZoneX+X*3-2, ZoneY+Y*3-2, ZoneX+X*3-1, ZoneY+Y*3-1);
      End;
      If KeyPressed then Key := ReadKey;
      {Up_key have been pressed}
      If Key = #72 then
      Begin
         SetColor(Level[X, Y]);
         Rectangle(ZoneX+X*3-2, ZoneY+Y*3-2, ZoneX+X*3-1, ZoneY+Y*3-1);
         Dec(Y);
         If Y <= 1 then Y := 2
            else If Trigger and not (((StartX=X) and (StartY=Y)) or ((EndX=X)
                    and (EndY=Y))) then
                    If Level[X, Y] = ecs then Level[X, Y] := ecw
                       else Level[X, Y] := ecs;
         SetColor(ecm);
         Rectangle(ZoneX+X*3-2, ZoneY+Y*3-2, ZoneX+X*3-1, ZoneY+Y*3-1);
         CorShow;
      End;
      {Down_key have been pressed}
      If Key = #80 then
      Begin
         SetColor(Level[X, Y]);
         Rectangle(ZoneX+X*3-2, ZoneY+Y*3-2, ZoneX+X*3-1, ZoneY+Y*3-1);
         Inc(Y);
         If Y >= Height then Y := Height - 1
         else If Trigger and not (((StartX=X) and (StartY=Y)) or ((EndX=X)
                    and (EndY=Y))) then
                 If Level[X, Y] = ecs then Level[X, Y] := ecw
                 else Level[X, Y] := ecs;
         SetColor(ecm);
         Rectangle(ZoneX+X*3-2, ZoneY+Y*3-2, ZoneX+X*3-1, ZoneY+Y*3-1);
         CorShow;
      End;
      {Left_key have been pressed}
      If Key = #75 then
      Begin
         SetColor(Level[X, Y]);
         Rectangle(ZoneX+X*3-2, ZoneY+Y*3-2, ZoneX+X*3-1, ZoneY+Y*3-1);
         Dec(X);
         If X <= 1 then X := 2
            else If Trigger and not (((StartX=X) and (StartY=Y)) or ((EndX=X)
                    and (EndY=Y))) then
                    If Level[X, Y] = ecs then Level[X, Y] := ecw
                       else Level[X, Y] := ecs;
         SetColor(ecm);
         Rectangle(ZoneX+X*3-2, ZoneY+Y*3-2, ZoneX+X*3-1, ZoneY+Y*3-1);
         CorShow;
      End;
      {Right_key have been pressed}
      If Key = #77 then
      Begin
         SetColor(Level[X, Y]);
         Rectangle(ZoneX+X*3-2, ZoneY+Y*3-2, ZoneX+X*3-1, ZoneY+Y*3-1);
         Inc(X);
         If X >= Width then X := Width - 1
            else If Trigger and not (((StartX=X) and (StartY=Y)) or ((EndX=X)
                    and (EndY=Y))) then
                    If Level[X, Y] = ecs then Level[X, Y] := ecw
                       else Level[X, Y] := ecs;
         SetColor(ecm);
         Rectangle(ZoneX+X*3-2, ZoneY+Y*3-2, ZoneX+X*3-1, ZoneY+Y*3-1);
         CorShow;
      End;
      {Space_key have been pressed}
      If (Key = #32) and not (((StartX=X) and (StartY=Y)) or ((EndX=X)
                    and (EndY=Y))) then
      Begin
         If Level[X, Y] = ecs then Level[X, Y] := ecw
            else Level[X, Y] := ecs;
      End;
      {Tab_key have been pressed}
      If Key = #9 then
      Begin
         If Trigger then Trigger := false
            else Trigger := true;
         If Trigger and not (((StartX=X) and (StartY=Y)) or ((EndX=X)
                    and (EndY=Y))) then
            If Level[X, Y] = ecs then Level[X, Y] := ecw
               else Level[X, Y] := ecs;
         TriggerShow;
      End;
      {Esc_key have been pressed}
      If Key = #27 then
      Begin
         DoneEd := Dialog('Warning !!!', 'Realy quit ?');
      End;
      {1_key have been pressed}
      If (Key = '1') and (Level[X,Y] = ecs) then
      Begin
         if (StartX<>0)and(StartY<>0) then
         begin
            SetColor(14);
            Rectangle(ZoneX+3*StartX, ZoneY+3*StartY,
                      ZoneX+3*StartX-3, ZoneY+3*StartY-3);
         end;
         StartX := X;
         StartY := Y;
         SetColor(ecb);
         Rectangle(ZoneX+3*StartX, ZoneY+3*StartY,
                   ZoneX+3*StartX-3, ZoneY+3*StartY-3);
      End;
      {2_key have been pressed}
      If (Key = '2') and (Level[X,Y] = ecw) then
      Begin
         if (EndX<>0)and(EndY<>0) then
         begin
            SetColor(14);
            Rectangle(ZoneX+3*EndX, ZoneY+3*EndY,
                      ZoneX+3*EndX-3, ZoneY+3*EndY-3);
         end;
         EndX := X;
         EndY := Y;
         SetColor(ecf);
         Rectangle(ZoneX+3*EndX, ZoneY+3*EndY,
                   ZoneX+3*EndX-3, ZoneY+3*EndY-3);
      End;
      {Enter_key have been pressed}
      If Key = #13 then
      Begin
         If (StartX<>0) and (StartY<>0) and (EndX<>0) and (EndY<>0) and
            Dialog('Warning !!!', 'Save ?') then
         Begin
            Ret := true;
            Repeat
               Assign(LevFile, FileName);
               Rewrite(LevFile);
               If NOT (IOResult > 0) then
               Begin
                  WriteLn(LevFile, Width);
                  WriteLn(LevFile, Height);
                  WriteLn(LevFile, StartX);
                  WriteLn(LevFile, StartY);
                  WriteLn(LevFile, EndX);
                  WriteLn(LevFile, EndY);
                  For j := 1 to Height do
                     For i := 1 to Width do
                        WriteLn(LevFile, Level[i, j]);
                  Close(LevFile);
                  Ret := false;
               End
               Else
                  Ret := Dialog('Error !!!', 'File ERROR !  Retry ?');
            Until NOT Ret;
         End;
      End;
   Until DoneEd;
End;

{===========================================================================}
{===========================================================================}
{===========================================================================}
Procedure Game;
Const
   Dim = 100;
Var
   Level                             : array [1..100, 1..70] of word;
   iX1, iX2, iY1, iY2, EndX, EndY    : integer;
   Width, Height, cx, StartX, StartY : integer;
   n, n1, n2, i, j, i1, i2, dX, dY   : integer;
   X, Y, WorldX, WorldY, iX, iY, jX  : integer;
   Ang, An, S, T, D, E               : integer;
   Done                              : boolean;
   Dis, DisX, DisY                   : longint;
   Si, Co, Act                       : integer;


   Function Start : boolean;
   Var
      FileName      : string;
      Dir, SrchDir  : pathstr;
      LevFile       : text;
      i, j          : integer;
      Ret           : boolean;
   Begin
      CLS(0,VGA);
      SetColor(15);
      SetTextStyle(DefaultFont,HorizDir,1);
      SetTextJustify(CenterText,BottomText);
      OutTextXY(MaxX div 2,30,'Enter name of level file:');
      SetColor(14);
      Rectangle(MaxX div 2 - 70, 39, MaxX div 2 + 70, 51);
      Line(MaxX div 2 - 59, 39, MaxX div 2 - 59, 51);
      Line(MaxX div 2 + 36, 39, MaxX div 2 + 36, 51);
      SetColor(15);
      OutTextXy(MaxX div 2 + 52, 50, '.LBR');
      OutTextXy(MaxX div 2 - 64, 50, '>');
      Repeat
         ReadEx(MaxX div 2 - 55, 50, FileName, 9, false);
      Until FileName <> '';
      SetTextStyle(DefaultFont,HorizDir,1);
      SetTextJustify(CenterText,BottomText);
      FileName := FileName + '.lbr';
      GetDir(0, Dir);
      SrchDir := FSearch(FileName, Dir);
      If SrchDir = '' then
      Begin
         OutTextXY(MaxX div 2,70,'File not found. Press any key...');
         While KeyPressed do ReadKey;
         ReadKey;
         Start := false;
         Exit;
      End
      Else
      Begin
         OutTextXY(MaxX div 2,70,'OK. Starting loading level...');
         While KeyPressed do ReadKey;
         ReadKey;
         Assign(LevFile, FileName);
         Reset(LevFile);
         If NOT (IOResult > 0) then
         Begin
            ReadLn(LevFile, Width);
            ReadLn(LevFile, Height);
            ReadLn(LevFile, StartX);
            ReadLn(LevFile, StartY);
            ReadLn(LevFile, EndX);
            ReadLn(LevFile, EndY);
            For j := 1 to Height do
               For i := 1 to Width do
                  ReadLn(LevFile, Level[i, j]);
            Close(LevFile);
            Ret := false;
         End
         Else
            Ret := Dialog('Error !!!', 'File ERROR !  Retry ?');
      End;
      Start := true;
   End;
   Procedure Loading;
   Var
      x1,x2,y1,y2 : integer;
      text        : string;
      Fir,Sec     : boolean;
      Alpha       : real;
      i,n1,n2,pos : integer;
   Begin
      x1 := MaxX div 2 - 100;
      x2 := MaxX div 2 + 100;
      y1 := MaxY div 2 - 35;
      y2 := MaxY div 2 + 35;
      SetFillStyle(SolidFill, 0);
      SetColor(1);
      Bar(x1, y1, x2, y2);
      Rectangle(x1, y1, x2, y2);
      MoveTo(x1 + 5, y1 + 20);
      LineRel(75, 0);
      LineRel(15, -15);
      LineTo(x2 - 5, y1 + 5);
      LineTo(x2 - 5, y2 - 5);
      LineTo(x1 + 5, y2 - 5);
      LineTo(x1 + 5, y1 + 20);
      SetTextStyle(2, HorizDir, 4);
      SetTextJustify(CenterText,BottomText);
      SetColor(15);
      OutTextXY(x1 + 40, y1 + 15, 'Loading . . .');
      SetFillStyle(SolidFill, 0);
      SetTextStyle(0, HorizDir, 1);
      n1 := 0;
      n2 := 0;
      Fir := false;
      Sec := false;
      SetColor(3);
      SetTextJustify(LeftText,BottomText);
      Rectangle(x1+10,y1+35,x2-10,y1+45);
      i := 0;
      SetFillStyle(SolidFill, 36);
      Repeat
         Bar(x1+13,y1+37,x1+13+trunc(i / 16920 * (x2-x1-25)),y1+43);
         If (i mod 495 = 0) and (i <> 0) then
         Delay(2);
         If NOT Fir then
         Begin
            Inc(n1);
            Alpha := 2 * Pi * n1 / 1920;
            AngToX[n1]  := Trunc(Cos(Alpha) * 500 + 0.5);
            AngToY[n1]  := Trunc(Sin(Alpha) * 500 + 0.5);
            If n1 >= 1920 then Fir := true;
            Inc(i);
         End;
         If Fir AND (NOT Sec) then
         Begin
            Inc(n2);
            Alpha := ArcTan(50 / n2);
            DisToHght[n2] := Trunc(3840 * Alpha / (Pi * 2) + 0.5);
            If DisToHght[n2] > (MaxY div 2) then DisToHght[n2] := MaxY div 2;
            If n2 >= 15000 then Sec := true;
            Inc(i);
         End;
      Until (Fir = true) AND (Sec = true);
      SetColor(40);
      SetTextJustify(CenterText,BottomText);
      OutTextXY(MaxX div 2, y1 + 60, 'Complete...');
      While KeyPressed do ReadKey;
      ReadKey;
   End;


Begin
   If NOT Start then Exit;
   CLS(0, VGA);
   Loading;
   KBD.Init;
   WorldX := StartX * 100 - 50;
   WorldY := StartY * 100 - 50;
   Ang := 0;
   Act := 1;
 Repeat
   Act := 3 - Act;
   {***---***}
   i1 := Ang - 160;
   i2 := Ang + 159;
   jX := 0;
   For i := i1 to i2 do
   Begin
      An := i;
      If An < 1 then An := An + 1920;
      If An > 1920 then An := An - 1920;
      X := AngToX[An] + WorldX;
      Y := AngToY[An] + WorldY;
      If Abs(X - WorldX) >= Abs(Y - WorldY) then
      Begin
         S := Abs(X - WorldX);
         T := Abs(Y - WorldY);
         iY := WorldY;
         iX := WorldX;
         Done := false;
         If WorldX < X then dX := 1;
         If WorldX > X then dX := -1;
         If WorldX = X then dX := 0;
         If WorldY < Y then dY := 1;
         If WorldY > Y then dY := -1;
         If WorldY = Y then dY := 0;
         D := 0;
         Repeat
            iX := iX + dX;
            D := D + T;
            E := D - S;
            If E >= 0 then
            Begin
               iY := iY + dY;
               D := E;
            End;
         Until Level[iX div 100 + 1, iY div 100 + 1] = ecw;
      End
      Else
      Begin
         S := Abs(Y - WorldY);
         T := Abs(X - WorldX);
         iY := WorldY;
         iX := WorldX;
         Done := false;
         If WorldX < X then dX := 1;
         If WorldX > X then dX := -1;
         If WorldX = X then dX := 0;
         If WorldY < Y then dY := 1;
         If WorldY > Y then dY := -1;
         If WorldY = Y then dY := 0;
         D := 0;
         Repeat
            iY := iY + dY;
            D := D + T;
            E := D - S;
            If E >= 0 then
            Begin
               iX := iX + dX;
               D := E;
            End;
         Until Level[iX div 100 + 1, iY div 100 + 1] = ecw;
      End;

      If Ang < 1 then Ang := Ang + 1920;
      If Ang > 1920 then Ang := Ang - 1920;

      DisX := iX - WorldX;
      DisY := iY - WorldY;
      Co   := AngToX[Ang];
      Si   := AngToY[Ang];
      Dis  := (DisX * Co + DisY * Si) div 500;
      RenderMas[jX] := DisToHght[dis];
      if (iX div 100 + 1 = EndX) and (iY div 100 + 1 = EndY) then
         ColorMas[jX] := Random(4)+32
      else
         ColorMas[jX] := gcw;

      if (iX<>iX1) and (iY<>iY1) and (jX>0) then
      begin
         if RenderMas[jX-1] > RenderMas[jX] then
            ColorMas[jX-1] := gcg
         else
            ColorMas[jX] := gcg;
      end;
      if ((iX2=iX1) or (iY2=iY1)) and ((iX=iX1) or (iY=iY1))
         and ((iX<>iX2) and (iY<>iY2)) and (jX>1) then
         ColorMas[jX-1] := gcg;
      if (iX<>iX1) and (iY<>iY1) then
      Begin
         iX1 := iX;
         iY1 := iY;
      End;
      if (iX2<>iX1) and (iY2<>iY1) then
      Begin
         iX2 := iX1;
         iY2 := iY1;
      End;
      Inc(jX);
   End;

   CLS(0, Vaddr);
   For i := 0 to 319 do
      For j := 100 to 199 do
         PutPixel(i,j,gc2,Vaddr);
   For i := 0 to 319 do
      For j := 0 to 99 do
         PutPixel(i,j,gc1,Vaddr);
   For i := 0 to 319 do
   Begin
      PutPixel(i, 100 - RenderMas[i]-1, gcg, Vaddr);
      PutPixel(i, 100 + RenderMas[i], gcg, Vaddr);
      For j := 100 - RenderMas[i] to 100 + RenderMas[i]-1 do
        if ((iX div 100 + 1) mod 2) + ((iY div 100 + 1) mod 2) = 2 then
         PutPixel(i,j,ColorMas[i],Vaddr) else PutPixel(i,j,ColorMas[i],Vaddr);
   End;
   waitretrace;
   Flip(Vaddr, VGA);
   if KBD.Down(kUARROW) then
   begin
     iX := WorldX;
     iY := WorldY;
     Inc(iX, AngToX[ang] div 40);
     Inc(iY, AngToY[ang] div 40);
     if NOT (Level[iX div 100+1, iY div 100+1] = ecw) then
     Begin
       WorldX := iX;
       WorldY := iY;
     End
     else if (iX div 100 + 1 = EndX) and (iY div 100 + 1 = EndY) then
          Begin
             KBD.Done;
             Victory;
             Exit;
          End;
   end;
   if KBD.Down(kDARROW) then
   begin
     iX := WorldX;
     iY := WorldY;
     Dec(iX, AngToX[ang] div 40);
     Dec(iY, AngToY[ang] div 40);
     if NOT (Level[iX div 100+1, iY div 100+1] = ecw) then
     Begin
       WorldX := iX;
       WorldY := iY;
     End
     else if (iX div 100 + 1 = EndX) and (iY div 100 + 1 = EndY) then
          Begin
             KBD.Done;
             Victory;
             Exit;
          End;
   end;
   if KBD.Down(kRARROW) then
   begin
     Inc(ang, 15);
   end;
   if KBD.Down(kLARROW) then
   begin
     Dec(ang, 15);
   end;
  Until KBD.Down(kESC);
  KBD.Done;
End;
{===========================================================================}
{===========================================================================}
{===========================================================================}

Var
   Don : boolean;
Begin
{}   Init;
   Repeat
      Case Menu of
         1: Game;
         2: LevelEditor;
         3: Sorry;
         4: Sorry;
         5: Don := true;
      End;
   Until Don;
   CloseEngine;

End.