//   -  
uses Windows, WinDos, KlComm, MyTimer, debug;

function KlInit_1      conv arg_stdcall (var KlInfo : tKlInfo) : boolean;                                    external 'KlPlayer1.dll' name 'KlInit';  //  1- 
function KlGetTurn_1   conv arg_stdcall (MyHoles, OppHoles : tHoles; MyKalah, OppKalah : longint) : longint; external 'KlPlayer1.dll' name 'KlGetTurn';
procedure KlOppTurn_1  conv arg_stdcall(OppTurn : longint);                                                  external 'KlPlayer1.dll' name 'KlOppTurn';
procedure KlEndRound_1 conv arg_stdcall (MyBones, OppBones, NumTurns : longint);                             external 'KlPlayer1.dll' name 'KlEndRound';
procedure KlDone_1     conv arg_stdcall;                                                                     external 'KlPlayer1.dll' name 'KlDone';

function KlInit_2      conv arg_stdcall (var KlInfo : tKlInfo) : boolean;                                    external 'KlPlayer2.dll' name 'KlInit';  //  2- 
function KlGetTurn_2   conv arg_stdcall (MyHoles, OppHoles : tHoles; MyKalah, OppKalah : longint) : longint; external 'KlPlayer2.dll' name 'KlGetTurn';
procedure KlOppTurn_2  conv arg_stdcall(OppTurn : longint);                                                  external 'KlPlayer2.dll' name 'KlOppTurn';
procedure KlEndRound_2 conv arg_stdcall (MyBones, OppBones, NumTurns : longint);                             external 'KlPlayer2.dll' name 'KlEndRound';
procedure KlDone_2     conv arg_stdcall;                                                                     external 'KlPlayer2.dll' name 'KlDone';

type
  tKlInit = function conv arg_stdcall (var KlInfo : tKlInfo) : boolean;
  tKlGetTurn = function conv arg_stdcall (MyHoles, OppHoles : tHoles; MyKalah, OppKalah : longint) : longint;
  tKlOppTurn = procedure conv arg_stdcall(OppTurn : longint);
const
  NumHoles : longint = 6; //     (3-6),     /h:N  (N -  )
  NumBones : longint = 6; //       (3-6),     /b:N  (N -  )
  NumRounds : longint = 1; //   (  ),     /r:N  (N -  )
  MaxTurns : longint = 300; //  ,     (  ),     /t:N  (N -  )
  OutFile : string = 'KlLog.txt'; //  ,   -  ,     /f:xxxxxx.txt
  LogLevels : array[0..2]of longint = (3,3,3);//   -.     /l:NM,  N  M - : N=0  "", N=1  N=2  "",
// M -  0  5: (0 - -  , 1 -     (KlDone), 2 -     (KlEndRound),
// 3 -    , 4 -    , 5 -  )
  Params : array[1..2]of longint = (0,0); //  ,  ""     10- /p:1=12345  16- /p:2:$12ab  /p=1:12abh 
var
  LogLevel0 : longint absolute LogLevels; //  ""   -.
  KlInfo12 : array[1..2]of tKlInfo; //     
  Holes1, Holes2 : tHoles; //   
  Kalah1, Kalah2 : longint; //  
  CurrPlayer : longint; //  : 1  2
  EndGame : boolean; // ,    
  CurrTurn : longint; //  
  CurrRound : longint; //  
  t : text;       //  
  KI  : array[1..2]of tKlInit;
  KGT : array[1..2]of tKlGetTurn;
  KOT : array[1..2]of tKlOppTurn;

procedure PrintState(CP,CT,NP : longint); //    
var i : longint;
begin
  writeln(t,CP,' ------------------ ',CT:1,' -----------------');
  write(t,CP,' Player 2: ',Kalah2:2,'  ');
  for i := NumHoles downto 1 do
    write(t,Holes2[i]:3);
  writeln(t);
  write(t,CP,' Player 1: ','  ','  ');
  for i := 1 to NumHoles do
    write(t,Holes1[i]:3);
  writeln(t,'   ',Kalah1:2);
  writeln(t,CP,' --------------------------------------');
end;

procedure CheckGame; // ,     
var i,n1,n2 : longint;
begin
  EndGame := (Kalah1 > (NumHoles*NumBones)) or (Kalah2 > (NumHoles*NumBones));
  if not EndGame then begin
    n1 := 0;
    n2 := 0;
    for i := 1 to NumHoles do begin
      inc(n1, Holes1[i]);
      inc(n2, Holes2[i]);
    end;
    EndGame := (n1*n2) = 0;
  end;
end;

procedure Turn(var MyHoles, OppHoles : tHoles; var MyKalah, OppKalah : longint); //  (    ) 
var
  i,j,bns,j1 : longint;
  NewPlayer : longint;
begin
  repeat
    j := KGT[CurrPlayer](MyHoles, OppHoles, MyKalah, OppKalah); //  
    if j in [1..NumHoles] then begin //     
      bns := MyHoles[j]; //    
      MyHoles[j] := 0;
      j1 := j+1; //  ,       ,    
      repeat    //  ,   
        NewPlayer := 3 - CurrPlayer; //    
 //    
        for i := 1 to NumHoles do
          if (i >= j1) and (bns > 0) then begin
            dec(bns);
            inc(MyHoles[i]);
            if (bns = 0) and (MyHoles[i] = 1) then  //       
              if OppHoles[NumHoles - i + 1] > 0 then begin //     
                inc(MyKalah, OppHoles[NumHoles - i + 1]);
                OppHoles[NumHoles - i + 1] := 0;
                inc(MyKalah, MyHoles[i]);
                MyHoles[i] := 0;
                if LogLevel0 > 3 then
                  writeln(t,'  Empty ',CurrPlayer,' i: ',i);
              end;
          end;
        j1 := 1; //       
 //    
        if bns > 0 then begin
          dec(bns);
          inc(MyKalah);
          if bns = 0 then begin //    
            NewPlayer := CurrPlayer; //    
            if LogLevel0 > 3 then
              writeln(t,'  Kalah ',CurrPlayer);
          end;
        end;
 //    
        for i := 1 to NumHoles do
          if bns > 0 then begin
            dec(bns);
            inc(OppHoles[i]);
          end;
      until bns = 0;

      if LogLevel0 > 3 then
        PrintState(CurrPlayer, j, NewPlayer);
      KOT[3 - CurrPlayer](j); //     
      CheckGame;
      inc(CurrTurn);
    end else begin //    
      if LogLevel0 > 0 then
        writeln(t,'      ERROR!!!  KlGetTurn Wrong Result: ',j,', NumHoles= ',NumHoles,' Player: ',CurrPlayer);
      EndGame := TRUE; // if j in [1..6]
    end;
  until (CurrPlayer <> NewPlayer) or EndGame;
  CurrPlayer := NewPlayer;
end;

procedure ParseCommandString;
var
  s : string;
  i,j,n,w : longint;
  ch : char;
begin
  n := paramcount;
  if n > 0 then
    for i := 1 to n do begin
      s := paramstr(i);
      if (s[1] = '/') and (s[3] in [':','=']) then begin
        ch := s[2];
        delete(s,1,3);
        if UpCase(ch) in ['H','B','R','T'] then begin
          val(s,j,w);
          if w = 0 then
            case UpCase(ch) of
              'H': NumHoles  := j; //  = 6;      (3-6),     /h:N  (N -  )
              'B': NumBones  := j; //  = 6; //       (3-6),     /b:N  (N -  )
              'R': NumRounds := j; //  = 100; //   (  ),     /r:N  (N -  )
              'T': MaxTurns  := j; //  = 300; //  ,     (  ),     /t:N  (N -  )
            end // case
          else
            writeln('CommandLine ERROR(1): wrong Value:</'+ch+':'+s+'>');
        end else // if UpCase(ch) in ['H','B','R','T']
          case UpCase(ch) of
            'F': OutFile := s; //  = 'KlLog.txt'; //  ,   -  ,     /f:xxxxxx.txt
            'L': begin //  LogLevel0/1/2 : longint; //   -.
              if (s[1] in ['0'..'2']) and (s[2] in ['0'..'5']) then
                LogLevels[ord(s[1]) - ord('0')] := ord(s[2]) - ord('0')
              else writeln('CommandLine ERROR(2): wrong L option format:</'+ch+':'+s+'>');
            end;
            'P': begin //  Param1/2 : longint; //  ,  ""     10- /p:1=12345  16- /p:2:$12ab  /p=1:12abh 
              if (s[1] in ['1','2']) and (s[2] in [':','=']) then begin
                ch := s[1];
                delete(s,1,2);
                if s[length(s)] = 'h' then begin  //  12ABh
                  delete(s,length(s),1);
                  s := '$' + s;
                end;
                val(s,j,w);
                if w = 0 then
                  Params[ord(ch) - ord('0')] := j
                else
                  writeln('CommandLine ERROR(3): wrong Value:</'+ch+':'+s+'>');
              end else
                writeln('CommandLine ERROR(4): wrong P option format:<'+s+'>');;
            end;
            else writeln('CommandLine ERROR(5): unknown parameter:</'+ch+':'+s+'>');
          end; // case
      end else
        writeln('CommandLine ERROR(6): wrong format:<'+s+'>');;
    end;
end;

function InitPlayer(Pl : integer) : boolean; //  DLL 
var b : boolean;
begin
  with KlInfo12[Pl] do begin
    size := sizeof(tKlInfo);
    ver_B := 1;
    Num_P := Pl;
    Nholes := NumHoles;
    Nbones := NumBones;
    LogLevel := LogLevels[Pl];
    Param := Params[Pl];

    b := KI[Pl](KlInfo12[Pl]);
    if b then begin
      writeln('Player ',Pl,' Init         ', b);
      writeln('Player ',Pl,' version      ', ver_P);
      writeln('Player ',Pl,' name        <', name,'>');
      writeln('Player ',Pl,' creator     <', creator,'>');
      writeln('Player ',Pl,' description <', description,'>');
      if OutFile <> '' then begin
        writeln(t,'Player ',Pl,' Init         ', b);
        writeln(t,'Player ',Pl,' version      ', ver_P);
        writeln(t,'Player ',Pl,' name        <', name,'>');
        writeln(t,'Player ',Pl,' creator     <', creator,'>');
        writeln(t,'Player ',Pl,' description <', description,'>');
      end;
    end else begin
      writeln('Init Player ',Pl,' ERROR!');
      if OutFile <> '' then
        writeln(t,'Init Player ',Pl,' ERROR!');
    end;
    InitPlayer := b;
  end;
end;

procedure EndRound; //     
var i,n1,n2 : longint;
begin
  n1 := 0;
  n2 := 0;
  for i := 1 to NumHoles do begin
    inc(n1, Holes1[i]);
    inc(n2, Holes2[i]);
  end;
  if n1 = 0 then inc(Kalah2, n2); //               
  if n2 = 0 then inc(Kalah1, n1);
end;

procedure PrintDateTime;
var Year, Month, Day, DayOfWeek, Hour, Minute, Second, Sec100: Word;
const m : array[1..12]of string[3] = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
begin
  GetDate(Year, Month, Day, DayOfWeek);
  GetTime(Hour, Minute, Second,Sec100);
  writeln(t,'   ',Hour:2,':',Minute:2,':',Second:2,'.',Sec100:2,'   ',Day:2,'-',m[Month],'-',Year:4);
end;

var
  i,j : longint;
  b : boolean;
  nRound : longint;
  Vin1, Vin2, NumDraws : longint; //    
  TimA,TimB,TimBeg,TimEnd : extended;
  SumTime : array[1..2]of extended; //  
  StatTurns : array[0..300]of longint;
begin
  TimBeg := GetTimer_Q;
  ParseCommandString;
  if LogLevel0 > 0 then begin
    assign(t,OutFile);
    rewrite(t);
    PrintDateTime;
    writeln(t,'NumHoles: ',NumHoles);
    writeln(t,'NumBones: ',NumBones);
    writeln(t,'NumRounds: ',NumRounds);
    writeln(t,'MaxTurns: ',MaxTurns);
    writeln(t,'LogLevels: ',LogLevels[0],', ',LogLevels[1],', ',LogLevels[2]);
    writeln(t,'Params: ',Params[1],', ',Params[2]);
    writeln(t,'OutFile; <',OutFile,'>');
  end;
//  randomize;
  writeln('KlInfo size ', sizeof(tKlInfo));
  KI[1]  := KlInit_1;        KI[2]  := KlInit_2;    //          
  KGT[1] := KlGetTurn_1;     KGT[2] := KlGetTurn_2;
  KOT[1] := KlOppTurn_1;     KOT[2] := KlOppTurn_2;

  b := InitPlayer(1);
  if b then begin
    sleep(100);  // DLL    RANDOMIZE     .  -    RANDOM 
    b := InitPlayer(2);
    if not b then begin
      writeln('Second Player Can''t Play');
      if LogLevel0 > 0 then
        writeln(t,'Second Player Can''t Play');
    end;
  end else begin
    writeln('First Player Can''t Play');
    if LogLevel0 > 0 then
      writeln(t,'First Player Can''t Play');
  end;
  if not b then halt(1); //   ,         ?

  for nRound := 0 to NumRounds-1 do begin
    Kalah1 := 0;
    Kalah2 := 0;
    for i := 1 to NumHoles do begin //     
//      Holes1[i] := random(NumBones);
//      Holes2[i] := random(NumBones);
      Holes1[i] := NumBones;
      Holes2[i] := NumBones;
    end;
    EndGame := FALSE;
    CurrTurn := 0;
    CurrPlayer := 1;
    if LogLevel0 > 3 then
      PrintState(0, 0, 1);
    repeat
      if LogLevel0 > 3 then begin
        writeln(t);
        writeln(t,'Turn: ',CurrTurn);
      end;
      write(#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8,'Turn: ',CurrTurn:4,' Player ',CurrPlayer); //     -   
      TimA := GetTimer_Q;
      if CurrPlayer = 1 then begin
        Turn(Holes1, Holes2, Kalah1, Kalah2);
        TimB := GetTimer_Q;
        SumTime[1] +:= TimB - TimA;
      end else begin
        Turn(Holes2, Holes1, Kalah2, Kalah1);
        TimB := GetTimer_Q;
        SumTime[2] +:= TimB - TimA;
      end;
      write(' Time: ',TimB - TimA:6:4,' s');
    until EndGame or (CurrTurn >= MaxTurns);
    EndRound;
    KlEndRound_1(Kalah1, Kalah2, CurrTurn);
    KlEndRound_2(Kalah2, Kalah1, CurrTurn);
    if Kalah1 > Kalah2 then inc(Vin1);
    if Kalah2 > Kalah1 then inc(Vin2);
    if Kalah2 = Kalah1 then inc(NumDraws);
    inc(StatTurns[CurrTurn]);
    if LogLevel0 > 3 then begin
      writeln(t);
      write(t,'         END ');
    end;
    writeln(t,'ROUND ',nRound:4,'   Player 1 : ',Kalah1:2,'   Player 2 : ',Kalah2:2,'   (',Vin1:4,':',Vin2:4,') ',NumDraws:4,'   Turns: ',CurrTurn:4,' Elapsed Time: ',SumTime[1]:6:4,' / ',SumTime[2]:6:4);
    if LogLevel0 > 3 then
      writeln(t);
  end;
  KlDone_1;
  KlDone_2;
//  for i := 0 to 300 do
//    if StatTurns[i] > 0 then
//      writeln(t,i:3,' ',StatTurns[i]);
  TimEnd := GetTimer_Q;
  if LogLevel0 > 0 then begin
    writeln(t,'Elapsed Time: ',TimEnd - TimBeg:5:3,' s');
    close(t);
  end;
end.