library KlPlRnd; //       
uses KlComm;

const
  NumVer = 1; //   
  _name : string = 'Dumb Player';
  _creator : string = 'Sergey Andrianov';
  _description : string = 'Random Turn Player';
var
  CurrVer : longint; // ,     
  Player : longint; //   (1 bkb 2)
  NumHoles : longint; //   (3-6)
  NumBones : longint; //      (3-6)
  LogLevel : longint; //   -
  Param    : longint; // ,    
  t : text;      //    
  Nturn : longint; //  

procedure MoveString(var s : string; var p : array of char; size : longint); //  -  -
var l : longint;
begin
  l := length(s);
  if l > (size-1) then l := size-1;
  move(s[1], p, l);
  p[l] := #0;
end;

function KlInit conv arg_stdcall(var KlInfo : tKlInfo) : boolean; // .   2       .
begin
  with KlInfo do begin
    if size >= 32 then begin //    ,     
      if NumVer <= ver_B then
        ver_P := NumVer
      else
        ver_P := ver_B;
      CurrVer := ver_P;
      Player := Num_P;
      NumHoles := Nholes;
      NumBones := Nbones;
      KlPlRnd.LogLevel := LogLevel;
      KlPlRnd.Param := Param;
      if size >= 352 then begin
        MoveString(_name, name, 32);
        MoveString(_creator, creator, 32);
        MoveString(_description, description, 256);
      end;
    end;
  end;
  if LogLevel > 0 then begin
    if Player = 1 then
      assign(t,'Player1.out')
    else
      assign(t,'Player2.out');
    rewrite(t);
    writeln(t,' CurrVer: ',CurrVer);
    writeln(t,' Player: ',Player);
    writeln(t,' NumHoles: ',NumHoles);
    writeln(t,' NumBones: ',NumBones);
    writeln(t,' LogLevel: ',LogLevel);
    writeln(t,' Param: ',Param);
    writeln(t,' name: <',_name,'>');
    writeln(t,' creator: <',_creator,'>');
    writeln(t,' description: <',_description,'>');
  end;
  randomize;
  Nturn := 0;
  KlInit := TRUE;
end;

function KlGetTurn conv arg_stdcall(MyHoles, OppHoles : tHoles; MyKalah, OppKalah : longint) : longint; //  .  :  ,  ,  ,   - .
var i,j,n : longint;
begin
  if LogLevel >= 3 then
    write(t,'KlGetTurn Turn: ',Nturn);
  inc(Nturn,1);
  n := 0;
  for i := 1 to NumHoles do
    if MyHoles[i] > 0 then inc(n); //    
  if n = 0 then begin //    - 
    if LogLevel >= 3 then
      writeln(t,'KlGetTurn *3*');
    KlGetTurn := 0;
  end else begin
    j := random(n) + 1;
    if LogLevel >= 3 then
      write(t,' Num: ',n,' Rnd: ',j);
    i := 0;
    repeat
      inc(i);
      if MyHoles[i] > 0 then dec(j);
    until j = 0;
    if LogLevel >= 3 then
      writeln(t,' Out: ',i);
    KlGetTurn := i;
  end;
end;

procedure KlOppTurn conv arg_stdcall(OppTurn : longint); //         
begin
  if LogLevel >= 3 then
    writeln(t,'KlOppTurn Turn: ',Nturn,' Opp: ',OppTurn);
  inc(Nturn);
end;

procedure KlEndRound conv arg_stdcall(MyBones, OppBones, NumTurns : longint); //                 .
begin
  if LogLevel >= 2 then
    writeln(t,'   EndRound My: ',MyBones,' Opp: ',OppBones,' Turns: ',NumTurns,'/',Nturn);
  Nturn := 0;
end;

procedure KlDone conv arg_stdcall; //         ,  ,    .
begin
  if LogLevel > 0 then begin
    writeln(t,'END');
    close(t);
  end;
end;

exports
  KlInit name 'KlInit',
  KlInit index 1,
  KlGetTurn name 'KlGetTurn',
  KlGetTurn index 2,
  KlEndRound name 'KlEndRound',
  KlEndRound index 3,
  KlDone name 'KlDone',
  KlDone index 4,
  KlOppTurn name 'KlOppTurn',
  KlOppTurn index 5;

end.