library Kalah_D; //   
{uses
  SysUtils,
  Classes;{}

{ $R *.res}
uses
  KlComm in 'KlComm.pas';

const
  NumVer = 1; //   
var
  _name : shortstring = 'Dumb Player';           //  / ( )
  _creator : shortstring = 'Sergey Andrianov';    //  
  _description : shortstring = 'Random Turn Player (Delphi)'; // 
var
  CurrVer : longint; // ,     
  Player : longint; //   (1  2)
  NumHoles : longint; //   (3-6)
  NumBones : longint; //      (3-6)
  LogLevel : longint; //   - (0-5: 0-,1- ,... 5- )
  Param    : longint; // ,        
  t : text;      //    
  Nturn : longint; //  

procedure MoveString(var s : shortstring; var p : array of char; size : longint); //  -  -
var l : longint;
begin
  l := length(s);
  if l > (size-1) then l := size-1;
  move(s[1], p, l);
  p[l] := #0;
end;

function KlInit (var KlInfo : tKlInfo) : boolean; // .   2       .
begin
  with KlInfo do begin
    if size >= 32 then begin //    ,     
      if NumVer <= ver_B then
        ver_P := NumVer
      else
        ver_P := ver_B;
      CurrVer := ver_P;
      Player := Num_P;
      NumHoles := Nholes;
      NumBones := Nbones;
      Kalah_D.LogLevel := LogLevel;
      Kalah_D.Param := Param;
      if size >= 352 then begin
        MoveString(_name, name, 32);
        MoveString(_creator, creator, 32);
        MoveString(_description, description, 256);
      end;
    end;
  end;
  if LogLevel > 0 then begin //   -
    if Player = 1 then
      assign(t,'Player1.out')
    else
      assign(t,'Player2.out');
    rewrite(t);
    writeln(t,' CurrVer: ',CurrVer);
    writeln(t,' Player: ',Player);
    writeln(t,' NumHoles: ',NumHoles);
    writeln(t,' NumBones: ',NumBones);
    writeln(t,' LogLevel: ',LogLevel);
    writeln(t,' Param: ',Param);
    writeln(t,' name: <',_name,'>');
    writeln(t,' creator: <',_creator,'>');
    writeln(t,' description: <',_description,'>');
  end;
  randomize; //  DLL       
  Nturn := 0;
  KlInit := TRUE;
end;

function KlGetTurn (MyHoles, OppHoles : tHoles; MyKalah, OppKalah : longint) : longint; //  .  :  ,  ,  ,   - .
var i,j,n : longint;
begin
  if LogLevel >= 3 then
    write(t,'KlGetTurn Turn: ',Nturn);
  inc(Nturn,1);
  n := 0;
  for i := 1 to NumHoles do
    if MyHoles[i] > 0 then inc(n); //    
  if n = 0 then begin //    - 
    if LogLevel >= 3 then
      writeln(t,'KlGetTurn ERROR: No Bones');
    KlGetTurn := 0;
  end else begin //   ,    
    j := random(n) + 1;
    if LogLevel >= 3 then
      write(t,' Num: ',n,' Rnd: ',j);
    i := 0;
    repeat
      inc(i);
      if MyHoles[i] > 0 then dec(j);
    until j = 0;
    if LogLevel >= 3 then
      writeln(t,' Out: ',i);
    KlGetTurn := i;
  end;
end;

procedure KlOppTurn (OppTurn : longint); //    
begin
  if LogLevel >= 3 then
    writeln(t,'KlOppTurn Turn: ',Nturn,' Opp: ',OppTurn);
  inc(Nturn);
end;

procedure KlEndRound (MyBones, OppBones, NumTurns : longint); //                 .
begin
  if LogLevel >= 2 then
    writeln(t,'   EndRound My: ',MyBones,' Opp: ',OppBones,' Turns: ',NumTurns,'/',Nturn);
  Nturn := 0;
end;

procedure KlDone; //         ,  ,    .
begin
  if LogLevel > 0 then begin
    writeln(t,'END');
    close(t);
  end;
end;

exports
  KlInit name 'KlInit',
  KlGetTurn name 'KlGetTurn',
  KlEndRound name 'KlEndRound',
  KlDone name 'KlDone',
  KlOppTurn name 'KlOppTurn';

begin
end.
