{$mode objfpc}
unit uLight;

interface
uses graph, uList;

type
  TColorState = array[boolean] of integer;

  PTLight = ^TLight;
  TLight = object
    x, y: integer;
    color: TColorState;
    is_active: boolean;

    constructor Init(px, py: integer; pcolor: TColorState);
    destructor Done; virtual;

    procedure Show;
  end;

  PTLightList = ^TLightList;
  TLightList = specialize TList<PTLight>;

const
  min = 1;

  ColorizeLevel =  8;
  LightsOnLevel = 14;

  maxLightColors = 4;
  light_colors:
    array[0 .. pred(maxLightColors)] of TColorState =
    (
      (Blue, LightBlue),
      (Red, LightRed),
      (Brown, Yellow),
      (Magenta, LightMagenta)
    );


procedure ShowLights(p: PTLight);
procedure LightTheLamp(p: PTLight);
procedure DestroyLight(p: PTLight);

implementation

procedure ShowLights(p: PTLight);
begin
  p^.Show();
end;
procedure LightTheLamp(p: PTLight);
begin
  with p^ do
  begin
    is_active := not is_active; Show();
  end;
end;
procedure DestroyLight(p: PTLight);
begin
  Dispose(p, Done);
end;


constructor TLight.Init(px, py: integer;
            pcolor: TColorState);
begin
  x := px; y := py;
  color := pcolor;
  is_active := false;
end;
destructor TLight.Done;
begin end;


procedure TLight.Show;
begin
  SetFillStyle(SolidFill, color[is_active]);
  SetColor(color[is_active]);
  FillEllipse(x, y, 5, 5);
  SetColor(White);
  Circle(x, y, 5);
end;

end.
