{$mode objfpc}
unit uFirewrk;

interface
uses uEqua, uSnow;

type
  PTFire = ^TFire;
  TFire= object(TSnow)
    my_color: integer;
    constructor Init(pcolor: integer;
                px, py: integer; pVx, pVy: double);

    procedure Show; virtual;
    procedure Hide; virtual;

    procedure ReCalc(const branches: array of Pointer;
                     psL: PTSnowList); virtual;
  private
    counter: integer;
    buffer: array[1 .. 2, -1 .. 1] of integer;
  end;

procedure CreateFirework(var L: TSnowList; px, py: integer);

implementation
uses graph;

constructor TFire.Init(pcolor: integer;
            px, py: integer; pVx, pVy: double);
begin
  counter := 0;

  my_color := pcolor;
  x := px; y := py;
  Vx := pVx;
  Vy := pVy;
  active := true; fall := true;
  Show;
end;

procedure TFire.Show;
var i: integer;
begin
  if active then
  begin

    for i := -1 to 1 do
    begin
      buffer[1, i] := GetPixel(x + i, y);
      if buffer[1, i] <> GetBkColor then buffer[1, i] := -1
      else PutPixel(x + i, y, my_color);
    end;

    for i := -1 to 1 do
    begin
      buffer[2, i] := GetPixel(x, y + i);
      if buffer[2, i] <> GetBkColor then buffer[2, i] := -1
      else PutPixel(x, y + i, my_color);
    end;

  end;
end;

procedure TFire.Hide;
var i: integer;
begin
  for i := -1 to 1 do
    if buffer[1, i] <> -1 then PutPixel(x + i, y, buffer[1, i]);
  for i := -1 to 1 do
    if buffer[2, i] <> -1 then PutPixel(x, y + i, buffer[2, i]);
end;

procedure TFire.ReCalc(const branches: array of Pointer;
                       psL: PTSnowList);
const
  max_counter = 30;
begin
  if counter < max_counter then
  begin
    x := Trunc(x + vx);
    y := Trunc(y + vy);
    inc(counter);
  end
  else
  begin
    Hide;
    active := false;
  end;
end;



procedure CreateFirework(var L: TSnowList; px, py: integer);
const
  fw_speed       =  5;
  colors: array[0 .. 5] of array [0 .. 1] of integer =
  (
    (red, lightred),
    (green, lightgreen),
    (blue, lightblue),
    (magenta, lightmagenta),
    (cyan, lightcyan),
    (brown, yellow)
  );
var
  i, the_color: integer;
  speed, pVx, pVy: double;
  firework_count, angle: integer;
begin
  the_color := random(6);
  firework_count := random(30) + 50;
  for i := 0 to pred(firework_count) do
  begin
    angle := random(360);
    speed := 0.005 * (100 - (random(20) + 10)) * fw_speed;

    pVx := sin(angle * Pi / 180) * speed;
    pVy := cos(angle * Pi / 180) * (-speed);
    L.append(new(ptfire,
                 init(colors[the_color, random(2)], px, py, pVx, pVy)));
  end;
end;

end.

