{$mode objfpc}
unit uEqua;

interface
uses uList, uSnow;

const
  linear = 4;

type
  TEqualizer = object
    constructor Init;
    destructor Done;

    procedure Update(px: integer);
    procedure DecreaseLevel;

    function GetValue(ix: integer;
             var RangeOut: boolean): integer;

  private
    arr: array[-2 * linear .. 800 + 2 * linear] of integer;

    procedure GoLinear(x: integer);
  end;

  PIntArray = ^IntArray;
  IntArray = array[0 .. Pred(MaxInt div (2 * SizeOf(integer)))] of integer;

  funcBranchUpdate = procedure(var sL: TSnowList; count: integer;
                     left, height, width, speed: integer);

  PTBranch = ^TBranch;
  TBranch = object
  private
    height: integer;
    center_x, width: integer;

    count, mass: integer;
    procedure GoLinear(x: integer);

  public
    arr: PIntArray;

    constructor Init(px_center, pheight, pwidth: integer);
    destructor Done; virtual;

    procedure Show;
    procedure Update(px, add_mass: integer;
                     var sL: TSnowList; p: funcBranchUpdate);

    function GetLeft: integer;
    function GetRight: integer;
    function GetHeight: integer;
  end;

var
  branches_count: integer;
  ground: TEqualizer;

implementation
uses graph;

constructor TEqualizer.Init;
var i: integer;
begin
  SetColor(White);

  for i := Low(arr) to High(arr) do begin
    arr[i] := GetMaxY - random(10);
  end;

  for i := 0 to 800 do GoLinear(i);
end;

destructor TEqualizer.Done;
begin end;


procedure TEqualizer.GoLinear(x: integer);
var
  i, curr: integer;
  s: double;
  save: array[-linear .. linear] of integer;
begin
  for curr := x - linear to x + linear do begin

    s := 0.0;
    for i := curr - linear to curr + linear do begin
      s := s + arr[i];
    end;
    s := s / (2 * linear + 1);
    save[curr - x] := trunc(s);

  end;

  for curr := x - linear to x + linear do begin

    if arr[curr] > save[curr - x] then begin
      if (curr >= 0) and (curr < getmaxx) then begin
        SetColor(White); Line(curr, arr[curr], curr, save[curr - x]);
      end
    end
    else begin
      if (curr >= 0) and (curr < getmaxx) then begin
        SetColor(Black); Line(curr, arr[curr], curr, save[curr - x]);
      end
    end;

    arr[curr] := save[curr - x];

  end;

end;

procedure TEqualizer.DecreaseLevel;
var i: integer;
begin

  for i := Low(arr) to High(arr) do
    if arr[i] < GetMaxY - 5 then inc(arr[i], 5);

end;

function TEqualizer.GetValue(ix: integer;
         var RangeOut: boolean): integer;
begin
  RangeOut := (ix < -2 * linear) or (ix > GetMaxX + 2 * linear);
  if RangeOut then
  begin
    GetValue := -1
  end
  else GetValue := (* getmaxy - *) arr[ix];
end;


procedure TEqualizer.Update(px: integer);
begin

  dec(arr[px]);
  if (px >= 0) and (px < GetMaxX) then GoLinear(px);

end;




constructor TBranch.init(px_center, pheight, pwidth: integer);
var i: integer;
begin
  center_x := px_center;
  height := pheight; width := pwidth;

  getmem(arr, width * sizeof(integer));
  for i := 0 to pred(width) do arr^[i] := 1;

  mass := 3 * width;
  count := 0;
end;
destructor TBranch.done;
begin
  freemem(arr, width * sizeof(integer));
end;

function TBranch.GetLeft: integer;
begin GetLeft := center_x - (width div 2) end;
function TBranch.GetRight: integer;
begin GetRight := center_x + (width div 2) end;
function TBranch.GetHeight: integer;
begin GetHeight := height end;


procedure TBranch.Show;
begin
  {$IFDEF DEBUGGING}
  SetColor(LightRed);
  {
    line(center_x - (width div 2), height, center_x + (width div 2), height);
  }

  Line(GetLeft, height, GetRight, height);
  {$ENDIF}

  setcolor(white);

end;

procedure TBranch.update(px, add_mass: integer;
                         var sL: TSnowList; p: funcBranchUpdate);
var i: integer;
begin
  px := px - GetLeft;
  if (px >= 0) and (px < width) then begin

    inc(arr^[px], 2);
    inc(count);

    dec(mass, add_mass);

    if mass > 0 then GoLinear(px)
    else begin

      for i := 0 to pred(width) do arr^[i] := 0;
      for i := 0 to pred(width) do GoLinear(i);

      Show;

      (*
      append_fall(sl, count div 3, get_left, height, width, 17);
      *)
      p(sL, count div 3, GetLeft, height, width, 17);
      mass := 3 * width;

    end;

  end;
end;


const
  b_linear = 4;

procedure TBranch.GoLinear(x: integer);
var
  value: integer;
  i: integer;
  curr: integer;
  s: double;
  save: array[-b_linear .. b_linear] of integer;
begin
  for curr := x - b_linear to x + b_linear do begin

    s := 0.0;
    for i := curr - b_linear to curr + b_linear do begin

      if i < 0 then value := 0
      else if i >= width then value := 0
           else value := arr^[i];

      s := s + value;

    end;
    s := s / (2 * b_linear + 1);
    save[curr - x] := Trunc(s);

  end;

  SetWriteMode(XorPut);

    for curr := x - b_linear to x + b_linear do begin

      if (curr > 0) and (curr < width) then begin
        Line(GetLeft + curr, height, GetLeft + curr, height + arr^[curr]);
        Line(GetLeft + curr, height, GetLeft + curr, height - arr^[curr]);

        Line(GetLeft + curr, height, GetLeft + curr, height + save[curr - x]);
        Line(GetLeft + curr, height, GetLeft + curr, height - save[curr - x]);

        arr^[curr] := save[curr - x];
      end;

    end;

  SetWriteMode(CopyPut);

end;

end.
