#ifndef RECOGNIZER_H
#define RECOGNIZER_H
#include <QtGui/QWidget>
#include <QPixmap>
#include <QPainter>
#include <QBrush>
#include <QImage>
#include <QHash>
#include <QChar>
#include <QString>
#include <QPushButton>
#include <QFont>
#include <QMouseEvent>
#include <QPen>
#include <QStringList>
#include <QStringListModel>

namespace Ui {
    class recognizer;
}

class recognizer : public QWidget {
    Q_OBJECT
public:
    recognizer(QWidget *parent = 0);
    ~recognizer();

protected:
    void changeEvent(QEvent *e);
    bool eventFilter(QObject * o, QEvent * e);

private:
    QPixmap * etalonSymbolPixmap;
    QPixmap * etalonPixelsNetPixmap;
    QPixmap * inputSymbolPixmap;
    QPixmap * inputPixelsNetPixmap;
    QPainter * painter;
    QFont font;
    QPoint lastpoint;
    QPen  drawPen;
    QVector <QPushButton *> buttons;
    QStringListModel etalonArrayModel;
    QStringListModel inputArrayModel;

    Ui::recognizer *ui;
    void setConnections();// 
    void getButtons();//   ..

public slots :
       void drawLetter();//  ,     
       void clearPixmaps();//    " "
       void clearInputField();//   
       void drawEtalonPixelsMap();//   
       void getArray(QImage img);//   
};

#endif // RECOGNIZER_H
