Uses Graph, Keyboard, MouseUnit,
     Applic, WindowUnit;

Const
  ExitFlag : Boolean = False;

Type
  TApp =
    Object( TApplication )
      Procedure Run; Virtual;
      Procedure InitMenuBar; Virtual;
    End;

Const
  optTest = 5;
  mnuTestContent : Array[1 .. optTest] Of menuStrType =
    (
      'Option 1', 'Option 2', 'Option 3', 'Option 4', 'Exit'
    );



Procedure ActionFileMenu; Far;

  Function GetInternalMenu( Const s : String;
           Var arr; Len : Word ) : Integer;
  Var mnuObj : PTMenuWindow;
  Begin
    New( mnuObj, Init(25, 25, s, arr, Len, Len) );
    GetInternalMenu := mnuObj^.GetMenu;
    Dispose( mnuObj, Done )
  End;

Var Res : Integer;
Begin
  Res := GetInternalMenu( 'Test', mnuTestContent, optTest );
  ExitFlag := (Res = 5)
End;


Procedure TApp.InitMenuBar;
  Var CoorX, CoorY : Word;
  Begin
    TApplication.InitMenuBar;

    CoorX := menuBar^.xSt;
    menuBar^.Insert( New(PTButton, Init(CoorX + strFresh, menuBar^.ySt + strFresh,
      CoorX, CoorY, 'Menu', kbdNone, btnStandard, ActionFileMenu)) );
  End;

Procedure TApp.Run;
var LastEvent : TEvent;
  Begin
    TApplication.Run;
    menuBar^.Show;

    mouse.msOn;

    While not ExitFlag Do
      Begin
        While not mouse.GetEvent( LastEvent ) Do;
        If menuBar^.Process( LastEvent ) Then Continue;
      End
  End;

Var
  myApp : TApp;

BEGIN
  myApp.Init;
  myApp.Run;
  myApp.Done
END.
