//  : aim.
// :        .

unit u_sprites;
{$mode objfpc}

interface

uses
	u_log, u_options, u_window, u_textures, u_fonts,
	Direct3D9, D3DX9, windows, contnrs;

type
	//    .
	TGraphicObject = class
	private

	public
		// .  ,      .
		procedure Update(Delta: Double); virtual; abstract;
	end;

	//  .
	TSprite = class(TGraphicObject)
	private
		Texture: TTexture;
		CurrentMode: Integer;
		FramesNum: Integer;
		CurrentFrame: Integer;
		FrameInterval: Double;
		RepeatAnimation: Boolean;
		FrameTime: Double;
		SpriteCenter: TD3DXVECTOR3;
		Scale: TD3DMATRIX;
		Rotate: TD3DMATRIX;
		Translate: TD3DMATRIX;
		Transform: TD3DMATRIX;
		FWidth, FHeight: Integer;
	public
		// Width, Height -   ( ,   ).
		// Texture -   ,      .
		// AWidth, AHeight -   (     ).
		constructor Create(ATexture: TTexture; AWidth, AHeight: Integer);
		//        Sprites.
		destructor Destroy; override;
		//   . :
		// Mode -  . Frame -   . Frames -  .
		// CenterX, CenterY -   ,   
		//    .
		// Interval -      , 0,    .
		// RepeatAni -   .
		procedure SetMode(Mode, Frame, Frames, CenterX, CenterY, Interval: Integer; RepeatAni: Boolean);
		//  : ,  , .
		procedure SetParams(X, Y, Z, Angle, ScaleX, ScaleY: Single);
		//  .
		procedure Draw;
		//  .  ,      .
		procedure Update(Delta: Double); override;
		property Width: Integer read FWidth;
		property Height: Integer read FHeight;
	end;
	
	{//    .
	TTiledObj = class(TGraphicObj)
	private
		procedure OnLostDevice; override;
		procedure OnResetDevice; override;
	public
		// X, Y -      (  ).
		// TileWidth, TileHeight -      .
		// Tiles -        .
		constructor Create(X, Y, TileWidth, TileHeight: Integer; const Tiles: TTiles);
		destructor Destroy; override;
	end;}

	TSprites = class
	private
		List: TFPObjectList;
		//   .
		procedure Delete(GrObj: TGraphicObject);
	public
		constructor Create;
		destructor Destroy; override;
		//        .
		function NewSprite(Texture: TTexture; Width, Height: Integer): TSprite;
		//   .
		procedure Draw;
		//   .  ,      .
		procedure Update(Delta: Double);
		//    .
		procedure Clear;
	end;

var
	Sprites: TSprites = nil;

implementation

// TSprite -----

// public

constructor TSprite.Create(ATexture: TTexture; AWidth, AHeight: Integer);
begin
	Texture := ATexture;
	FWidth := AWidth;
	FHeight := AHeight;
	FrameTime := 0;
end;

destructor TSprite.Destroy;
begin
	if Sprites <> nil then Sprites.Delete(self);
	inherited;
end;

procedure TSprite.SetMode(Mode, Frame, Frames, CenterX, CenterY, Interval: Integer; RepeatAni: Boolean);
begin
	CurrentMode := Mode;
	FramesNum := Frames;
	CurrentFrame := Frame;
	FrameInterval := Interval;
	RepeatAnimation := RepeatAni;
	SpriteCenter := D3DXVECTOR3(CenterX, CenterY, 0.0); 
end;

procedure TSprite.SetParams(X, Y, Z, Angle, ScaleX, ScaleY: Single);
begin
	D3DXMatrixRotationZ(Rotate, Angle);
	D3DXMatrixTranslation(Translate, X, Y, Z);
	D3DXMatrixScaling(Scale, ScaleX, ScaleY, 0.0);
	D3DXMatrixMultiply(Transform, Rotate, Translate);
	D3DXMatrixMultiply(Transform, Scale, Transform);
	D3DXMatrixScaling(Scale, 1, -1, 0.0);
end;

procedure TSprite.Draw;
var
	TextureRec: TRect;
begin
	Window.Device.SetRenderState(D3DRS_ALPHABLENDENABLE, 1);
	with TextureRec do begin
		Left := CurrentFrame * FWidth;
		Top := CurrentMode * FHeight;
		Right := Left + FWidth;
		Bottom := Top + FHeight;
	end;
	
	Window.Device.SetTransform(D3DTS_TEXTURE0, Scale);
	Window.Sprite.SetTransform(Transform);
	Window.Sprite.Draw(Texture.Frames, @TextureRec, @SpriteCenter, nil, D3DCOLOR_XRGB(255, 255, 255));
	Window.Sprite.Flush;
	
	Window.Device.SetRenderState(D3DRS_ALPHABLENDENABLE, 0);
end;

procedure TSprite.Update(Delta: Double);
begin
	if FrameInterval > 0 then begin
		FrameTime := FrameTime + Delta;
		if FrameTime >= FrameInterval then begin
			FrameTime := FrameTime - FrameInterval;
			if CurrentFrame < FramesNum - 1 then
				Inc(CurrentFrame)
			else
				if RepeatAnimation then CurrentFrame := 0;
		end;
	end;
end;

{// TTiledObj -----

// private

procedure TTiledObj.OnLostDevice;
begin
	//  .
end;

procedure TTiledObj.OnResetDevice;
begin
	//  .
end;

// public

constructor TTiledObj.Create(X, Y, TileWidth, TileHeight: Integer; const Tiles: TTiles);
begin
	//  .
end;

destructor TTiledObj.Destroy;
begin
	//  .
end;}

// TSprites -----

// private

procedure TSprites.Delete(GrObj: TGraphicObject);
begin
	List.Remove(GrObj);
end;

// public

constructor TSprites.Create;
begin
	List := TFPObjectList.Create(false);
end;

destructor TSprites.Destroy;
begin
	Clear;
	List.Destroy;
	inherited;
end;

function TSprites.NewSprite(Texture: TTexture; Width, Height: Integer): TSprite;
begin
	Result := TSprite.Create(Texture, Width, Height);
	List.Add(Result);
end;

procedure TSprites.Draw;
var
	i: Integer;
begin
	Window.Sprite._Begin(D3DXSPRITE_OBJECTSPACE or D3DXSPRITE_DONOTMODIFY_RENDERSTATE);
	for i := 0 to List.Count - 1 do begin
		(List[i] as TSprite).Draw;
	end;
	Window.Sprite._End;
end;

procedure TSprites.Update(Delta: Double);
var
	i: Integer;
begin
	for i := 0 to List.Count - 1 do
		(List[i] as TGraphicObject).Update(Delta);
end;

procedure TSprites.Clear;
var
	i: Integer;
begin
	for i := 0 to List.Count - 1 do begin
		Log.Debug('Sprites', 'Iteration.');
		List[i].Destroy;
	end;
	List.Clear;
end;

end.
