//  : aim.
//  Log.    =).

unit u_log;
{$mode objfpc}

interface

uses
	windows, sysutils;

type
	TLog = class
	private
		FLogFile: Text;
		procedure WriteString(const Str: string);
	public
		//       .
		constructor Create(const FileName: string);
		destructor Destroy; override;
		//      (  "Note").
		procedure Write(const SenderName, Str: string);
		//      (  "Debug").
		procedure Debug(const SenderName, Str: string);
		//       (  "Error").
		procedure Error(const SenderName, Str: string);
		//        (  "Fatal Error")
		//     .
		procedure Fatal(const SenderName, Str: string);
	end;

var
	Log: TLog;

implementation

const
	TimeFormat = 'yyyy-mm-dd hh:mm:ss.zzz'; //  .

// TLog -----

// private

procedure TLog.WriteString(const Str: string);
begin
	{$I-}
	WriteLn(FLogFile, Str);
	Flush(FLogFile);
	{$I+}
	if IOResult <> 0 then begin
		MessageBox(0, 'Can''t write to log file. Program halted.', 'File error', MB_OK);
		Halt(0);
	end;
end;

// public

constructor TLog.Create(const FileName: string);
begin
	{$I-}
	Assign(FLogFile, FileName);
    if FileExists(FileName) then Append(FLogFile) else Rewrite(FLogFile);
	{$I+}
    if (IOResult = 0) and (FileName <> '') then begin
		WriteString('');
		WriteString('*** Start session ***');
	end else begin
		MessageBox(0, 'Can''t create or open log file. Program halted.', 'File error', MB_OK);
		Halt(0);
    end;
end;

destructor TLog.Destroy;
begin
	WriteString('*** End session ***');
	Close(FLogFile);
end;

procedure TLog.Write(const SenderName, Str: string);
begin
	WriteString(FormatDateTime(TimeFormat, Now) + ' Note: "' + SenderName + '" - ' + Str);
end;

procedure TLog.Debug(const SenderName, Str: string);
begin
	WriteString(FormatDateTime(TimeFormat, Now) + ' Debug: "' + SenderName + '" - ' + Str);
end;

procedure TLog.Error(const SenderName, Str: string);
begin
	WriteString(FormatDateTime(TimeFormat, Now) + ' Error: "' + SenderName + '" - ' + Str);
end;

procedure TLog.Fatal(const SenderName, Str: string);
begin
	WriteString(FormatDateTime(TimeFormat, Now) + ' Fatal Error: "' + SenderName + '" - ' + Str);
	MessageBox(0, PChar(AnsiString(SenderName + ': ' + Str)), 'Fatal Error', MB_OK);
	Halt(0);
end;

end.
