//  : aim.
//  Battlefield -         .

unit u_battlefield;
{$mode objfpc}

interface

uses
	u_log, u_options, u_testgame,
	Classes, windows;

type
	TBattlefield = class(TThread)
	private
		UpdateTime: Double; //     .
	public
		constructor Create;
		destructor Destroy; override;
		//      .
		procedure Execute; override;
	end;

var
	Battlefield: TBattlefield;

implementation

// TBattlefield -----

// public

constructor TBattlefield.Create;
begin
	inherited Create(true);
	UpdateTime := 40.0; // 25   .
	TestGame := TTestGame.Create;
end;

destructor TBattlefield.Destroy;
begin
	TestGame.Destroy;
	inherited;
end;

procedure TBattlefield.Execute;
var
	CountsPerSec: Int64;
	MSecsPerCount: Double;
	CurrTimeStamp: Int64;
	PrevTimeStamp: Int64;
	SleepTime: Int64;
begin
	Log.Write('Battlefield', 'Processing start.');
	QueryPerformanceFrequency(CountsPerSec);
	MSecsPerCount := 1000 / CountsPerSec;
	QueryPerformanceCounter(PrevTimeStamp);
	while not Terminated do begin
		TestGame.Update;
		QueryPerformanceCounter(CurrTimeStamp);
		SleepTime := Round(UpdateTime - (CurrTimeStamp - PrevTimeStamp) * MSecsPerCount);
		PrevTimeStamp := CurrTimeStamp;
		if SleepTime > 0 then Sleep(SleepTime);
	end;
	Log.Write('Battlefield', 'Processing stop.');
end;

end.
