﻿#include <windows.h>
#include <stdio.h>

#include <math.h>

#define NOCONTEST
#define EXAMPLE

#ifdef EXAMPLE
#ifdef CONTEST
typedef
struct rec_foo {
  int foo;
} TFunction;

bool setFunction(TFunction& f, const char *s)
{
	return true;
}

void setVarFunction(TFunction& f, char ch, double value)
{
}
double calcFunction(TFunction& f, int&  errCode)
{
	return 0.0;
}
void resetFunction(TFunction& f)
{
}
#endif
#endif

#define SQR(x) ((x)*(x))

// ******************************************
const WORD HLSMAX = 240;
const WORD RGBMAX = 255;
const WORD UNDEFINED = (HLSMAX*2) / 3;

/* utility routine for HLStoRGB */
WORD HueToRGB(WORD n1, WORD n2, WORD hue)
{
	/* range check: note values passed add/subtract thirds of range */
	if(hue < 0) hue += HLSMAX;
	if(hue > HLSMAX) hue -= HLSMAX;

	/* return r,g, or b value from this tridrant */
	if (hue < (HLSMAX/6)) return ( n1 + (((n2-n1)*hue+(HLSMAX/12))/(HLSMAX/6)) );
	if (hue < (HLSMAX/2)) return ( n2 );
	if (hue < ((HLSMAX*2)/3))
		return ( n1 + (((n2-n1)*(((HLSMAX*2)/3)-hue)+(HLSMAX/12))/(HLSMAX/6)) );
	else
		return ( n1 );
}
void HLStoRGB(WORD hue, WORD lum, WORD sat,
			  WORD &R, WORD &G, WORD &B)
{
	WORD Magic1, Magic2; /* calculated magic numbers (really!) */
	if(sat == 0) { /* achromatic case */
		R = G = B = (lum*RGBMAX)/HLSMAX;
		if(hue != UNDEFINED) {
			/* ERROR */
		}
	}
	else { /* chromatic case */
		/* set up magic numbers */
		if (lum <= (HLSMAX/2))
			Magic2 = (lum*(HLSMAX + sat) + (HLSMAX/2))/HLSMAX;
		else
			Magic2 = lum + sat - ((lum*sat) + (HLSMAX/2))/HLSMAX;
		Magic1 = 2*lum-Magic2;
		/* get RGB, change units from HLSMAX to RGBMAX */
		R = (HueToRGB(Magic1,Magic2,hue+(HLSMAX/3))*RGBMAX +
			(HLSMAX/2))/HLSMAX;
		G = (HueToRGB(Magic1,Magic2,hue)*RGBMAX + (HLSMAX/2)) / HLSMAX;
		B = (HueToRGB(Magic1,Magic2,hue-(HLSMAX/3))*RGBMAX +
			(HLSMAX/2))/HLSMAX;
	}
}

#define CALC setVarFunction(f_x, 'U', u); \
  setVarFunction(f_x, 'V', v); \
  X = calcFunction(f_x, errCode); \
  \
  setVarFunction(f_y, 'U', u); \
  setVarFunction(f_y, 'V', v); \
  Y = calcFunction(f_y, errCode); \
  \
  setVarFunction(f_z, 'U', u); \
  setVarFunction(f_z, 'V', v); \
  Z = calcFunction(f_z, errCode);

// ******************************************
typedef
struct rec_paramR {
	double a, b, c;
	int scX, scY, scZ;
} paramR;

#ifdef CONTEST
TFunction f_x, f_y, f_z;
int errCode;
#endif

void fPlane(const paramR &R, double u, double v,
			double &X, double &Y, double &Z)
{
	// Just a plane
	#ifdef CONTEST
		CALC
	#else
		X = R.scX * u;
		Y = R.scY * v;
		Z = 0;
	#endif
}

void fSteinersRoman(const paramR &R, double u, double v,
					double &X, double &Y, double &Z)
{
	// Steiner's Roman Surface (a = 1.23)
	#ifdef CONTEST
		CALC
	#else
		X = (double)R.scX * (1/2.) * SQR(R.a) * SQR(cos(v)) * sin(2 * u);
		Y = (double)R.scY * (1/2.) * SQR(R.a) * sin(u) * sin(2 * v);
		Z = (double)R.scZ * (1/2.) * SQR(R.a) * cos(u) * sin(3 * v);
	#endif
}

void fKleinBottle(const paramR &R, double u, double v,
				  double &X, double &Y, double &Z)
{
	// The Klein Bottle (a = 1.1)
	#ifdef CONTEST
		CALC
	#else
		X = R.scX * cos(u) * (R.a + cos(u/2)*sin(v) - sin(u/2)*sin(2*v));
		Y = R.scY * sin(u) * (R.a + cos(u/2)*sin(v) - sin(u/2)*sin(2*v));
		Z = R.scZ * (sin(u/2)*sin(v) + cos(u/2)*sin(2*v));
	#endif
}
// ******************************************

typedef double (*funcType)(double, double);
typedef
struct rec_funcRec {
	funcType func;
} funcRec;

// Surprise :)
double foo(double, double) {
	return 1.0;
}
const int funcCount = 1;
funcRec fArr[funcCount] = {
	{foo}
};

typedef
void (*surfProcType)(const paramR&, double, double, double&, double&, double&);

typedef
struct rec_surfRec {
	paramR params;
	surfProcType func;
	double u_st, u_fn;
	double v_st, v_fn;

	const char *fX, *fY, *fZ;
} surfRec;

typedef
struct rec_surfResult {
	DWORD calls;
	int tm;
	__int64 tckUser, tckTotal;
} surfResult;

const double n_a = 0.0;
const int surfCount = 3; // 18 functions in REAL test !!!
const surfRec fList[surfCount] = {
	{
		{n_a, n_a, n_a,
		150, 150, 150},
		fPlane,
		-1.0, 1.0,
		-1.0, 1.0,
		"X*U", "Y*V", "0"
	},
	{
		{1.23, n_a, n_a,
		250, 250, 250},
		fSteinersRoman,
		0.0, 2*M_PI,
		0.0, 2*M_PI,
		"X*(1/2)*A^2*(cos(V))^2*sin(2*U)",
		"Y*(1/2)*A^2*sin(U)*sin(2*V)",
		"Z*(1/2)*A^2*cos(U)*sin(3*V)"
	},
	{
		{1.1, n_a, n_a,
		200, 200, 200},
		fKleinBottle,
		0.0, 2*M_PI,
		0.0, 2*M_PI,
		"X*cos(U)*(A+cos(U/2)*sin(V) - sin(U/2)*sin(2*V))",
		"Y*sin(U)*(A+cos(U/2)*sin(V) - sin(U/2)*sin(2*V))",
		"Z*(sin(U/2)*sin(V)+cos(U/2)*sin(2*V))"
	}
};
surfResult fResults[surfCount + 1];


#define PBM_SETRANGE (WM_USER + 1)
#define PBM_SETPOS   (WM_USER + 2)
#define PBM_STEPIT   (WM_USER + 5)

char winName[] = "MainWClass";
char surfCaption[] = "Draw surfaces";

#define BTN_START_ID  110
#define BTN_SURF_ID   115
#define BTN_SAVE_ID   116
#define ID_LISTBOX    111


HWND hWndMain, btnSurf, myProgress, hListBox;
HDC memDC;
HBITMAP hbit;

int currSurface;
int center_x, center_y;
int wid, hei;

// C++ Builder version
unsigned __int64 rdtsc()
{
	__asm rdtsc;
}
/*
// GCC version
 static __inline__ unsigned long long int rdtsc(void)
 {
     __asm__ volatile ("rdtsc");
 }
*/

unsigned __int64 rdtsc()
{
	__asm rdtsc;
}

void Draw3DPnt(double X, double Y, double Z)
{
	#define coordX(X, Z) ((int)((X + center_x) - Z))
	#define coordY(Y, Z) ((int)(center_y - Y + Z))

	int newZ = (int)(Z / M_SQRT2);
	SetPixel(memDC, coordX(X, newZ), coordY(Y, newZ),
		RGB(0x00, 0xFF, 0x00));
}

void DrawSurface(int iFuncs)
{
	#define dp_u (M_PI / 300)
	#define dp_v (M_PI / 300)

	double X, Y, Z;
	PatBlt(memDC, 0, 0, wid, hei, BLACKNESS);

	center_x = wid / 2;
	center_y = hei / 2;

	unsigned __int64 cmTime = 0;
	DWORD counter = 0;
	unsigned long dt = GetTickCount();
	unsigned __int64 ts = rdtsc();

	#ifdef CONTEST
	  setFunction(f_x, fList[iFuncs].fX);
	  setVarFunction(f_x, 'X', fList[iFuncs].params.scX);
	  setVarFunction(f_x, 'A', fList[iFuncs].params.a);
	  setVarFunction(f_x, 'B', fList[iFuncs].params.b);
	  setVarFunction(f_x, 'C', fList[iFuncs].params.c);

	  setFunction(f_y, fList[iFuncs].fY);
	  setVarFunction(f_y, 'Y', fList[iFuncs].params.scY);
	  setVarFunction(f_y, 'A', fList[iFuncs].params.a);
	  setVarFunction(f_y, 'B', fList[iFuncs].params.b);
	  setVarFunction(f_y, 'C', fList[iFuncs].params.c);

	  setFunction(f_z, fList[iFuncs].fZ);
	  setVarFunction(f_z, 'Z', fList[iFuncs].params.scZ);
	  setVarFunction(f_z, 'A', fList[iFuncs].params.a);
	  setVarFunction(f_z, 'B', fList[iFuncs].params.b);
	  setVarFunction(f_z, 'C', fList[iFuncs].params.c);
	#endif

	for(double p_v = fList[iFuncs].v_st;
		p_v <= fList[iFuncs].v_fn; p_v += dp_v)
	{
		for(double p_u = fList[iFuncs].u_st;
			p_u <= fList[iFuncs].u_fn; p_u += dp_u)
		{
			unsigned __int64 dTimeStart = rdtsc();
			fList[iFuncs].func(fList[iFuncs].params, p_u, p_v, X, Y, Z);
			unsigned __int64 dTimeFinish = rdtsc();
			cmTime += (dTimeFinish - dTimeStart);

			counter += 1;
			Draw3DPnt(X, Z, Y);
		}
		SendMessage(
			myProgress, PBM_SETPOS,
			(int)(100 * (p_v - fList[iFuncs].v_st) / (fList[iFuncs].v_fn - fList[iFuncs].v_st)), 0
		);
	}

	#ifdef CONTEST
	resetFunction(f_x);
	resetFunction(f_y);
	resetFunction(f_z);
	#endif

	unsigned __int64 tf = rdtsc();
	dt = GetTickCount() - dt;
	fResults[iFuncs].calls = counter;
	fResults[iFuncs].tm = dt;
	fResults[iFuncs].tckUser = cmTime;
	fResults[iFuncs].tckTotal = tf - ts;

	wchar_t info[256] = {0};
	wsprintfW(info,
		L"Surface #%d; %d function calls; time = %d; %d ticks, %d total ticks",
		iFuncs,
		fResults[iFuncs].calls,
		fResults[iFuncs].tm,
		fResults[iFuncs].tckUser,
		fResults[iFuncs].tckTotal);
	SendMessageW(hListBox, LB_INSERTSTRING,
		SendMessageW(hListBox, LB_GETCOUNT, 0, 0), (LPARAM)info);
}

void DrawIt(int)
{
	MessageBox(0, "Implemented in REAL test only!", NULL, MB_OK);
}


void SaveResults()
{
	FILE *f = fopen("result.txt", "wt");
	int tm = 0; unsigned __int64 ticks = 0;

	for(int i = 0; i < surfCount; i++)
	{
		fprintf(f,
			"Surface #%d; %d function calls; time = %d; %d ticks, %d total ticks\n",
			i,
			fResults[i].calls,
			fResults[i].tm,
			fResults[i].tckUser,
			fResults[i].tckTotal);
		tm += fResults[i].tm;
		ticks += fResults[i].tckUser;
	}

	fputs("***", f);
	fprintf(f, "total time = %d; total user ticks = %I64d\n", tm, ticks);
	fclose(f);
}

BOOL SavePicture(HDC hDC, HBITMAP hBitmap, LPCTSTR lpszFileName)
{
	// Получаем информацию о битмэпе
	BITMAP bmp;
	if (!::GetObject(hBitmap, sizeof(BITMAP), &bmp)) {
		// Не удалось - надо зафиксировать
		MessageBoxW(NULL, L"Screen: Error getting bitmap info!", NULL, MB_OK);
		return FALSE;
	}

	// Формируем заголовок битмэпа
	BITMAPINFO bmpInfo;
	bmpInfo.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);

	// Ширина, высота и количество планов (всегда 1)
	bmpInfo.bmiHeader.biWidth = bmp.bmWidth;
	bmpInfo.bmiHeader.biHeight = bmp.bmHeight;
	bmpInfo.bmiHeader.biPlanes = 1;

	// Устанавливаем разрядность картинки и размер палитры
	// Вариант с черно-белым изображением не рассматриваем,
	// т.к. Windows работает только в цветных режимах
	if (bmp.bmBitsPixel <= 4) {
		// Цветное изображение, 4 бита, 16 цветов в палитре
		bmpInfo.bmiHeader.biBitCount = 4;
		bmpInfo.bmiHeader.biClrUsed = 16;
	}
	else
		if (bmp.bmBitsPixel <= 8) {
			// Цветное изображение, 8 бит, 256 цветов в палитре
			bmpInfo.bmiHeader.biBitCount = 8;
			bmpInfo.bmiHeader.biClrUsed = 256;
		}
		else {
			// Цветное изображение, True Color, 24 бита, палитры нет
			bmpInfo.bmiHeader.biBitCount = 24;
			bmpInfo.bmiHeader.biClrUsed = 0;
		}

	// Компрессии нет. Остальное - малозначимые установки
	bmpInfo.bmiHeader.biCompression = BI_RGB;
	bmpInfo.bmiHeader.biClrImportant = 0;
	bmpInfo.bmiHeader.biXPelsPerMeter = 0;
	bmpInfo.bmiHeader.biYPelsPerMeter = 0;

	// Вычисляем, сколько байт занимает одна строчка изображения
	DWORD dwEffWidth = (((bmpInfo.bmiHeader.biBitCount * bmpInfo.bmiHeader.biWidth) + 31) / 32) * 4;
	// Вычисляем размер изображения: байт в строке * высота изображения
	bmpInfo.bmiHeader.biSizeImage = dwEffWidth * bmpInfo.bmiHeader.biHeight;

	// Вычисляем размер палитры
	DWORD dwPaletteSize = bmpInfo.bmiHeader.biClrUsed * sizeof(RGBQUAD);

	// Вычисляем, сколько памяти потребуется для размещения битмэпа
	// Размер заголовка + размер палитры + размер самого изображения
	DWORD dwImageSize = bmpInfo.bmiHeader.biSize + dwPaletteSize +
		bmpInfo.bmiHeader.biSizeImage;

	// Выделяем эту память
	LPVOID lpBuf = ::VirtualAlloc(NULL, dwImageSize, MEM_COMMIT, PAGE_READWRITE);
	if (lpBuf != NULL) {
		// Копируем в начало буфера заголовок битмэпа
		*((LPBITMAPINFOHEADER)lpBuf) = bmpInfo.bmiHeader;
		// Получаем указатель на начало области пикселей
		LPBYTE lpBits = (LPBYTE)lpBuf + bmpInfo.bmiHeader.biSize + dwPaletteSize;
		// Считываем изображение
		LONG dwLines = ::GetDIBits(hDC, hBitmap, 0, bmpInfo.bmiHeader.biHeight, lpBits,
			(LPBITMAPINFO)lpBuf, DIB_RGB_COLORS);

		// Проверяем, целиком ли мы его считали?
		if (dwLines < bmpInfo.bmiHeader.biHeight) {
			MessageBoxW(NULL, L"Screen: Screen: Screen shot incomplete", NULL, MB_OK);
		}
		// Если используется палитра
		if (bmpInfo.bmiHeader.biClrUsed) {
			// Выделяем память под палитру
			LPPALETTEENTRY pal = new PALETTEENTRY[bmpInfo.bmiHeader.biClrUsed];

			// Считываем системную палитру
			UINT iCols = ::GetSystemPaletteEntries(hDC, 0, bmpInfo.bmiHeader.biClrUsed, pal);
			if (iCols < bmpInfo.bmiHeader.biClrUsed) {
				MessageBoxW(NULL, L"Screen: Palette loading incomplete", NULL, MB_OK);
			}
			// Копируем палитру в изображение
			RGBQUAD *rgb = (RGBQUAD *)((LPBYTE)lpBuf + bmpInfo.bmiHeader.biSize);
			for (UINT i = 0; i < bmpInfo.bmiHeader.biClrUsed; i++) {
				rgb[i].rgbRed = pal[i].peRed;
				rgb[i].rgbGreen = pal[i].peGreen;
				rgb[i].rgbBlue = pal[i].peBlue;
				rgb[i].rgbReserved = 0;
			}

			// Освобождаем память
			delete pal;
		}

		// Создаем файл картинки
		FILE *hBMP = fopen(lpszFileName, "wb");
		if (hBMP != NULL) {
			BITMAPFILEHEADER fh;
			fh.bfType = 0x4D42;
			fh.bfSize = sizeof(BITMAPFILEHEADER) + dwImageSize;
			fh.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + dwPaletteSize;
			fh.bfReserved1 = 0;
			fh.bfReserved2 = 0;

			fwrite(&fh, sizeof(BITMAPFILEHEADER), 1, hBMP);
			fwrite(lpBuf, dwImageSize, 1, hBMP);

			// Не забываем закрыть файл
			if (fclose(hBMP) != 0) {
				MessageBoxW(NULL, L"Screen: Error closing file", NULL, MB_OK);
			}
		}
		else {
			MessageBoxW(NULL, L"Screen: Error creating screenshot file", NULL, MB_OK);
		}

		// Освобождаем память
		if (::VirtualFree(lpBuf, 0, MEM_RELEASE) == FALSE) {
			MessageBoxW(NULL, L"Screen: Error releasing virtual memory", NULL, MB_OK);
		}
	}
	else {
		MessageBoxW(NULL, L"Screen: Error allocating virtual memory", NULL, MB_OK);
	}
	return TRUE;
}

LRESULT CALLBACK
MainWndProc (HWND Window, UINT AMessage, WPARAM WParam, LPARAM LParam)
{
	switch(AMessage)
	{
		case WM_CREATE:
		{
			RECT Rect;

			HDC hMyDC = GetDC(hWndMain);
			GetClientRect(hWndMain, &Rect);

			wid = GetSystemMetrics(SM_CXFULLSCREEN);
			hei = GetSystemMetrics(SM_CYFULLSCREEN);
			currSurface = 0;

			memDC = CreateCompatibleDC(hMyDC);
			hbit = CreateCompatibleBitmap(hMyDC, wid, hei);
			SelectObject(memDC, hbit);
			ReleaseDC(hWndMain, hMyDC);
		}
		break;

		case WM_COMMAND:
			switch(LOWORD(WParam))
			{
				case BTN_START_ID:
					for(int i = 0; i < funcCount; i++) {
						DrawIt(i);
						InvalidateRect(hWndMain, NULL, true);
						SendMessage(myProgress, PBM_SETPOS, 0, 0);
					}
					break;

				case BTN_SURF_ID:
				{
					DrawSurface(currSurface);
					SendMessage(myProgress, PBM_SETPOS, 0, 0);
					InvalidateRect(hWndMain, NULL, true);

					char f_name[256] = {0};
					sprintf(f_name, "pic%d.bmp", currSurface + 1);
					SavePicture(memDC, hbit, f_name);
					if(++currSurface == surfCount) currSurface = 0;

					char Caption[50] = {0};
					sprintf(Caption, "%s (%d)", surfCaption, currSurface + 1);
					SendMessage(btnSurf, WM_SETTEXT, 0, (LPARAM)Caption);
				}
				break;

				case BTN_SAVE_ID:
					SaveResults();
					break;
			}
			break;

		case WM_PAINT:
		{
			PAINTSTRUCT ps;
			HDC hMyDC = BeginPaint(hWndMain, &ps);
			BitBlt(hMyDC, 0, 0, wid, hei, memDC, 0, 0, SRCCOPY);
			EndPaint(hWndMain, &ps);
		}
		break;

		case WM_DESTROY:
			DeleteDC(memDC);
			DeleteObject(hbit);

			PostQuitMessage(0);
			return 0;

		default: // for messages that we don't deal with
			return DefWindowProc (Window, AMessage, WParam, LParam);
	}
	return 0;
}

BOOL InitApplication(HINSTANCE hInstance)
{
	WNDCLASS wcx;

	//Заполняем структуру TWndClass
	// перерисовываем, если размер изменяется
	wcx.style = CS_HREDRAW | CS_VREDRAW;

	// адрес оконной процедуры
	wcx.lpfnWndProc = MainWndProc;
	wcx.cbClsExtra = 0;
	wcx.cbWndExtra = 0;

	// handle to instance
	wcx.hInstance = hInstance;
	// загружаем стандандартную иконку
	wcx.hIcon = LoadIcon(0, IDI_APPLICATION);
	// загружаем стандартный курсор
	wcx.hCursor = LoadCursor(0, IDC_ARROW);
	// делаем светло-cерый фон
	wcx.hbrBackground = (HBRUSH)COLOR_BACKGROUND;
	// пока нет главного меню
	wcx.lpszMenuName = NULL;
	// имя класса окна
	wcx.lpszClassName = winName;

	// Регистрируем наш класс окна.
	return RegisterClass(&wcx);
}



HWND InitInstance(HINSTANCE hInstance)
{
	// Создаем главное окно.
	return CreateWindow(
		// имя класса окна
		winName,
		// заголовок
		"Test program",
		// стандартный стиль окна
		WS_OVERLAPPEDWINDOW,
		// стандартные горизонтальное, вертикальное положение, ширина и высота
		CW_USEDEFAULT, CW_USEDEFAULT,
		CW_USEDEFAULT, CW_USEDEFAULT,
		NULL, //нет родительского окна
		NULL, //нет меню
		hInstance, // handle to application instance
		NULL); // no window-creation data

}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE, PSTR, int)
{
	MSG msg;
	if(!InitApplication(hInstance)) {
		MessageBoxW(NULL, L"Ошибка регистрации класса окна", NULL, MB_OK);
		return 0;
	}
	else {
		hWndMain = InitInstance(hInstance);
		if(!hWndMain) {
			MessageBoxW(NULL, L"Ошибка создания окна", NULL, MB_OK);
			return 0;
		}
		else {
			// Показываем окно и посылаем сообщение WM_PAINT оконной процедуре
			ShowWindow(hWndMain, SW_SHOWMAXIMIZED);

			HWND btnStart = CreateWindowEx(0, "BUTTON", "Draw main",
				WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				10, 120, 175, 21, hWndMain, (HMENU)BTN_START_ID, hInstance, NULL);
			char Caption[50] = {0};
			sprintf(Caption, "%s (1)", surfCaption);
			btnSurf = CreateWindowEx(0, "BUTTON", Caption,
				WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				10, 175, 175, 21, hWndMain, (HMENU)BTN_SURF_ID, hInstance, NULL);
			HWND btnSaveRes = CreateWindowEx(0, "BUTTON", "Save results",
				WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				10, 200, 175, 21, hWndMain, (HMENU)BTN_SAVE_ID, hInstance, NULL);

			hListBox = CreateWindow("listbox", NULL,
				WS_CHILD | LBS_STANDARD | WS_VSCROLL | LBS_DISABLENOSCROLL | WS_VISIBLE,
				10, 10, 575, 100, hWndMain, (HMENU)ID_LISTBOX, hInstance, NULL);

			HFONT myFont = CreateFont(-11, 0, 0, 0, FW_NORMAL, 0, 0, 0,
				DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
				DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, "MS Sans Serif");
			if(myFont) {
				SendMessage(btnStart, WM_SETFONT, WPARAM(myFont), 0);
				SendMessage(btnSurf, WM_SETFONT, WPARAM(myFont), 0);
				SendMessage(btnSaveRes, WM_SETFONT, WPARAM(myFont), 0);
				SendMessage(hListBox, WM_SETFONT, WPARAM(myFont), 0);
			}

			// Создаем прогрессбар
			myProgress = CreateWindow("msctls_progress32", NULL,
				WS_CHILD | WS_VISIBLE,
				10, 145, 175, 21, hWndMain, 0, hInstance, NULL);
			// устанавливаем границы
			SendMessage(myProgress, PBM_SETRANGE, 0, MAKELPARAM(0, 100));

			UpdateWindow(hWndMain);
			while(GetMessage(&msg, NULL, 0, 0)) {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
	}
	return msg.wParam;
}

