﻿program Test;
uses
  // Добавьте свой модуль в список Uses
  Windows, Messages, sysutils, math;

{$define NOCONTEST}
{$define EXAMPLE}

{$ifdef EXAMPLE}
{$ifdef CONTEST}
type
  TFunction = record
    foo: integer;
  end;

function setFunction(var f: TFunction; const s: string): boolean;
begin
  result := true;
end;

procedure setVarFunction(var f: TFunction; ch: Char; value: Double);
begin end;
function calcFunction(var f: TFunction; var errCode: integer): double;
begin
  result := 0;
end;

procedure resetFunction(var f: TFunction);
begin end;
{$endif}
{$endif}


// ******************************************
const
  HLSMAX = 240;
  RGBMAX = 255;
  UNDEFINED = (HLSMAX*2) div 3;

procedure HLStoRGB(H, L, S: integer; var R, G, B: integer);
var
  Magic1, Magic2: single;

  function HueToRGB(n1, n2, hue: single): single;
  begin
    if (hue < 0) then
      hue := hue+HLSMAX;
    if (hue > HLSMAX) then
      hue:=hue - HLSMAX;
    if (hue < (HLSMAX/6)) then
      result:= ( n1 + (((n2-n1)*hue+(HLSMAX/12))/(HLSMAX/6)) )
    else
    if (hue < (HLSMAX/2)) then
      result:=n2
    else
    if (hue < ((HLSMAX*2)/3)) then
      result:= ( n1 + (((n2-n1)*(((HLSMAX*2)/3)-hue)+(HLSMAX/12))/(HLSMAX/6)))
    else
      result:= ( n1 );
  end;

begin
  if (S = 0) then begin
    B:=round( (L*RGBMAX)/HLSMAX ); R:=B; G:=B;
  end
  else begin
    if (L <= (HLSMAX/2)) then
      Magic2 := (L*(HLSMAX + S) + (HLSMAX/2))/HLSMAX
    else
      Magic2 := L + S - ((L*S) + (HLSMAX/2))/HLSMAX;

    Magic1 := 2*L-Magic2;
    R := round( (HueToRGB(Magic1,Magic2,H+(HLSMAX/3))*RGBMAX + (HLSMAX/2))/HLSMAX );
    G := round( (HueToRGB(Magic1,Magic2,H)*RGBMAX + (HLSMAX/2)) / HLSMAX );
    B := round( (HueToRGB(Magic1,Magic2,H-(HLSMAX/3))*RGBMAX + (HLSMAX/2))/HLSMAX );

  end;
  if R<0 then R:=0;
  if R>RGBMAX then R:=RGBMAX;

  if G<0 then G:=0;
  if G>RGBMAX then G:=RGBMAX;

  if B<0 then B:=0;
  if B>RGBMAX then B:=RGBMAX;
end;

// ******************************************
type
  paramR = record
    a, b, c: double;
    scX, scY, scZ: integer;
  end;

{$ifdef CONTEST}
var
  f_x, f_y, f_z: TFunction;
  errCode: integer;
{$endif}

procedure fPlane(const R: paramR;
          u, v: double; var X, Y, Z: double);
// Just a plane
begin
{$ifdef CONTEST}
  {$i CALC.INC}
{$else}
  X := R.scX * u;
  Y := R.scY * v;
  Z := 0;
{$endif}
end;

procedure fSteinersRoman(const R: paramR;
          u, v: double; var X, Y, Z: double);
// Steiner's Roman Surface (a = 1.23)
begin
{$ifdef CONTEST}
  {$i CALC.INC}
{$else}
  X := R.scX * (1/2) * sqr(R.a) * sqr(cos(v)) * sin(2 * u);
  Y := R.scY * (1/2) * sqr(R.a) * sin(u) * sin(2 * v);
  Z := R.scZ * (1/2) * sqr(R.a) * cos(u) * sin(3 * v);
{$endif}
end;
procedure fKleinBottle(const R: paramR;
          u, v: double; var X, Y, Z: double);
// The Klein Bottle (a = 1.1)
begin
{$ifdef CONTEST}
  {$i CALC.INC}
{$else}
  X := R.scX * cos(u) * (R.a + cos(u/2)*sin(v) - sin(u/2)*sin(2*v));
  Y := R.scY * sin(u) * (R.a + cos(u/2)*sin(v) - sin(u/2)*sin(2*v));
  Z := R.scZ * (sin(u/2)*sin(v) + cos(u/2)*sin(2*v));
{$endif}
end;
// ******************************************

type
  funcType = function(angle, radius: double): double;
  funcRec = record
    func: funcType;
  end;

// Just a foo function. Surprise :)
function foo(A, R: double): double;
begin
  result := 1.0;
end;

const
  funcCount = 1;
var
  fArr: array[1 .. funcCount] of funcRec = (
    (func: foo)
  );

type
  surfProcType = procedure (const R: paramR;
                        u, v: double; var X, Y, Z: double);
  surfRec = record
    params: paramR;
    func: surfProcType;
    u_st, u_fn: double;
    v_st, v_fn: double;

    fX, fY, fZ: string;
  end;
  surfResult = record
    calls: dword;
    tm: cardinal;
    tckUser, tckTotal: int64;
  end;

const
  n_a = 0.0;
  surfCount = 3; // 18 functions in the REAL test
  fList: array[1 .. surfCount] of surfRec = (
    (
      params:(
        a:n_a; b:n_a; c:n_a;
        scX:150; scY:150; scZ:150;
      );
      func: fPlane;
      u_st:-1.0; u_fn:1.0;
      v_st:-1.0; v_fn:1.0;

      fX:'X*U'; fY:'Y*V'; fZ:'0'
    ),
    (
      params:(
        a:1.23; b:n_a; c:n_a;
        scX:250; scY:250; scZ:250;
      );
      func: fSteinersRoman;
      u_st:0.0; u_fn:2*pi;
      v_st:0.0; v_fn:2*pi;
      fX:'X*(1/2)*A^2*(cos(V))^2*sin(2*U)';
      fY:'Y*(1/2)*A^2*sin(U)*sin(2*V)';
      fZ:'Z*(1/2)*A^2*cos(U)*sin(3*V)'
    ),
    (
      params:(
        a:1.1; b:n_a; c:n_a;
        scX:200; scY:200; scZ:200;
      );
      func: fKleinBottle;
      u_st:0.0; u_fn:2*pi;
      v_st:0.0; v_fn:2*pi;
      fX:'X*cos(U)*(A+cos(U/2)*sin(V) - sin(U/2)*sin(2*V))';
      fY:'Y*sin(U)*(A+cos(U/2)*sin(V) - sin(U/2)*sin(2*V))';
      fZ:'Z*(sin(U/2)*sin(V)+cos(U/2)*sin(2*V))'
    )
  );

var
  fResults: array[1 .. surfCount + 1] of surfResult;

function GetSurfResStr(i: integer): string;
begin
  with fResults[i] do begin
    result := format(
      'Surface #%d; %d function calls; time = %d; %d ticks, %d total ticks',
      [i, calls, tm, tckUser, tckTotal]);
  end;
end;


Const
  PBM_SETRANGE = WM_USER + 1;
  PBM_SETPOS = WM_USER + 2;
  PBM_STEPIT = WM_USER + 5;

const
  winName = 'MainWClass';

  BTN_START_ID = 110;
  BTN_SURF_ID  = 115;
  BTN_SAVE_ID  = 116;
  ID_LISTBOX   = 111;
  surfCaption = 'Draw surfaces';

var
  hwndMain, btnSurf: HWND;
  myProgress, hListBox: HWND;

  memdc: HDC;
  hbit: HBITMAP;

  currSurface: integer;

  center_x, center_y: integer;
  wid, hei: integer;

function rdtsc:Int64;
asm
  rdtsc
  mov    dword ptr [Result], eax
  mov    dword ptr [Result + 4], edx
end;

procedure DrawSurface(iFuncs: integer);

  procedure Draw3DPnt(X, Y, Z: double);
  const Sqrt2 = 1.414213562;
  var NewZ: Integer;

  function CoordX(X, Z: double): Integer;
  begin
    CoordX := trunc((X + Center_X) - Z);
  end;
  function CoordY(Y, Z: double): Integer;
  begin
    CoordY := trunc(Center_Y - Y + Z);
  end;

begin
  NewZ := Trunc(Z / Sqrt2);
  SetPixel(memDC, CoordX(X, NewZ), CoordY(Y, NewZ), RGB($0, $FF, $0));
end;

const
  dp_u = pi / 300;
  dp_v = pi / 300;
var
  p_v, p_u: double;
  X, Y, Z: double;

  counter: dword;
  dt: cardinal;
  dTimeStart, dTimeFinish, cmTime: int64;
  ts, tf: int64;
  info: string;
begin
  patblt(memDC,0, 0, wid, hei, BLACKNESS);
  center_x := wid div 2;
  center_y := hei div 2;

  cmTime := 0; counter := 0;
  dt := GetTickCount; ts := rdtsc;

  {$ifdef CONTEST}
    with fList[iFuncs] do begin
      setFunction(f_x, fX);
      setVarFunction(f_x, 'X', params.scX);
      setVarFunction(f_x, 'A', params.a);
      setVarFunction(f_x, 'B', params.b);
      setVarFunction(f_x, 'C', params.c);

      setFunction(f_y, fY);
      setVarFunction(f_y, 'Y', params.scY);
      setVarFunction(f_y, 'A', params.a);
      setVarFunction(f_y, 'B', params.b);
      setVarFunction(f_y, 'C', params.c);

      setFunction(f_z, fZ);
      setVarFunction(f_z, 'Z', params.scZ);
      setVarFunction(f_z, 'A', params.a);
      setVarFunction(f_z, 'B', params.b);
      setVarFunction(f_z, 'C', params.c);
    end;
  {$endif}

  p_v := fList[iFuncs].v_st;
  while p_v <= fList[iFuncs].v_fn do begin

    p_u := fList[iFuncs].u_st;
    while p_u <= fList[iFuncs].u_fn do begin

      dTimeStart := rdtsc;
      fList[iFuncs].func(fList[iFuncs].params, p_u, p_v, X, Y, Z);
      dTimeFinish := rdtsc;
      cmTime := cmTime + (dTimeFinish - dTimeStart);

      inc(counter);
      draw3dpnt(X, Z, Y);

      p_u := p_u + dp_u;
    end;
    SendMessage(myProgress, PBM_SETPOS,
      trunc(100 * (p_v - fList[iFuncs].v_st) / (fList[iFuncs].v_fn - fList[iFuncs].v_st)), 0
    );
    p_v := p_v + dp_v;
  end;

  {$ifdef CONTEST}
    resetFunction(f_x);
    resetFunction(f_y);
    resetFunction(f_z);
  {$endif}

  tf := rdtsc;
  dt := GetTickCount - dt;

  with fResults[iFuncs] do begin
    calls := counter;
    tm := dt;
    tckUser := cmTime; tckTotal := tf - ts;
    info := GetSurfResStr(iFuncs);
  end;
  SendMessageW(hListBox, LB_INSERTSTRING, SendMessageW(hListBox, LB_GETCOUNT, 0, 0), integer(PWideChar(info)))
end;

procedure DrawIt(i: integer);
begin
   MessageBox(0, 'Implemented in REAL test only!', nil, MB_OK);
end;



procedure SaveResults;
var
  i: integer;
  s: string;
  f: TextFile;

  tm: cardinal;
  ticks: int64;
begin
  AssignFile(f, 'result.txt'); Rewrite(f);
  tm := 0; ticks := 0;
  for i := 1 to surfCount do begin
    s := GetSurfResStr(i);
    Writeln(f, s);
    inc(tm, fResults[i].tm);
    inc(ticks, fResults[i].tckUser);
  end;
  writeln(f, '***');
  writeln(f, format('total time = %d; total user ticks = %d',
                    [tm, ticks]));
  CloseFile(f);
end;


procedure SavePicture(FileName: String);
type
   TScr = array [0..1] of Byte;
   PScr = ^TScr;
var
   BFH        : BITMAPFILEHEADER;
   BIH        : tagBITMAPINFO;
   F          : File;
   ScrSize    : Cardinal;
   Bits       : PScr;
begin
   ScrSize := wid * hei * 3;
   GetMem(Bits, ScrSize);
   with BFH do
   begin
     bfType      := $4D42;
     bfSize      := wid * hei * 3 + SizeOf(BFH) + SizeOf(BIH);
     bfReserved1 := 0;
     bfReserved2 := 0;
     bfOffBits   := SizeOf(BFH) + SizeOf(BIH);
   end;
   with BIH.bmiHeader do
   begin
    biSize         := sizeof(BIH);
    biWidth        := wid;
    biHeight       := hei;
    biPlanes       := 1;
    biBitCount     := 24;
    biCompression  := BI_RGB;
    biSizeImage    := wid * hei * 3;
    biClrImportant := 0;
   end;
   GetDiBits(memDC, hbit, 0, hei, Bits, BIH, DIB_RGB_COLORS);
   AssignFile(F, FileName);
   Rewrite(F, 1);
   Blockwrite(F, BFH, SizeOf(BFH));
   Blockwrite(F, BIH, SizeOf(BIH));
   Blockwrite(F, bits^, ScrSize);
   CloseFile(F);
   FreeMem(Bits);
end;


function MainWndProc(Window: HWnd; AMessage, WParam, LParam: Longint): Longint; stdcall;
var
  hMyDC: hdc;
  rect: trect;
  i: integer;
  ps: paintstruct;
  sCaption: String;
begin
  case AMessage of
    WM_CREATE:
    begin
      hMyDC := getdc(hWndMain);
      GetClientRect(hwndmain, rect);

			wid := GetSystemMetrics(SM_CXFULLSCREEN);
      hei := GetSystemMetrics(SM_CYFULLSCREEN);

      currSurface := 1;
      memdc := CreateCompatibleDC(hMyDC);
      hbit := CreateCompatibleBitmap(hMyDC, wid, hei);
      SelectObject(memDC, hbit);
      ReleaseDC(hWndMain, hmydc);
    end;

    WM_COMMAND:
    begin
      case LOWORD(WParam) of
        BTN_START_ID:
        begin
          for i := 1 to funcCount do begin
            DrawIt(i);
            InvalidateRect(hwndmain, nil, true);
            SendMessage(myProgress, PBM_SETPOS, 0, 0);
          end;
        end;

        BTN_SURF_ID:
        begin
           DrawSurface(currSurface);
           SendMessage(myProgress, PBM_SETPOS, 0, 0);
           InvalidateRect(hwndMain, nil, True);

           SavePicture('pic' + IntToStr(currSurface) + '.bmp');

           inc(currSurface);
           if currSurface > surfCount then currSurface := 1;
           sCaption := surfCaption + ' (' + inttostr(currsurface) + ')';
           SendMessage(btnSurf, WM_SETTEXT, Length(sCaption), Integer(@sCaption[1]));
         end;

         BTN_SAVE_ID:
         begin
           SaveResults;
         end;
      end;
    end;

    WM_PAINT:
    begin
      hMyDC := BeginPaint(hwndmain, &ps);
      BitBlt(hMyDC, 0, 0, wid, hei, memDC, 0, 0, SRCCOPY);
      EndPaint(hwndmain, &ps);
    end;

    WM_DESTROY:
    begin
			DeleteDC(memDC);
			DeleteObject(hbit);

      PostQuitMessage(0);
      Result := 0;
      Exit;
    end;

    else
      Result := DefWindowProc(Window, AMessage, WParam, LParam);
  end;
end;

function InitApplication: Boolean;
var
  wcx: TWndClass;
begin
  wcx.style := CS_HREDRAW or CS_VREDRAW;
  wcx.lpfnWndProc := @MainWndProc;
  wcx.cbClsExtra := 0;
  wcx.cbWndExtra := 0;
  wcx.hInstance := hInstance;
  wcx.hIcon := LoadIcon(0, IDI_APPLICATION);
  wcx.hCursor := LoadCursor(0, IDC_ARROW);
  wcx.hbrBackground := COLOR_BACKGROUND;
  wcx.lpszMenuName := nil;
  wcx.lpszClassName := PChar(WinName);
  Result := RegisterClass(wcx) <> 0;
end;

function InitInstance: HWND;
begin
  Result := CreateWindow(
    PChar(WinName),
    'Test program',
    WS_OVERLAPPEDWINDOW,
    Integer(CW_USEDEFAULT), Integer(CW_USEDEFAULT),
    Integer(CW_USEDEFAULT), Integer(CW_USEDEFAULT),
    0,
    0,
    hInstance,
    nil
  );
end;

var
  btnStart: HWND;
  btnSaveRes: HWND;
  myFont: HFONT;
  AMessage: msg;
begin
  if (not InitApplication) then
    MessageBox(0, 'Error at class registration', nil, mb_Ok)
  else begin
    hwndMain := InitInstance;
    if (hwndMain = 0) then
      MessageBox(0, 'Error at window creation', nil, mb_Ok)
    else begin

      ShowWindow(hwndMain, SW_SHOWMAXIMIZED);
      btnStart := CreateWindowEx(0, 'BUTTON', 'Draw main',
        WS_CHILD or WS_VISIBLE or BS_PUSHBUTTON,
        10, 120, 175, 21, hWndMain, BTN_START_ID, hInstance, nil);
      btnSurf := CreateWindowEx(0, 'BUTTON', surfCaption + ' (1)',
        WS_CHILD or WS_VISIBLE or BS_PUSHBUTTON,
        10, 175, 175, 21, hWndMain, BTN_SURF_ID, hInstance, nil);
      btnSaveRes := CreateWindowEx(0, 'BUTTON', 'Save results',
        WS_CHILD or WS_VISIBLE or BS_PUSHBUTTON,
        10, 200, 175, 21, hWndMain, BTN_SAVE_ID, hInstance, nil);

      hListbox := CreateWindow('listbox', '', WS_CHILD or LBS_STANDARD or WS_VSCROLL
        or LBS_DISABLENOSCROLL or WS_VISIBLE, 10, 10, 575, 100, hWndmain, ID_LISTBOX, hInstance, nil);

      myFont := CreateFont(-11, 0, 0, 0, FW_NORMAL, 0, 0, 0,
        DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
        DEFAULT_QUALITY, DEFAULT_PITCH or FF_DONTCARE, 'MS Sans Serif');
      if myFont <> 0 then begin
        SendMessage(btnStart, WM_SETFONT, WPARAM(myFont), 0);
        SendMessage(btnSurf, WM_SETFONT, WPARAM(myFont), 0);
        SendMessage(btnSaveRes, WM_SETFONT, WPARAM(myFont), 0);
        SendMessage(hListBox, WM_SETFONT, WPARAM(myFont), 0);
      end;

      myProgress := CreateWindow('msctls_progress32', '', WS_CHILD or WS_VISIBLE,
        10, 145, 175, 21, hWndMain, 0, HInstance, nil);
      SendMessage(myProgress, PBM_SETRANGE, 0, MAKELPARAM(0, 100));

      UpdateWindow(hwndMain);
      while GetMessage(AMessage, 0, 0, 0) do begin
        TranslateMessage(AMessage);
        DispatchMessage(AMessage);
      end;
    end;
  end;
end.

