// ===================================================
// ⨭ 8. ⮡ࠦ ᮤন ⠡
//            ⥢ 窨.
//
//  wkstable\wkstable.cpp
//
// (C) A. Frolov, 1993
// ===================================================

#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <conio.h>

#define BYTE  unsigned char

// ଠ ⠡ ஢  
// ⥢ 窨

struct ConnectionIDTable {
	BYTE InUseFlag;
	BYTE OrderNumber;
	BYTE NetworkNumber[4];
	BYTE NodeAddress[6];
	BYTE SocketNumber[2];
	BYTE ReceiveTimeout[2];
	BYTE RoutingNode[6];
	BYTE PacketSequenceNumber;
	BYTE ConnectionNumber;
	BYTE ConnectionStatus;
	BYTE MaximumTimeout[2];
	BYTE Reserved[5];
};


void GetTableAddress(int Table, char far * *TableAddress);
void ShowTable(char far *DriveHandleTable);
void ShowConnIDTable(struct ConnectionIDTable far *ConnIDTable);
void ShowServerNameTable(char far *ServerNameTable);

void main(void) {

// ⥫  ⠡ ⥢ 窨

	char far *DriveHandleTable;
	char far *DriveFlagTable;
	char far *DriveServerTable;
	char far *ServerMappingTable;
	char far *ServerNameTable;

	struct ConnectionIDTable far *ConnIDTable;

// 砥 㪠⥫  ⠡

	GetTableAddress(0, &DriveHandleTable);
	GetTableAddress(1, &DriveFlagTable);
	GetTableAddress(2, &DriveServerTable);
	GetTableAddress(3, &ServerMappingTable);
	GetTableAddress(4, &ServerNameTable);

	printf("\n ⥢ 窨, (C) Frolov A., 1993\n"
				"---------------------------------------------\n");

// ⮡ࠦ ᮤন ⠡ ᮢ ᪮ ன

	printf("\nDrive Handle Table  (%Fp)\n", DriveHandleTable);
	printf(  "------------------\n");
	ShowTable(DriveHandleTable);

// ⮡ࠦ ᮤন ⠡ 䫠 ᪮ ன

	printf("\nDrive Flag Table    (%Fp)\n", DriveFlagTable);
	printf(  "----------------\n");
	ShowTable(DriveFlagTable);

// ⮡ࠦ ᮤন ⠡ ⮡ࠦ ᪮  ࢥ

	printf("\nDrive Server Table  (%Fp)\n", DriveServerTable);
	printf(  "------------------\n");
	ShowTable(DriveServerTable);

	printf("    த...\n");
	getch();

// ⮡ࠦ ᮤন ⠡   ࢥࠬ

	ConnIDTable = (struct ConnectionIDTable far *)ServerMappingTable;

	printf("\nConnection ID Table (%Fp)\n", ConnIDTable);
	printf(  "-------------------\n");
	ShowConnIDTable(ConnIDTable);

// ⮡ࠦ ᮤন ⠡  ࢥ஢

	printf("\nServer Name Table   (%Fp)\n", ServerNameTable);
	printf(  "-----------------\n");
	ShowServerNameTable(ServerNameTable);
}

// ===========================================================
// 㭪  ⮡ࠦ ⠡  ࢥ஢
// ===========================================================

void ShowServerNameTable(char far *ServerNameTable) {
	for(int i=0; i<8; i++) {
		if(*(ServerNameTable + 48*i) != '\0')
			printf("%d: %Fs\n", i+1, ServerNameTable + 48*i);
		else
			printf("%d:  ᯮ\n", i+1);
	}
}

// ===========================================================
// 㭪  ⮡ࠦ ⠡  ࠡ祩 ⠭樨
// ===========================================================

void ShowConnIDTable(struct ConnectionIDTable
								far *ConnIDTable) {

	printf("浪 :\t");
	for(int i=0; i<8; i++) {
		printf("%d   ", i+1);
	}
	printf("\n :\t\t");
	for(i=0; i<8; i++) {
		printf("%02.2X  ", (ConnIDTable + i)->ConnectionNumber);
	}

	printf("\nﭨ :\t");
	for(i=0; i<8; i++) {
		printf("%02.2X  ", (ConnIDTable + i)->ConnectionStatus);
	}
	printf("\n");
}

// ===========================================================
// 㭪  뢮 ᮤন ⠡ ⮡ࠦ
// ᪮ ன
// ===========================================================

void ShowTable(char far *Table) {

	printf("A  B  C  D  E  F  G  H  I  J  K  L  M  N  "
			 "O  P  Q  R  S  T  U  V  W  X  Y  Z\n");
	for(int i=0; i<26; i++) {
		printf("%02.2X ",(unsigned char)*(Table +i));
	}
	printf("\n[  \\  ]  ^  _  '\n");
	for(i=26; i<32; i++) {
		printf("%02.2X ",(unsigned char)*(Table +i));
	}
	printf("\n");
}

// ===========================================================
// 㭪  祭 㪠⥫  ⠡
// 窨 ࠡ祩 ⠭樨
// ===========================================================

void GetTableAddress(int Table, char far* *TableAddress) {

	union REGS regs; struct SREGS sregs;

	regs.h.ah = 0xef;
	regs.h.al = Table;
	intdosx(&regs, &regs, &sregs);
	FP_OFF(*TableAddress) = regs.x.si;
	FP_SEG(*TableAddress) = sregs.es;
}

