// ===================================================
// ⨭ 5. Include-䠩  ணࠬ SLIST.CPP
//
//  slist!\sap.hpp
//
// (C) A. Frolov, 1993
// ===================================================

// ᨬ쭮 ⢮ ࢥ஢,  
// 믮 

#define MAX_SERVERS         8

//  ࢨ SAP

#define GENERAL_SERVICE     1
#define NEAREST_SERVICE     3
#define NOT_SUPPORTED	    1

// ⪮騩 ᮪

#define SHORT_LIVED         0x00

//   SAP-⮪

#define SAP_SOCKET          0x452

//   SAP

#define SAP_PACKET_TYPE	    2

// । ᯮ㥬 ⨯ 

#define BYTE  unsigned char
#define WORD  unsigned short

// ⥢ 

typedef struct IPXAddress {
	BYTE	network[4];
	BYTE	node[6];
	WORD	socket;
} IPXAddress;

//  IPX-

typedef struct IPXHeader {
	 WORD	      checkSum;
	 WORD	      length;
	 BYTE	      transportControl;
	 BYTE	      packetType;
	 IPXAddress	destination;
	 IPXAddress	source;
} IPXHeader;

//  SAP-

typedef struct SAPHeader {
		 WORD	       checksum;
		 WORD	       length;
		 BYTE	       transportControl;
		 BYTE	       packetType;
		 IPXAddress  destination;
		 IPXAddress  source;
		 WORD	       SAPPacketType;
		 WORD	       serverType;
		 BYTE	       serverName[48];
		 IPXAddress  serverAddress;
		 WORD	       interveningNetworks;
} SAPHeader;

//   뫪 SAP-

typedef struct SAPQueryPacket {
		 WORD	       checksum;
		 WORD	       length;
		 BYTE	       transportControl;
		 BYTE	       packetType;
		 IPXAddress  destination;
		 IPXAddress  source;
		 WORD	       queryType;
		 WORD	       serverType;
} SAPQueryPacket;

//   ᠭ  ECB

typedef struct ECBFragment {
			void    far *address;
			WORD    size;
} ECBFragment;

typedef struct ECB {
		void 	      far *linkAddress;
		void 	      (far *ESRAddress)();
		BYTE 	      inUseFlag;
		BYTE 	      completionCode;
		WORD 	      socketNumber;
		BYTE 	      IPXWorkspace[4];
		BYTE 	      driverWorkspace[12];
		BYTE 	      immediateAddress[6];
		WORD 	      fragmentCount;
		ECBFragment	fragmentDescriptor[2];
} ECB;

// SAP-

typedef struct {
		 IPXHeader    Header;
		 WORD	    ResponseType;
		 WORD	    ServerType;
		 BYTE	    ServerName[48];
		 BYTE	    Network[4];
		 BYTE	    Node[6];
		 WORD	    Socket;
		 WORD	    InterveningNetworks;
} SAP;

//   । SAP-

typedef struct {
		 ECB		 theECB;
		 SAPQueryPacket	 SAPq;
} SEND_PACKET;

//   ਥ SAP-

typedef struct {
		 ECB   theECB;
		 SAP   SB;
} RECEIVE_PACKET;

// ଠ  䠩-ࢥ

typedef struct  {
	 char    serverName[48];
	 BYTE    netwareVersion;
	 BYTE    netwareSubVersion;
	 WORD    maxConnectionsSupported;
	 WORD    connectionsInUse;
	 WORD    maxVolumesSupported;
	 BYTE    revisionLevel;
	 BYTE    SFTLevel;
	 BYTE    TTSLevel;
	 WORD    peakConnectionsUsed;
	 BYTE    accountingVersion;
	 BYTE    VAPversion;
	 BYTE    queingVersion;
	 BYTE    printServerVersion;
	 BYTE    virtualConsoleVersion;
	 BYTE    securityRestrictionLevel;
	 BYTE    internetBridgeSupport;
 } FILE_SERV_INFO;

// ᠭ 㭪権 ⥪ NetWare C Interface

extern "C" int IPXInitialize(void);
extern "C" int IPXOpenSocket(WORD *, BYTE);
extern "C" int IPXListenForPacket(ECB *);
extern "C" int IPXCancelEvent(ECB *);
extern "C" int IPXCloseSocket(WORD);
extern "C" WORD IntSwap(WORD);
extern "C" void IPXGetInternetworkAddress(BYTE *);
extern "C" void IPXSendPacket(ECB *);
extern "C" void IPXRelinquishControl(void);
extern "C" IPXGetLocalTarget(BYTE *, BYTE *, int*);
extern "C" WORD IPXGetIntervalMarker(void);
extern "C" long LongSwap(long);
extern "C" int AttachToFileServer(char *, WORD *);
extern "C" int SetPrimaryConnectionID(int);
extern "C" int GetServerInformation(int, FILE_SERV_INFO *);
extern "C" WORD GetPreferredConnectionID(void);
extern "C" WORD GetPrimaryConnectionID(void);
extern "C" WORD GetDefaultConnectionID(void);
extern "C" int SetPreferredConnectionID(WORD);
extern "C" int GetConnectionID(char *, WORD *);
extern "C" void DetachFromFileServer(WORD);
extern "C" int GetNetWareShellVersion(BYTE *,BYTE *, BYTE *);
extern "C" int IsConnectionIDInUse(WORD);
extern "C" int GetNetworkSerialNumber(long *, int*);

//  SLIST

class SLIST {
private:

	WORD	QueryType;     // ⨯ 
	WORD	SrcSocket;     // ᮪

// ᨢ  ਥ SAP-⮢

	RECEIVE_PACKET	 Query[MAX_SERVERS];

// । SAP-

	SEND_PACKET   SendPacket;

//   䠩-ࢥ஢, ਩
// ஢  ஢ ਫ

	char ServerName[MAX_SERVERS][48];
	long SerialNumber[MAX_SERVERS];
	int  ApplicationNumber[MAX_SERVERS];

//  ଠ樨  䠩-ࢥ

	FILE_SERV_INFO ServerInfo[MAX_SERVERS];

//  ஢  䠩-ࢥ஢

	WORD	ConnID[MAX_SERVERS];

// 㭪樨  ਥ  । SAP-⮢

	void	ReceiveSAPPacket(RECEIVE_PACKET	 *Query);
	void 	SendSAPPacket(void);

// 㭪樨  祭  䠩-ࢥ஢ 
// 㣮 ଠ樨  䠩-ࢥ

	void  GetServersName(void);
	void  GetServersInfo(void);

public:

	int errno;              //  訡
	WORD PreferredConnID;   // ।⥫ ࢥ
	WORD PrimaryConnID;     // ࢨ ࢥ
	WORD DefaultConnID;     // ࢥ  㬮砭

	BYTE MajorVersion;      // 孨  ᨨ
	BYTE MinorVersion;      //   ᨨ
	BYTE Revision;          //  

	SLIST(int);  // 
	~SLIST();    // 

// 㭪  뢮  ॢ஢

	void  PrintServersName(void);

// ஢ઠ 訡

	int Error(void) { return errno; }
};
