// ===================================================
// ⨭ 15. Include-䠩  ࠡ  SPX
//  spx.h
//
// (C) A. Frolov, 1992
// ===================================================

#include <dos.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

// -----------------------
//  䥩 SPX
// -----------------------

#define SPX_CMD_INSTALL_CHECK					0x10
#define SPX_CMD_ESTABLISH_CONNECTION		0x11
#define SPX_CMD_LISTEN_FOR_CONNECTION		0x12
#define SPX_CMD_TERMINATE_CONNECTION		0x13
#define SPX_CMD_ABORT_CONNECTION				0x14
#define SPX_CMD_GET_CONNECTION_STATUS		0x15
#define SPX_CMD_SEND_SEQUENCED_PACKET		0x16
#define SPX_CMD_LISTEN_FOR_SEQUENCED_PACKET	0x17

struct SPXParams {
	unsigned SPXVersion;
	unsigned SPXMaxConnections;
	unsigned SPXAvailableConnCount;
};

// =========================================================
//   SPX
// =========================================================

struct SPX_HEADER {
		unsigned int	Checksum;
		unsigned int	Length;
		unsigned char	TransportControl;
		unsigned char	PacketType;
		unsigned char	DestNetwork[4];
		unsigned char	DestNode[6];
		unsigned int	DestSocket;
		unsigned char	SourceNetwork[4];
		unsigned char	SourceNode[6];
		unsigned int	SourceSocket;
// ------------᪠  SPX  ---------
		unsigned char  ConnControl;
		unsigned char  DataStreamType;
		unsigned char  SourceConnID[2];
		unsigned char  DestConnID[2];
		unsigned char  SequenceNumber[2];
		unsigned char  AckNumber[2];
		unsigned char  AllocationNumber[2];
};


int SPXCheckSPXInstallation(struct SPXParams *Params);
void SPXListenForConnection(struct ECB *ConnECB,
	unsigned char RetryCount, unsigned char WatchdogFlag);
int SPXEstablishConnection(struct ECB *ConnECB, unsigned *ConnID,
	unsigned char RetryCount, unsigned char WatchdogFlag);
void SPXListenForSequencedPacket(struct ECB *LsECB);
void SPXSendSequencedPacket(struct ECB *TxECB,
			unsigned MyConnID);
