// ===================================================
// ⨭ 14. 㭪樨 SPX.
//
//  spx.c
//
// (C) A. Frolov, 1993
// ===================================================

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include "ipx.h"
#include "spx.h"

/**
* .Name    SPXCheckSPXInstallation
*
* .Title   ஢ ⢨ ⮪ SPX
*
* .Descr      㭪 ஢, 㦥  ࠩ SPX
*           頥  ࠬ.
*
* .Params  struct *SPXParams - 㪠⥫  ,
*             ᠭ ࠬ SPX.
*
* .Return  FFh - ⮪ SPX 㦥
*          00h - ⮪ SPX  㦥
**/

int SPXCheckSPXInstallation(struct SPXParams *Params) {

	struct IPXSPX_REGS iregs;

	iregs.bx = SPX_CMD_INSTALL_CHECK;
	iregs.ax = 0;
	ipxspx_entry( (void far *)&iregs );
	Params->SPXVersion = iregs.bx;
	Params->SPXMaxConnections = iregs.cx;
	Params->SPXAvailableConnCount = iregs.dx;
	return(iregs.ax & 0xFF);
}

/**
* .Name    SPXListenForConnection
*
* .Title    ᮥ  ⮬
*
* .Descr      㭪 뤠   ᮥ
*           ⮬,    믮
*          ᮥ 맢 㭪 SPXEstablishConnection().
*
* .Params  struct ECB *ConnECB - 㪠⥫  ECB,
*                      ⠭ ᮥ.
*          unsigned char RetryCount   - 稪 ஢;
*          unsigned char WatchdogFlag - ஢ઠ 裡.
*
* .Return  祣.
**/

void SPXListenForConnection(struct ECB *ConnECB,
	unsigned char RetryCount, unsigned char WatchdogFlag) {

	struct IPXSPX_REGS iregs;

	iregs.bx = SPX_CMD_LISTEN_FOR_CONNECTION;
	iregs.ax = RetryCount |
		((unsigned)(WatchdogFlag << 8) & 0xff00);
	iregs.es = FP_SEG((void far*)ConnECB);
	iregs.si = FP_OFF((void far*)ConnECB);

	ipxspx_entry( (void far *)&iregs );
}

/**
* .Name    SPXEstablishConnection
*
* .Title   ⠭ ᮥ  ⮬
*
* .Descr      㭪 ⠭ ᮥ
*           ⮬,    믮
*          ᮥ 맢 㭪 SPXListenForConnection().
*
* .Params  struct ECB *ConnECB - 㪠⥫  ECB,
*                      ⠭ ᮥ.
*          unsigned char RetryCount   - 稪 ஢;
*          unsigned char WatchdogFlag - ஢ઠ 裡.
*
* .Return  祣.
**/

int SPXEstablishConnection(struct ECB *ConnECB, unsigned *ConnID,
	unsigned char RetryCount, unsigned char WatchdogFlag) {

	struct IPXSPX_REGS iregs;

	iregs.bx = SPX_CMD_ESTABLISH_CONNECTION;
	iregs.ax = RetryCount |
		((unsigned)(WatchdogFlag << 8) & 0xff00);
	iregs.es = FP_SEG((void far*)ConnECB);
	iregs.si = FP_OFF((void far*)ConnECB);

	ipxspx_entry( (void far *)&iregs );
	*ConnID = iregs.dx;
	return(iregs.ax & 0xff);
}

/**
* .Name    SPXListenForSequencedPacket
*
* .Title   ਥ  SPX
*
* .Descr      㭪 뤠   ਥ  SPX.
*
* .Params  struct ECB *LsECB - 㪠⥫  ECB,
*                      ਥ SPX-.
*
* .Return  祣.
**/

void SPXListenForSequencedPacket(struct ECB *LsECB) {

	struct IPXSPX_REGS iregs;

	iregs.bx = SPX_CMD_LISTEN_FOR_SEQUENCED_PACKET;
	iregs.es = FP_SEG((void far*)LsECB);
	iregs.si = FP_OFF((void far*)LsECB);

	ipxspx_entry( (void far *)&iregs );
}

/**
* .Name    SPXSendSequencedPacket
*
* .Title   ।  SPX
*
* .Descr      㭪 뤠   ।  SPX.
*
* .Params  struct ECB *TxECB - 㪠⥫  ECB,
*                      । SPX-.
*
* .Return  祣.
**/

void SPXSendSequencedPacket(struct ECB *TxECB,
			unsigned ConnID) {

	struct IPXSPX_REGS iregs;

	iregs.bx = SPX_CMD_SEND_SEQUENCED_PACKET;
	iregs.es = FP_SEG((void far*)TxECB);
	iregs.si = FP_OFF((void far*)TxECB);
	iregs.dx = ConnID;

	ipxspx_entry( (void far *)&iregs );
}
