// ===================================================
// ⨭ 22. ࢥ NETBIOS, ਠ 
//           ᯮ짮 
//
//  nbserver.cpp
//
// (C) A. Frolov, 1993
// ===================================================

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <mem.h>
#include <string.h>
#include "netbios.hpp"

//  ࢥ஢ NETBIOS

class NETBIOS_SESSION_SERVER {

	unsigned errno;
	void interrupt ( *int5C)(...);

public:

//  ࠭  ࢥ
//   ⮣ 

	char OurName[16];
	unsigned NetworkNameNumber;

//  NCB,  㤥 ᯮ짮  
// 

	NCB AddNameNCB;

// , ஢ 稥 NETBIOS
//   

	NETBIOS_SESSION_SERVER(char *Name) {

// ஢塞   

		if(strlen(Name) > 15) {
			errno = 0xff;
			return;
		}
		strcpy(OurName, Name);

// ஢塞 稥 䥩 NETBIOS

		int5C = getvect(0x5c);
		errno = 0;
		if(FP_SEG(int5C) == 0x0000 || FP_SEG(int5C) == 0xF000) {
			errno=0xff;
			return;
		}

// 塞 

		AddNameNCB.WAddName(OurName);

//  祭  

		NetworkNameNumber = AddNameNCB.GetNetworkNameNumber();
		errno = AddNameNCB.Error();
		if(errno) return;

// ⠭ "*"   CallName,  砥,
//  ࢥ 㤥 ࠡ뢠   ᮧ
//    

		AddNameNCB.SetCallName("*");

// ⠭ ६ ⠩-  
// ਥ  ।   

		AddNameNCB.SetRtoSto(20,20);

//    ਭ饩 ஭

		AddNameNCB.WListen();
	}

// , 㤠   .

	~NETBIOS_SESSION_SERVER() {

//  

		AddNameNCB.WHangUp();

//  

		AddNameNCB.WDeleteName(OurName);
		errno = AddNameNCB.Error();
	}

// 㭪  ஢ન  訡

	int Error(void) {return errno;}

// 㭪  ਥ   

	void Receive(char *ReceiveBuffer, unsigned BufferSize) {

// 뢠  NCB    

		AddNameNCB.SetBuffer(ReceiveBuffer, BufferSize);

// 믮塞 ਥ ⠣ࠬ  

		AddNameNCB.WReceive();

	}
};

void main(void) {

//  ࢥ   "NETBIOS Server"

	NETBIOS_SESSION_SERVER Server("NETBIOS Server");
	char ReceiveBuffer[512];

// ஢塞, 뫨  訡  ⠯
// 樠樨 ࢥ.

	if(Server.Error()) {
		printf("訡 %02.2X\n", Server.Error());
		return;
	}
	printf("樠 襭.\n");
	printf(" ᮮ饭  .\n");

// ਭ ᮮ饭    ,
//   ᮧ ஬
//  NETBIOS_SESSION_SERVER

	Server.Receive(ReceiveBuffer, 512);
	printf("ਭ: >%s<\n",ReceiveBuffer);
}