// ===================================================
// ⨭ 4. ࢥ IPX
//
//  ipxserv.c
//
// (C) A. Frolov, 1993
// ===================================================

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <mem.h>
#include <string.h>
#include "ipx.h"

#define BUFFER_SIZE 512

void main(void) {

// ᯮ㥬 ᮪ 0x4567

	static unsigned Socket = 0x4567;

//  ECB  㤥 ᯮ짮   ਥ
// ⮢,    ।.

	struct ECB RxECB;

//  ਭ  । ⮢

	struct IPX_HEADER RxHeader, TxHeader;

//   ਭ  । ⮢

	unsigned char RxBuffer[BUFFER_SIZE];
	unsigned char TxBuffer[BUFFER_SIZE];

	printf("\n*ࢥ IPX*, (C) ஫ ., 1993\n\n");

// ஢塞 稥 ࠩ IPX  ।塞
//  窨 室  API

	if(ipx_init() != 0xff) {
		printf("IPX  㦥!\n"); exit(-1);
	}

// 뢠 ᮪,  ஬  㤥
// ਭ 

	if(IPXOpenSocket(SHORT_LIVED, &Socket)) {
		printf("訡  ⨨ ᮪\n");
		exit(-1);
	};

// ⠢ ECB  ਥ 

	memset(&RxECB, 0, sizeof(RxECB));
	RxECB.Socket            = IntSwap(Socket);
	RxECB.FragmentCnt       = 2;
	RxECB.Packet[0].Address = &RxHeader;
	RxECB.Packet[0].Size    = sizeof(RxHeader);
	RxECB.Packet[1].Address = RxBuffer;
	RxECB.Packet[1].Size    = BUFFER_SIZE;

	IPXListenForPacket(&RxECB);

	printf("   \n");
	printf(" ⬥   \n");

	while(RxECB.InUse) {
		IPXRelinquishControl();
		if(kbhit()) {
			getch();
			RxECB.CCode = 0xfe;
			break;
		}
	}
	if(RxECB.CCode == 0) {
		printf("ਭ    '%s'\n", RxBuffer);
		printf(" த   \n");
		getch();

// ⠢ ECB  । 
//  ImmAddress  塞, ⠪  ⠬
// 㦥 室  ⠭樨 .
//  ⮬,   ⮫쪮  ਭ﫨  
//     ⮬  ECB ⠭
// ।⢥  ⠭樨, 
// ࠢ 

		RxECB.Socket            = IntSwap(Socket);
		RxECB.FragmentCnt       = 2;
		RxECB.Packet[0].Address = &TxHeader;
		RxECB.Packet[0].Size    = sizeof(TxHeader);
		RxECB.Packet[1].Address = TxBuffer;
		RxECB.Packet[1].Size    = BUFFER_SIZE;

// ⠢  

		TxHeader.PacketType = 4;
		memset(TxHeader.DestNetwork, 0, 4);
		memcpy(TxHeader.DestNode, RxECB.ImmAddress, 6);
		TxHeader.DestSocket = IntSwap(Socket);

// ⠢ । 

		strcpy(TxBuffer, "SERVER *DEMO*");

// ।  ⭮ 

		IPXSendPacket(&RxECB);
	}

// 뢠 ᮪

	IPXCloseSocket(&Socket);
	exit(0);
}