// ===================================================
// ⨭ 7.  IPX
//
//  ipxclien.c
//
// (C) A. Frolov, 1993
// ===================================================

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <mem.h>
#include <string.h>
#include <dos.h>
#include "ipx.h"

// ᨬ ࠧ  

#define BUFFER_SIZE 512

extern struct ECB far * completed_ecb_ptr;
extern void far 	ipxspx_esr(void);

void main(void) {

// 㤥 ࠡ  ᮪⮬ 0x4567

	static unsigned Socket = 0x4567;

// ECB  ਥ  । ⮢

	struct ECB RxECB, TxECB;

//  ਭ  । ⮢

	struct IPX_HEADER RxHeader, TxHeader;

//   ਭ  । 

	unsigned char RxBuffer[BUFFER_SIZE];
	unsigned char TxBuffer[BUFFER_SIZE];

	printf("\n* IPX*, (C) ஫ ., 1993\n\n");

// ஢塞 稥 ࠩ IPX  ।塞
//  窨 室  API

	if(ipx_init() != 0xff) {
		printf("IPX  㦥!\n"); exit(-1);
	}

// 뢠 ᮪,  ஬  㤥
// ਭ  । 

	if(IPXOpenSocket(SHORT_LIVED, &Socket)) {
		printf("訡  ⨨ ᮪\n");
		exit(-1);
	};

// ⠢ ECB  । 

	memset(&TxECB, 0, sizeof(TxECB));

	TxECB.Socket            = IntSwap(Socket);
	TxECB.FragmentCnt       = 2;
	TxECB.Packet[0].Address = &TxHeader;
	TxECB.Packet[0].Size    = sizeof(TxHeader);
	TxECB.Packet[1].Address = TxBuffer;
	TxECB.Packet[1].Size    = BUFFER_SIZE;

//  ।祭 ᥬ ⠭  

	memset(TxECB.ImmAddress, 0xff, 6);

// ⠢  

	TxHeader.PacketType = 4;
	memset(TxHeader.DestNetwork, 0, 4);
	memset(TxHeader.DestNode, 0xff, 6);
	TxHeader.DestSocket = IntSwap(Socket);

// 뢠 । 

	strcpy(TxBuffer, "ESR/CLIENT *DEMO*");

// ।  ᥬ ⠭   

	IPXSendPacket(&TxECB);

	completed_ecb_ptr = (unsigned long)0;

// ⠢ ECB  ਥ   ࢥ

	memset(&RxECB, 0, sizeof(RxECB));
	RxECB.Socket            = IntSwap(Socket);
	RxECB.FragmentCnt       = 2;
	RxECB.Packet[0].Address = &RxHeader;
	RxECB.Packet[0].Size    = sizeof(RxHeader);
	RxECB.Packet[1].Address = RxBuffer;
	RxECB.Packet[1].Size    = BUFFER_SIZE;
	RxECB.ESRAddress        = ipxspx_esr;

	IPXListenForPacket(&RxECB);

	printf(" ⢥  ࢥ\n");
	printf("  \n");
	printf(" ⬥   <ESC>\n");

//  室 ⢥  ࢥ

	while(completed_ecb_ptr == NULL) {
		if( getche() == 27) {
			IPXCloseSocket(&Socket);
			exit(0);
		}
	}
	if(RxECB.CCode == 0) {
		printf("\nਭ ⢥  ࢥ '%s'\n", RxBuffer);
	}

// 뢠 ᮪

	IPXCloseSocket(&Socket);
	exit(0);
}