// ===================================================
// ⨭ 12. ࢥ SPX
//
//  spxserv.c
//
// (C) A. Frolov, 1993
// ===================================================

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <mem.h>
#include <string.h>
#include "ipx.h"
#include "spx.h"

#define BUFFER_SIZE 512

void main(void) {

// ᯮ㥬 ᮪ 0x4568

	static unsigned IPXSocket = 0x4567;
	static unsigned SPXSocket = 0x4568;

//  ECB  㤥 ᯮ짮   ਥ
// ⮢,    ।.

	struct ECB RxECB;
	struct ECB ConnECB, LsECB;

//  ਭ  । ⮢

	struct IPX_HEADER RxHeader, TxHeader;
	struct SPX_HEADER ConnHeader, LsHeader;

//   ਭ  । ⮢

	unsigned char RxBuffer[BUFFER_SIZE];
	unsigned char TxBuffer[BUFFER_SIZE];

	struct SPXParams Params;

	unsigned char ClientImmAddress[6];

	printf("\n*ࢥ SPX*, (C) ஫ ., 1993\n\n");

// ஢塞 稥 ࠩ IPX  ।塞
//  窨 室  API

	if(ipx_init() != 0xff) {
		printf("IPX  㦥!\n"); exit(-1);
	}

	if( SPXCheckSPXInstallation(&Params) != 0xFF) {
		printf("SPX  㦥!\n"); exit(-1);
	}

// 뢠 ᮪,  ஬  㤥
// ਭ 

	if(IPXOpenSocket(SHORT_LIVED, &IPXSocket)) {
		printf("訡  ⨨ ᮪ IPX\n");
		exit(-1);
	};

// ⠢ ECB  ਥ 

	memset(&RxECB, 0, sizeof(RxECB));
	RxECB.Socket            = IntSwap(IPXSocket);
	RxECB.FragmentCnt       = 2;
	RxECB.Packet[0].Address = &RxHeader;
	RxECB.Packet[0].Size    = sizeof(RxHeader);
	RxECB.Packet[1].Address = RxBuffer;
	RxECB.Packet[1].Size    = BUFFER_SIZE;

	IPXListenForPacket(&RxECB);

	printf("   \n");
	printf(" ⬥   \n");

	while(RxECB.InUse) {
		IPXRelinquishControl();
		if(kbhit()) {
			getch();
			RxECB.CCode = 0xfe;
			break;
		}
	}
	if(RxECB.CCode == 0) {
		printf("ਭ    '%s'\n", RxBuffer);
		printf(" த   \n");
		getch();

		memcpy(ClientImmAddress, RxECB.ImmAddress,6);

// ⠢ ECB  । 
//  ImmAddress  塞, ⠪  ⠬
// 㦥 室  ⠭樨 .
//  ⮬,   ⮫쪮  ਭ﫨  
//     ⮬  ECB ⠭
// ।⢥  ⠭樨, 
// ࠢ 

		RxECB.Socket            = IntSwap(IPXSocket);
		RxECB.FragmentCnt       = 2;
		RxECB.Packet[0].Address = &TxHeader;
		RxECB.Packet[0].Size    = sizeof(TxHeader);
		RxECB.Packet[1].Address = TxBuffer;
		RxECB.Packet[1].Size    = BUFFER_SIZE;

// ⠢  

		TxHeader.PacketType = 4;
		memset(TxHeader.DestNetwork, 0, 4);
		memcpy(TxHeader.DestNode, RxECB.ImmAddress, 6);
		TxHeader.DestSocket = IntSwap(IPXSocket);

// ⠢ । 

		strcpy(TxBuffer, "SPX SERVER *DEMO*");

// ।  ⭮ 

		IPXSendPacket(&RxECB);

		printf("  ࢥ஬ ⠭\n");
		printf(" SPX-\n\n");

// 뢠 ᮪  ࠡ  ⮪ SPX

		if(IPXOpenSocket(SHORT_LIVED, &SPXSocket)) {
			printf("訡  ⨨ ᮪ SPX\n");
			exit(-1);
		};

// ⠢ ECB  ਥ 

		memset(&LsECB, 0, sizeof(LsECB));
		LsECB.Socket            = IntSwap(SPXSocket);
		memcpy(LsECB.ImmAddress, ClientImmAddress,6);
		LsECB.FragmentCnt       = 2;
		LsECB.Packet[0].Address = &LsHeader;
		LsECB.Packet[0].Size    = sizeof(LsHeader);
		LsECB.Packet[1].Address = RxBuffer;
		LsECB.Packet[1].Size    = BUFFER_SIZE;

		SPXListenForSequencedPacket(&LsECB);

// ⠢  

		ConnHeader.PacketType = 5;
		ConnHeader.TransportControl = 0;
		memset(ConnHeader.DestNetwork, 0, 4);
		memcpy(ConnHeader.DestNode, ClientImmAddress, 6);
		ConnHeader.DestSocket = IntSwap(SPXSocket);

		memset(&ConnECB, 0, sizeof(ConnECB));
		ConnECB.Socket = IntSwap(SPXSocket);
		ConnECB.FragmentCnt       = 1;
		ConnECB.Packet[0].Address = &ConnHeader;
		ConnECB.Packet[0].Size    = sizeof(ConnHeader);

//    ᮧ 

		SPXListenForConnection(&ConnECB,0,0);

		while(ConnECB.InUse) {
			IPXRelinquishControl();
			if(kbhit()) {
				getch();
				ConnECB.CCode = 0xfe;
				break;
			}
		}

		if(ConnECB.CCode == 0) {
			printf(" %04.4X ᮧ\n",
				(unsigned)ConnECB.ConnectionId);
		}

//  室 SPX-  

		while(LsECB.InUse) {
			IPXRelinquishControl();
			if(kbhit()) {
				getch();
				LsECB.CCode = 0xfe;
				break;
			}
		}
		if(LsECB.CCode == 0) {
			printf(" ਭ: '%s'\n", RxBuffer);
		}
	}

// 뢠 ᮪

	IPXCloseSocket(&IPXSocket);
	IPXCloseSocket(&SPXSocket);
	exit(0);
}