// ===================================================
// ⨭ 13.  SPX
//
//  spxclien.c
//
// (C) A. Frolov, 1993
// ===================================================

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <mem.h>
#include <string.h>
#include "ipx.h"
#include "spx.h"

// ᨬ ࠧ  

#define BUFFER_SIZE 512

void main(void) {

// 㤥 ࠡ  ᮪⮬ 0x4567

	static unsigned IPXSocket = 0x4567;
	static unsigned SPXSocket = 0x4568;

// ECB  ਥ  । ⮢

	struct ECB RxECB, TxECB;
	struct ECB ConnECB, LsECB, SndECB;

//  ਭ  । ⮢

	struct IPX_HEADER RxHeader, TxHeader;
	struct SPX_HEADER ConnHeader, LsHeader, SndHeader;

//   ਭ  । 

	unsigned char RxBuffer[BUFFER_SIZE];
	unsigned char TxBuffer[BUFFER_SIZE];

	struct SPXParams Params;

	unsigned char ServerImmAddress[6];
	unsigned MyConnID, ConnID;
	unsigned rc;


	printf("\n* SPX*, (C) ஫ ., 1993\n\n");

// ஢塞 稥 ࠩ IPX  ।塞
//  窨 室  API

	if(ipx_init() != 0xff) {
		printf("IPX  㦥!\n"); exit(-1);
	}

	if( SPXCheckSPXInstallation(&Params) != 0xFF) {
		printf("SPX  㦥!\n"); exit(-1);
	}

// 뢠 ᮪,  ஬  㤥
// ਭ  । 

	if(IPXOpenSocket(SHORT_LIVED, &IPXSocket)) {
		printf("訡  ⨨ ᮪\n");
		exit(-1);
	};

// 뢠 ᮪  ⮪ SPX

	if(IPXOpenSocket(SHORT_LIVED, &SPXSocket)) {
		printf("訡  ⨨ ᮪ SPX\n");
		exit(-1);
	};

// ⠢ ECB  । 

	memset(&TxECB, 0, sizeof(TxECB));

	TxECB.Socket            = IntSwap(IPXSocket);
	TxECB.FragmentCnt       = 2;
	TxECB.Packet[0].Address = &TxHeader;
	TxECB.Packet[0].Size    = sizeof(TxHeader);
	TxECB.Packet[1].Address = TxBuffer;
	TxECB.Packet[1].Size    = BUFFER_SIZE;

//  ।祭 ᥬ ⠭  

	memset(TxECB.ImmAddress, 0xff, 6);

// ⠢  

	TxHeader.PacketType = 4;
	memset(TxHeader.DestNetwork, 0, 4);
	memset(TxHeader.DestNode, 0xff, 6);
	TxHeader.DestSocket = IntSwap(IPXSocket);

// 뢠 । 

	strcpy(TxBuffer, "CLIENT *DEMO*");

// ।  ᥬ ⠭   

	IPXSendPacket(&TxECB);

// ⠢ ECB  ਥ   ࢥ

	memset(&RxECB, 0, sizeof(RxECB));
	RxECB.Socket            = IntSwap(IPXSocket);
	RxECB.FragmentCnt       = 2;
	RxECB.Packet[0].Address = &RxHeader;
	RxECB.Packet[0].Size    = sizeof(RxHeader);
	RxECB.Packet[1].Address = RxBuffer;
	RxECB.Packet[1].Size    = BUFFER_SIZE;

	IPXListenForPacket(&RxECB);

	printf(" ⢥  ࢥ\n");
	printf(" ⬥   \n");

//  室 ⢥  ࢥ

	while(RxECB.InUse) {
		IPXRelinquishControl();
		if(kbhit()) {
			getch();
			RxECB.CCode = 0xfe;
			break;
		}
	}
	if(RxECB.CCode == 0) {
		printf("ਭ ⢥  ࢥ '%s'\n", RxBuffer);
	}

// 㥬 ⥢  ࢥ

	memcpy(ServerImmAddress, RxECB.ImmAddress, 6);

// ⠢ ECB  ਥ 

	memset(&LsECB, 0, sizeof(LsECB));
	LsECB.Socket            = IntSwap(SPXSocket);
	memcpy(LsECB.ImmAddress, ServerImmAddress,6);
	LsECB.FragmentCnt       = 2;
	LsECB.Packet[0].Address = &LsHeader;
	LsECB.Packet[0].Size    = sizeof(LsHeader);
	LsECB.Packet[1].Address = RxBuffer;
	LsECB.Packet[1].Size    = BUFFER_SIZE;

	SPXListenForSequencedPacket(&LsECB);

// ⠢  

	ConnHeader.PacketType = 5;
	ConnHeader.TransportControl = 0;
	memset(ConnHeader.DestNetwork, 0, 4);
	memcpy(ConnHeader.DestNode, ServerImmAddress, 6);
	ConnHeader.DestSocket = IntSwap(SPXSocket);

	memset(&ConnECB, 0, sizeof(ConnECB));
	ConnECB.Socket = IntSwap(SPXSocket);
	ConnECB.FragmentCnt       = 1;
	ConnECB.Packet[0].Address = &ConnHeader;
	ConnECB.Packet[0].Size    = sizeof(ConnHeader);

// ⠭ SPX-  ࢥ஬

	rc = SPXEstablishConnection(&ConnECB, &MyConnID, 0, 0);

	printf(" SPX-ᮥ  ࢥ஬\n");
	printf(" ⬥   \n");

	if(rc == 0) {
		while(ConnECB.InUse) {
			IPXRelinquishControl();
			if(kbhit()) {
				getch();
				ConnECB.CCode = 0xfe;
				break;
			}
		}
	}

// 㥬 䨪  
// ।   ࢥ

	memcpy(&ConnID, &(ConnHeader.SourceConnID), 2);

	printf("  ࢥ஬ ⠭, ConnID=%d\n",
		IntSwap(ConnID));

// ⠢ ECB  । SPX-

	memset(&SndECB, 0, sizeof(SndECB));

	SndECB.Socket            = IntSwap(SPXSocket);
	SndECB.FragmentCnt       = 2;
	SndECB.Packet[0].Address = &SndHeader;
	SndECB.Packet[0].Size    = sizeof(SndHeader);
	SndECB.Packet[1].Address = TxBuffer;
	SndECB.Packet[1].Size    = BUFFER_SIZE;

	memcpy(SndECB.ImmAddress, ServerImmAddress, 6);

// ⠢  

	SndHeader.PacketType = 5;
	memset(SndHeader.DestNetwork, 0, 4);
	memcpy(SndHeader.DestNode, ServerImmAddress, 6);
	SndHeader.DestSocket = IntSwap(SPXSocket);
	SndHeader.TransportControl = 0;
	SndHeader.DataStreamType = 1;

// 뢠 । 

	strcpy(TxBuffer, "SPX/CLIENT *DEMO*");

// । SPX-

	SPXSendSequencedPacket(&SndECB, ConnID);

// 뢠 ᮪

	IPXCloseSocket(&IPXSocket);
	IPXCloseSocket(&SPXSocket);

	exit(0);
}