// ===================================================
// ⨭ 23.  NETBIOS, ਠ 
//           ᯮ짮 
//
//  nbclient.cpp
//
// (C) A. Frolov, 1993
// ===================================================

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <mem.h>
#include <string.h>
#include "netbios.hpp"

//  ⮢ NETBIOS

class NETBIOS_SESSION_CLIENT {

	unsigned errno;
	void interrupt ( *int5C)(...);

//  NCB,  㤥 ᯮ짮  
// 

		NCB AddNameNCB;

public:

//  ࠭  
//   ⮣ 

	char OurName[16];
	unsigned NetworkNameNumber;

// , ஢ 稥 NETBIOS
//   

	NETBIOS_SESSION_CLIENT(char *Name) {

// ஢塞   

		if(strlen(Name) > 15) {
			errno = 0xff;
			return;
		}
		strcpy(OurName, Name);

// ஢塞 稥 䥩 NETBIOS

		int5C = getvect(0x5c);
		errno = 0;
		if(FP_SEG(int5C) == 0x0000 || FP_SEG(int5C) == 0xF000) {
			errno=0xff;
			return;
		}

// 塞 

		AddNameNCB.WAddName(OurName);

//  祭  

		NetworkNameNumber = AddNameNCB.GetNetworkNameNumber();

// ᫨    뫨 訡,
// 蠥 ࠡ ணࠬ

		errno = AddNameNCB.Error();
		if(errno) return;

// ⠭  ࢥ,  
// 㤥 ᮧ 

		AddNameNCB.SetCallName("NETBIOS Server");

// ⠭ ६ ⠩-
//  ।  ਥ   

		AddNameNCB.SetRtoSto(20,20);

// ⠭   ।饩 ஭

		AddNameNCB.WCall();
	}

// , 㤠   .

	~NETBIOS_SESSION_CLIENT() {

//  

		AddNameNCB.WHangUp();

//  

		AddNameNCB.WDeleteName(OurName);
		errno = AddNameNCB.Error();
	}

// 㭪  ஢ન  訡

	int Error(void) {return errno;}

// 㭪  ।  

	void Send(char *ReceiveBuffer, unsigned BufferSize) {

// ⠭    

		AddNameNCB.SetBuffer(ReceiveBuffer, BufferSize);

// ।     

		AddNameNCB.WSend();
	}
};

void main(void) {

//     "NETBIOS Client"

	NETBIOS_SESSION_CLIENT Client("NETBIOS Client");

// ஢塞, 뫨  訡  ⠯
// 樠樨 .

	if(Client.Error()) {
		printf("訡 %02.2X\n", Client.Error());
		return;
	}
	printf("樠 襭.\n");

// । ᮮ饭 ࢥ  ᮧ .
//   ᮧ  ࠡ 
//  NETBIOS_SESSION_CLIENT.

	Client.Send("ਢ   NETBIOS!", 512);
}