// ===================================================
// ⨭ 18. ࢥ NETBIOS, ਠ 
//           ᯮ짮 ⠣ࠬ
//
//  nbserver.cpp
//
// (C) A. Frolov, 1993
// ===================================================

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <mem.h>
#include <string.h>
#include "netbios.hpp"

//  ࢥ஢ NETBIOS

class NETBIOS_DATAGRAM_SERVER {

	unsigned errno;
	void interrupt ( *int5C)(...);

public:

//  ࠭  ࢥ
//   ⮣ 

	char OurName[16];
	unsigned NetworkNameNumber;

// , ஢ 稥 NETBIOS
//   

	NETBIOS_DATAGRAM_SERVER(char *Name) {

//  NCB,  㤥 ᯮ짮  
// 

		NCB AddNameNCB;

// ஢塞   

		if(strlen(Name) > 15) {
			errno = 0xff;
			return;
		}
		strcpy(OurName, Name);

// ஢塞 稥 䥩 NETBIOS

		int5C = getvect(0x5c);
		errno = 0;
		if(FP_SEG(int5C) == 0x0000 || FP_SEG(int5C) == 0xF000) {
			errno=0xff;
		}

// 塞 

		AddNameNCB.WAddName(OurName);

//  祭  

		NetworkNameNumber = AddNameNCB.GetNetworkNameNumber();
		errno = AddNameNCB.Error();
	}

// , 㤠 .

	~NETBIOS_DATAGRAM_SERVER() {
		NCB AddNameNCB;
		AddNameNCB.WDeleteName(OurName);
		errno = AddNameNCB.Error();
	}

// 㭪  ஢ન  訡

	int Error(void) {return errno;}

// 㭪  ਥ ⠣ࠬ

	void Receive(char *ReceiveBuffer, unsigned BufferSize) {
		NCB ReceiveNCB;

// 뢠  NCB    

		ReceiveNCB.SetBuffer(ReceiveBuffer, BufferSize);

// 믮塞 ਥ ⠣ࠬ  

		ReceiveNCB.WReceiveDatagram(NetworkNameNumber);

	}
};

void main(void) {

//  ࢥ   "NETBIOS Server"

	NETBIOS_DATAGRAM_SERVER Server("NETBIOS Server");
	char ReceiveBuffer[512];

// ஢塞, 뫨  訡  ⠯
// 樠樨 ࢥ.

	if(Server.Error()) {
		printf("訡 %02.2X\n", Server.Error());
		return;
	}
	printf("樠 襭.\n");
	printf(" ᮮ饭  .\n");

// ਭ ᮮ饭  

	Server.Receive(ReceiveBuffer, 512);
	printf("ਭ: >%s<\n",ReceiveBuffer);

}