// ===================================================
// ⨭ 11. 㭪樨 IPX.
//
//  ipx.cpp
//
// (C) A. Frolov, 1993
// ===================================================

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include "ipx.hpp"

/**
* .Name    IntSwap
*
* .Title    ⮢  ᫮
*
* .Descr   㭪  ⠬   ᫮,
*          ஥ ।   ⢥ ࠬ
*
* .Params  unsigned i - ८ࠧ㥬 ᫮
*
* .Return  ८ࠧ ᫮
**/

unsigned IntSwap(unsigned i) {
	return((i>>8) | (i & 0xff)<<8);
}

/**
* .Name    IPXRelinquishControl
*
* .Title   । ࠢ IPX  
*
* .Descr      㭪 ᯮ  
*          襭 ਥ १   InUse
*           ECB.
*
* .Params   ᯮ
*
* .Return  祣
**/

void IPXRelinquishControl(void) {

	struct IPXSPX_REGS iregs;

	iregs.bx = IPX_CMD_RELINQUISH_CONTROL;
	ipxspx_entry( (void far *)&iregs );
}

// 㭪   ᮤন ਭ⮣
//  䨣樨.

void ECB::PrintDiagnostics(void) {
	int i, j, k, networks, component;

// ⠥ 䨣 ⮫쪮   ECB,
//   InUse  ⮨ 㫥 祭,
// .. ᫨  ਭ .

		if(!_ecb.InUse) {

// ᯥ뢠  ᪮
// প,  ᮪  SPX-⨪ 
// ⢮  ணࠬ ᯥ祭,
// ࠡ饣  ⠭樨.

			printf("\n%d.%d\t%d\t%d\t\t",
				Rep.MajVer, Rep.MinVer,
				Rep.Socket, Rep.NumberOfComponents);

// ᯥ뢠  ,  ன 襫
//  䨣樨.

			for(i=0;i<4;i++) {
			  printf("%02.2X",(unsigned char)
				IPXHeader->_ipx_header.SourceNetwork[i]);
			}
			printf("\t");

// ᯥ뢠 ⥢  ⠭樨, 
// ன 襫  䨣樨.

			for(i=0;i<6;i++) {
			  printf("%02.2X",(unsigned char)
				IPXHeader->_ipx_header.SourceNode[i]);
			}
			printf("\n\n");

//   ணࠬ 
// ᯥ뢠  .

			for(i=0;i<Rep.NumberOfComponents;) {
				switch(component=Rep.Buffer[i]) {
				case 0:
					printf("\tࠩ IPX/SPX\n");
					i++;
					break;
				case 1:
					printf("\tࠩ \n");
					i++;
					break;
				case 2:
					printf("\tࠩ ⥢ 窨\n");
					i++;
					break;
				case 3:
					printf("\t⥢ 窠\n");
					i++;
					break;
				case 4:
					printf("\t窠 VAP\n");
					i++;
					break;

//  ⮢  ࢥ஢ ⥫쭮 뢮
// ⢮ 祭   ⥩,
// ⨯  ,  祭
// ⥩  ⥢  ஢.

				case 5: case 6: case 7:
					switch(component) {
					case 5:
						printf("\t뤥 \n");
						break;
					case 6:
						printf("\t-ࢥ/७ \n");
						break;
					case 7:
						printf("\t뤥 ࢥ\n");
						break;
					}
					i++;

// ⢮ 祭 ⥩

					printf("\t\t祭 ⥩: %d",
						(unsigned char)Rep.Buffer[i]);
					networks = Rep.Buffer[i];
					i++;

//    ⠥  ⨯,
//    ⥢  .

					for(j=0;j<networks;j++) {

//  

						printf("\n\t\t\t : %d\t",
							(unsigned char)Rep.Buffer[i++]);

//  

						for(k=0;k<4;k++,i++) {
						  printf("%02.2X",(unsigned char)Rep.Buffer[i]);
						}
						printf("\t");

// ⥢  

						for(k=0;k<6;k++,i++) {
						  printf("%02.2X",(unsigned char)Rep.Buffer[i]);
						}
					}
					printf("\n");
					break;
				}
			}

		}
}

