;  䥩   맮 㭪権
; XMS  .  ணࠬ ⠭ 
;   Small.

	  .model small,c
	  .DATA

;  ⮬  㤥 ࠭ 
; ࠢ饩 㭪樨 XMM

XMM_Control  dd   ?

	  .CODE

; ம।  믮 ᮣ襭 
; ᯮ짮 ॣ஢  楤 

c_begin macro
			 push bp
			 mov  bp,sp
			 push si
			 push di
		  endm

c_end   macro
			 pop  di
			 pop  si
			 mov  sp,bp
			 pop  bp
			 ret
		  endm

;  楤   public

	public XMM_Installed
	public XMM_Version
	public XMM_RequestHMA
	public XMM_ReleaseHMA
	public XMM_GlobalEnableA20
	public XMM_GlobalDisableA20
	public XMM_EnableA20
	public XMM_DisableA20
	public XMM_QueryA20
	public XMM_QueryLargestFree
	public XMM_QueryTotalFree
	public XMM_AllocateExtended
	public XMM_FreeExtended
	public XMM_MoveExtended
	public XMM_LockExtended
	public XMM_UnLockExtended
	public XMM_GetHandleLength
	public XMM_GetHandleInfo
	public XMM_ReallocateExtended
	public XMM_RequestUMB
	public XMM_ReleaseUMB

;**
;.Name         XMM_Installed
;.Title        祭  ࠢ饩 㭪樨
;
;.Descr         㭪 ஢ 稥 ࠩ
;              HIMEM.SYS   砥  ⢨
;                ࠢ饩 㭪樨.
;
;.Proto        unsigned XMM_Installed(void);
;
;.Params        ᯮ
;
;.Return       0 - ࠩ HIMEM.SYS  ⠭;
;              1 - ࠩ HIMEM.SYS ⠭.
;
;.Sample       xms_test.c
;**

XMM_Installed proc near
			 c_begin

			 mov  ax, 4300h
          int  2fh
          cmp  al, 80h
			 jne  NotInstalled

			 mov  ax, 4310h
          int  2fh
          mov  word ptr [XMM_Control], bx
          mov  word ptr [XMM_Control+2], es
			 mov  ax,1
			 jmp  Installed

NotInstalled:
			 mov  ax, 0
Installed:
			 c_end
XMM_Installed endp

;**
;.Name         XMM_Version
;.Title        । ᨨ ࠩ HIMEM.SYS
;
;.Descr         㭪 ।  ࠩ
;              HIMEM.SYS
;
;.Proto        long  XMM_Version(void);
;
;.Params        ᯮ
;
;.Return        ᨨ   16 ,
;                -   16 
;              頥 祭
;
;.Sample       xms_test.c
;**

XMM_Version proc near
          push si
			 push di
			 xor  ah,ah
			 call [XMM_Control]
			 mov  dx, bx
          pop  di
          pop  si
          ret
XMM_Version endp

;**
;.Name         XMM_RequestHMA
;.Title          HMA
;
;.Descr         㭪 ⠥ १ࢨ஢ 
;              ணࠬ  HMA
;
;.Proto        long  XMM_RequestHMA(unsigned space);
;
;.Params       space - ࠧ ॡ㥬  
;                      TSR-ணࠬ  ࠩ,
;                      0xffff  ਪ ணࠬ;
;
;.Return       < 0 -  HMA  祭 ணࠬ,
;                     訡 室  襬 .
;              0L  -  HMA 祭 ணࠬ.
;
;.Sample       xms_test.c
;**

XMM_RequestHMA proc near
			 c_begin
			 mov  ah, 1
			 mov  dx, [bp+4]
          call [XMM_Control]
          xor  dx, dx
          dec  ax
			 jz   @success
          mov  dh, bl
@success:
			 c_end
XMM_RequestHMA endp


;**
;.Name         XMM_ReleaseHMA
;.Title        ᢮  HMA
;
;.Descr         㭪 ⠥ ᢮
;               HMA
;
;.Proto        long  XMM_ReleaseHMA(void);
;
;.Params        ᯮ
;
;.Return       < 0 -  HMA  ᢮,
;                     訡 室  襬 .
;              0L -  HMA ᢮.
;
;.Sample       xms_test.c
;**

XMM_ReleaseHMA proc near
			 c_begin
          mov  ah, 2
          call [XMM_Control]
          xor  dx, dx
          dec  ax
			 jz   @success1
          mov  dh, bl
@success1:
			 c_end
XMM_ReleaseHMA endp

;**
;.Name         XMM_GlobalEnableA20
;.Title        쭮 ࠧ襭  A20
;
;.Descr         㭪 ࠧ蠥 ணࠬ, 稢襩
;                 HMA ᯮ짮  A20
;
;.Proto        long  XMM_GlobalEnableA20(void);
;
;.Params        ᯮ
;
;.Return       < 0 -  A20  祭,
;                     訡 室  襬 .
;              0L  -  A20 祭.
;
;.Sample       xms_test.c
;**

XMM_GlobalEnableA20 proc near
			 c_begin
			 mov  ah, 3
          call [XMM_Control]
          xor  dx, dx
          dec  ax
			 jz   @success2
          mov  dh, bl
@success2:
			 c_end
XMM_GlobalEnableA20 endp

;**
;.Name         XMM_GlobalDisableA20
;.Title        쭮 饭  A20
;
;.Descr         㭪 頥 ணࠬ, 稢襩
;                 HMA ᯮ짮  A20
;
;.Proto        long  XMM_GlobalDisableA20(void);
;
;.Params        ᯮ
;
;.Return       < 0 -  A20  몫祭,
;                     訡 室  襬 .
;              0L  -  A20 몫祭.
;
;.Sample       xms_test.c
;**

XMM_GlobalDisableA20 proc near
			 c_begin
			 mov  ah, 4
          call [XMM_Control]
          xor  dx, dx
          dec  ax
			 jz   @success3
          mov  dh, bl
@success3:
			 c_end
XMM_GlobalDisableA20 endp

;**
;.Name         XMM_EnableA20
;.Title        쭮 ࠧ襭  A20
;
;.Descr         㭪 ࠧ蠥 ணࠬ ࠢ
;               ७ .
;
;.Proto        long  XMM_EnableA20(void);
;
;.Params        ᯮ
;
;.Return       < 0 -  A20  祭,
;                     訡 室  襬 .
;              0L  -  A20 祭.
;
;.Sample       xms_test.c
;**

XMM_EnableA20 proc near
			 c_begin
          mov  ah, 5
          call [XMM_Control]
          xor  dx, dx
          dec  ax
			 jz   @success4
          mov  dh, bl
@success4:
			 c_end
XMM_EnableA20 endp

;**
;.Name         XMM_DisableA20
;.Title        쭮 饭  A20
;
;.Descr         㭪 頥 ணࠬ ࠢ
;               ७ .
;
;.Proto        long  XMM_DisableA20(void);
;
;.Params        ᯮ
;
;.Return       < 0 -  A20  몫祭,
;                     訡 室  襬 .
;              0L  -  A20 몫祭.
;
;.Sample       xms_test.c
;**

XMM_DisableA20 proc near
			 c_begin
          mov  ah, 6
          call [XMM_Control]
          xor  dx, dx
          dec  ax
			 jz   @success5
          mov  dh, bl
@success5:
			 c_end
XMM_DisableA20 endp

;**
;.Name         XMM_QueryA20
;.Title        ஢ ﭨ  A20
;
;.Descr         㭪 ஢ 㯭
;               A20
;
;.Proto        long  XMM_QueryA20(void);
;
;.Params        ᯮ
;
;.Return       < 0 - 訡,
;                     訡 室  襬 .
;              0L  -  A20 몫祭,
;              1L  -  A20 祭.
;
;.Sample       xms_test.c
;**

XMM_QueryA20 proc near
			 c_begin
          mov  ah, 7
          call [XMM_Control]
          xor  dx, dx
          or   ax, ax
			 jnz  @success6
          mov  dh, bl
@success6:
			 c_end
XMM_QueryA20 endp

;**
;.Name         XMM_QueryLargestFree
;.Title        । ᨬ ࠧ 
;
;.Descr         㭪 頥 ࠧ ᨬ쭮
;              뢭  ७ ,
;               㯥 ணࠬ.
;
;.Proto        long  XMM_QueryLargestFree(void);
;
;.Params        ᯮ
;
;.Return       < 0 - 訡,
;                     訡 室  襬 .
;              >= 0 - ࠧ .
;
;.Sample       xms_test.c
;**

XMM_QueryLargestFree proc near
			 c_begin
          mov  ah, 8
          call [XMM_Control]
          xor  dx, dx
          or   ax, ax
			 jnz  @success7
          mov  dh, bl
@success7:
			 c_end
XMM_QueryLargestFree endp

;**
;.Name         XMM_QueryTotalFree
;.Title        । ࠧ ७ 
;
;.Descr         㭪 頥 ࠧ
;              ᥩ 饩 ७ .
;
;.Proto        long  XMM_QueryTotalFree(void);
;
;.Params        ᯮ
;
;.Return       < 0 - 訡,
;                     訡 室  襬 .
;              >= 0 - ࠧ ७ .
;
;.Sample       xms_test.c
;**

XMM_QueryTotalFree proc near
			 c_begin
			 mov  ah, 8
          call [XMM_Control]
          or   ax, ax
          mov  ax, dx
			 mov  dx, 0
			 jnz  @success8
          mov  dh, bl
@success8:
			 c_end
XMM_QueryTotalFree endp

;**
;.Name         XMM_AllocateExtended
;.Title          ७ 
;
;.Descr         㭪 뤥 ணࠬ 
;              ७ ,  砥 ᯥ
;              頥  祭 .
;
;.Proto        long XMM_AllocateExtended(unsigned space);
;
;.Params       space - ࠧ ॡ㥬  
;                       ;
;
;.Return       < 0 -   ।,
;                     訡 室  襬 .
;              > 0L  - 訩  ᮤন 
;                      祭  .
;
;.Sample       xms_test.c
;**


XMM_AllocateExtended proc near
			 c_begin
			 mov  ah, 9
			 mov  dx,  [bp+4]
          call [XMM_Control]
          or   ax, ax
          mov  ax, dx
			 mov  dx, 0
			 jnz  @success9
          mov  dh, bl
@success9:
			 c_end
XMM_AllocateExtended endp

;**
;.Name         XMM_FreeExtended
;.Title        ᢮  ७ 
;
;.Descr         㭪 ᢮ 
;              ७ , 祭 㭪樥
;              XMM_AllocateExtended().
;
;.Proto        long XMM_FreeExtended(unsigned handle);
;
;.Params       handle -  ᢮  ;
;
;.Return       < 0 -   ।,
;                     訡 室  襬 .
;              0L  -  ᢮.
;
;.Sample       xms_test.c
;**

XMM_FreeExtended proc near
			 c_begin
          mov  ah, 0Ah
			 mov  dx, [bp+4]
          call [XMM_Control]
          xor  dx, dx
          dec  ax
			 jz   @successA
          mov  dh, bl
@successA:
			 c_end
XMM_FreeExtended endp

;**
;.Name         XMM_MoveExtended
;.Title        ஢  ७ 
;
;.Descr         㭪  
;              ७ , ᯮ 
;              struct XMM_Move:
;
;                 struct   XMM_Move {
;                    unsigned long  Length;
;                    unsigned short SourceHandle;
;                    unsigned long  SourceOffset;
;                    unsigned short DestHandle;
;                    unsigned long  DestOffset;
;                 };
;
;.Proto        long  XMM_MoveExtended(struct
;                       XMM_Move *move_descr);
;
;.Params       struct XMM_Move *move_descr -
;                 㪠⥫  , 뢠
;                 , 㤠  㤠  ஢.
;
;.Return       < 0 - 訡  ஢,
;                     訡 室  襬 .
;              0L  -  ᪮஢ ᯥ譮.
;
;.Sample       xms_test.c
;**

XMM_MoveExtended proc near
			 c_begin
          mov  ah, 0Bh
			 mov  si, [bp+4];
          call [XMM_Control]
          xor  dx, dx
          dec  ax
			 jz   @successB
          mov  dh, bl
@successB:
			 c_end
XMM_MoveExtended endp

;**
;.Name         XMM_LockExtended
;.Title        ஢  ७ 
;
;.Descr         㭪   ७
;                頥 31 ࠧ 
;              䨧᪮ .
;
;.Proto        long XMM_LockExtended(unsigned handle);
;
;.Params       handle -  㥬  ;
;
;.Return       < 0 -   ஢,
;                     訡 室  襬 .
;              > 0L  -  ஢, 㭪
;                      頥 䨧᪨  
;                      .
;
;.Sample       xms_test.c
;**

XMM_LockExtended proc near
			 c_begin
          mov  ah, 0Ch
			 mov  dx, [bp+4]
          call [XMM_Control]
			 xchg ax, bx
			 dec  bx
          jz   XMML_Success
          mov  dh, al
XMML_Success:
			 c_end
XMM_LockExtended endp

;**
;.Name         XMM_UnLockExtended
;.Title        ஢  ७ 
;
;.Descr         㭪 ࠧ  ७
;              .
;
;.Proto        long XMM_UnLockExtended(unsigned handle);
;
;.Params       handle -   ;
;
;.Return       < 0 -   ࠧ஢,
;                     訡 室  襬 .
;              0L  -  ࠧ஢.
;
;.Sample       xms_test.c
;**

XMM_UnLockExtended proc near
			 c_begin
          mov  ah, 0Dh
			 mov  dx, [bp+4]
          call [XMM_Control]
          xor  dx, dx
          dec  ax
			 jz   @successC
          mov  dh, bl
@successC:
			 c_end
XMM_UnLockExtended endp

;**
;.Name         XMM_GetHandleLength
;.Title           ७ 
;
;.Descr         㭪 頥  
;              ७    .
;
;.Proto        long XMM_GetHandleLength(unsigned handle);
;
;.Params       handle -   ;
;
;.Return       < 0 - ந諠 訡,
;                     訡 室  襬 .
;              > 0L  -    .
;
;.Sample       xms_test.c
;**

XMM_GetHandleLength proc near
			 c_begin
          mov  ah, 0Eh
			 mov  dx, [bp+4]
          call [XMM_Control]
          or   ax, ax
          mov  ax, dx
			 mov  dx, 0
			 jnz  @successD
          mov  dh, bl
@successD:
			 c_end
XMM_GetHandleLength endp

;**
;.Name         XMM_GetHandleInfo
;.Title         ଠ   ७ 
;
;.Descr         㭪 頥 饥
;              ⢮ ᮢ  ⥬ 
;              ᮤন 稪 ஢ 
;               .
;
;.Proto        long XMM_GetHandleInfo(unsigned handle);
;
;.Params       handle -   ;
;
;.Return       < 0 - ந諠 訡,
;                     訡 室  襬 .
;              > 0L  - 訩  - 饥 ⢮
;                      ᮢ  ⥬;
;                      訩  - 稪 ஢.
;
;.Sample       xms_test.c
;**

XMM_GetHandleInfo proc near
			 c_begin
          mov  ah, 0Eh
			 mov  dx, [bp+4]
          call [XMM_Control]
          mov  dx, bx
          or   ax, ax
          mov  ax, dx
			 mov  dx, 0
			 jnz  @successE
          mov  dh, bl
@successE:
			 c_end
XMM_GetHandleInfo endp

;**
;.Name         XMM_ReallocateExtended
;.Title         ࠧ  ७ 
;
;.Descr         㭪  ࠧ 뤥
;               ७ .
;
;.Proto        long XMM_ReallocateExtended(unsigned handle,
;                 unsigned new_size);
;
;.Params       handle -   ;
;              new_size -  ࠧ  
;                       ;
;
;.Return       < 0 -   ।,
;                     訡 室  襬 .
;              > 0L  - 訩  ᮤন 
;                      祭  .
;
;.Sample       xms_test.c
;**

XMM_ReallocateExtended proc near
			 c_begin
          mov  ah, 0Fh
			 mov  dx, [bp+4]
			 mov  bx, [bp+6]
          call [XMM_Control]
          xor  dx, dx
          dec  ax
			 jz   @successF
          mov  dh, bl
@successF:
			 c_end
XMM_ReallocateExtended endp

;**
;.Name         XMM_RequestUMB
;.Title          UMB
;
;.Descr         㭪 ⠥ १ࢨ஢ 
;              ணࠬ  UMB
;
;.Proto        long  XMM_RequestUMB(unsigned space);
;
;.Params       space - ࠧ ॡ㥬 
;                       ࠣ;
;
;.Return       < 0 -  UMB  祭 ணࠬ,
;                     訡 室  襬 ;
;                    ᨬ ࠧ 㯭 
;                     襬 ᫮ (16 ࠧ冷);
;              > 0L  -  UMB 祭 ணࠬ,
;                    襥 ᫮ ᮤন ᥣ 
;                    UMB, 訩 - ࠧ 뤥
;                     UMB.
;
;.Sample       xms_test.c
;**

XMM_RequestUMB proc near
			 c_begin
          mov  ah, 10h
			 mov  dx, [bp+4]
          call [XMM_Control]
			 xchg bx, ax
			 dec  bx
          jz   RUMB_Success
			 xchg ax, dx
			 mov  dh, dl
RUMB_Success:
			 c_end
XMM_RequestUMB endp

;**
;.Name         XMM_ReleaseUMB
;.Title        ᢮  UMB
;
;.Descr         㭪 ⠥ ᢮
;               UMB
;
;.Proto        long  XMM_ReleaseUMB(unsigned segment);
;
;.Params       segment - ᥣ ᢮  UMB*
;
;.Return       < 0 -  UMB  ᢮,
;                     訡 室  襬 .
;              0L -  UMB ᢮.
;
;.Sample       xms_test.c
;**

XMM_ReleaseUMB proc near
			 c_begin
          mov  ah, 11h
			 mov  dx, [bp+4]
          call [XMM_Control]
          xor  dx, dx
          dec  ax
			 jz   @success10
          mov  dh, bl
@success10:
			 c_end
XMM_ReleaseUMB endp

			 END
