#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

void main(void) {

	extern int getcpu(void);
	unsigned cpu_type, ver;
	unsigned err;
	char ver_hi, ver_lo, verems;
	unsigned hostdata_seg, hostdata_size, dpmi_flags;
	void (far *pm_entry)();

	union REGS regs;
	struct SREGS segregs;


	printf("\n*MemoScop* v 1.0, (C) Frolov A.V., 1992\n"
		 "---------------------------------------\n");

// ।塞 ⨯ 業ࠫ쭮 . ᫨ ணࠬ
// ࠡ⠥   i8086, 蠥 믮,
// ⠪   ⮬ 砥 䥩  饭 ०
// 㯭.

	printf(" : 80%d\n", (cpu_type = getcpu()));
	if(cpu_type == 86) {
		printf("\n ⮬   ࠡ  ᭮...");
		exit(0);
	}

// ।塞 ࠧ 㯭 १ 뢠 INT 15h
// ७ .

	printf("\n------------------------ ஢ BIOS -------------------------\n");

	regs.h.ah = 0x88;
	int86(0x15, &regs, &regs);
	printf(" ७ , 㯭 १ INT 15:"
	" \t%d \n", regs.x.ax);

// ஢塞, ⠭  ࠩ HIMEM.SYS,
// ᫨ ⠭, 뢮  .

	printf("\n------------------------ ஢ XMM --------------------------\n");


	if (XMM_Installed()) {
		printf("⠭ ࠩ HIMEM.SYS");
		ver = XMM_Version();
		printf(", : %4X, : %4X\n",
			(short)ver, (short)(ver >> 16));
		printf(" ᢮ ७ , 㯭 १ XMM:"
					 " %ld \n", (long)XMM_QueryLargestFree());
		printf("騩 ࠧ ७ , 㯭 १ XMM:"
					 " \t  %ld \n", (long)XMM_QueryTotalFree());

	}
	else printf("\nࠩ HIMEM.SYS  ⠭.");


	printf("\n------------------------ ஢ EMS/VCPI ----------------------\n");

// ஢塞 稥 ࠩ EMS/VCPI

	if(ems_init()) printf("ࠩ EMS/VCPI  㦥\n");
	else {
		printf("ࠩ EMS/VCPI 㦥, ");

// 뢮  ᨨ ࠩ

		if((err = ems_ver(&verems)) != 0) {
			printf("\n訡 %02.2X  । ᨨ EMM", err);
			exit(-1);
		}
		printf(" EMM: %02.2X", verems);

// ।塞 ⢨ VCPI   

		if(vcpi_ver(&ver_hi, &ver_lo) != 0) {
			printf("\nࠩ EMM  ন VCPI\n");
		}
		else printf("\n VCPI: %02.2X.%02.2X\n", ver_hi, ver_lo);
	}


	printf("\n------------------------ ஢ DPMI --------------------------");


// ஢塞 㯭  ࠬ ࢥ DPMI

	regs.x.ax = 0x1687;
	int86x(0x2F, &regs, &regs, &segregs);
	if(regs.x.ax != 0) {
		printf("\nࢥ DPMI  ⨢"); exit(-1);
	}

// ।塞  ࢥ DPMI

	printf("\n ࢥ DPMI: \t\t\t%d.%d\n",
		regs.h.dh, regs.h.dl);

// ।塞 ⨯ 

	printf(" :\t\t\t\t");
	if(regs.h.cl == 2) printf("80286");
	else if(regs.h.cl == 3) printf("80386");
	else if(regs.h.cl == 4) printf("80486");

// ।塞  ࠡ  32-ࠧ來묨
// ணࠬ

	dpmi_flags = regs.x.bx;
	printf("\nপ 32-ࠧ來 ணࠬ:\t");
	if(dpmi_flags && 1) printf("");
	else printf("");

// ।塞 ࠧ    ࢥ DPMI

	hostdata_size = regs.x.si;
	printf("\n   ࢥ DPMI:\t\t%d ",
		hostdata_size * 16);

// ।塞  窨 室   ०

	FP_SEG(pm_entry) = segregs.es;
	FP_OFF(pm_entry) = regs.x.di;
	printf("\n 窨 室   ०: \t%Fp\n",
		pm_entry);

}

/**
*.Name         ems_init
*.Title        㭪 ஢ ⠭ ࠩ EMS
*
*.Descr         㭪 ஢ 稥 ࠩ EMS
*
*.Proto        int ems_init(void);
*
*.Params        ᯮ
*
*.Return       0 - ࠩ EMS ⠭;
*              1 - ࠩ EMS  ⠭.
*
*.Sample       ems_test.c
**/

int ems_init(void) {

	void (_interrupt _far *EMS_driver_adr)(void);
	char _far *EMS_driver_name;
	char test_name[8];
	int i;

	EMS_driver_adr = _dos_getvect(0x67);

	FP_SEG(EMS_driver_name) = FP_SEG (EMS_driver_adr);
	FP_OFF(EMS_driver_name) = 10;

	for(i=0; i<8; i++) test_name[i] = EMS_driver_name[i];

	if(strncmp(test_name, "EMMXXXX0", 8) == 0) return(0);
	else return(1);

}

/**
*.Name         ems_ver
*.Title        । ᨨ ࠩ EMS
*
*.Descr         㭪 頥  ᨨ
*              ࠩ EMS  筮-筮 ଠ.
*
*.Proto        int ems_ver(char *ver);
*
*.Params       char *ver - 㪠⥫  ,  
*                 㤥 ᠭ  ᨨ.
*
*.Return        ᨨ ࠩ EMS  ଠ BCD
*
*.Sample       ems_test.c
**/

int ems_ver(char *ver) {

	union REGS reg;

	reg.x.ax = 0x4600;
	int86(0x67, &reg, &reg);

	*ver = reg.h.al;
	return(reg.h.ah);
}

int vcpi_ver(char *ver_hi, char *ver_lo) {

	union REGS reg;

	reg.x.ax = 0xDE00;
	int86(0x67, &reg, &reg);

	*ver_hi = reg.h.bh;
	*ver_lo = reg.h.bl;
	return(reg.h.ah);
}
