#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include "tos.h"

void vi_putch(unsigned int x, unsigned int y ,char c, char attr);

char hex_tabl[] = "0123456789ABCDEF";

// 뢮   ࠭, न (x,y),
// 뢮 ⭠筮 ।⠢
//  chr  ࠭묨 ਡ⠬ attr.

void vi_put_byte(unsigned int x,
		unsigned int y, unsigned char chr, char attr) {
	unsigned char temp;

	temp = hex_tabl[(chr & 0xf0) >> 4];
	vi_putch(x, y, temp, attr);

	temp = hex_tabl[chr & 0xf];
	vi_putch(x+1, y, temp, attr);
}
// 뢮 ᫮  ࠭, न (x,y),
// 뢮 ⭠筮 ।⠢
// ᫮ chr  ࠭묨 ਡ⠬ attr.

void vi_put_word(unsigned int x,
	unsigned int y, word chr, char attr) {

	vi_put_byte(x, y, (chr & 0xff00) >> 8, attr);
	vi_put_byte(x+2, y, chr & 0xff, attr);

}

// 뢮 ᨬ c  ࠭, न - (x,y),
// ਡ 뢮 ᨬ - attr

void vi_putch(unsigned int x,
	unsigned int y ,char c, char attr) {

	register unsigned int offset;
	char far *vid_ptr;

	offset=(y*160) + (x*2);
	vid_ptr=MK_FP(VID_MEM_SELECTOR, offset);
	*vid_ptr++=c; *vid_ptr=attr;
}

// 뢮 ப s  ࠭, न - (x,y),
// ਡ 뢮 ப - attr

void vi_print(unsigned int x,
	unsigned int y, char *s, char attr) {
	while(*s) vi_putch(x++, y, *s++, attr);
}

// 뢮 ⮪ ᮮ饭  ᪥ ணࠬ

void vi_hello_msg(void) {

	vi_print(0, 0,
		" Protected mode monitor *TINY/OS*, "
		"v.1.2 for CPU 80286   (C) Frolov A.V., 1992 ", 0x30);

}
