#include <stdio.h>
#include <dos.h>

void main(void) {

	unsigned err;
	char ver, ver_hi, ver_lo;

	clrscr();
	printf("Virtual Control Program Interface Demo, (C) Frolov A.V., 1992\n\r"
			 "-------------------------------------------------------------\n\r\n\r");

// ஢塞 稥 ࠩ EMS/VCPI

	if(ems_init()) {
		printf("ࠩ EMS/VCPI  㦥.");
		exit(-1);
	}
	printf("ࠩ EMS/VCPI 㦥");

// 뢮  ᨨ ࠩ

	if((err = ems_ver(&ver)) != 0) {
		printf("\n訡 %02.2X  । ᨨ EMM", err);
		exit(-1);
	}
	printf("\n EMM: %02.2X", ver);

// ।塞 ⢨ VCPI   

	if(vcpi_ver(&ver_hi, &ver_lo) != 0) {
		printf("\nࠩ EMM  ন VCPI\n");
		exit(-1);
	}
	printf("\n VCPI: %02.2X.%02.2X", ver_hi, ver_lo);



}


/**
*.Name         ems_init
*.Title        㭪 ஢ ⠭ ࠩ EMS
*
*.Descr         㭪 ஢ 稥 ࠩ EMS
*
*.Proto        int ems_init(void);
*
*.Params        ᯮ
*
*.Return       0 - ࠩ EMS ⠭;
*              1 - ࠩ EMS  ⠭.
*
*.Sample       ems_test.c
**/

int ems_init(void) {

	void (_interrupt _far *EMS_driver_adr)(void);
	char _far *EMS_driver_name;
	char test_name[8];
	int i;

	EMS_driver_adr = _dos_getvect(0x67);

	FP_SEG(EMS_driver_name) = FP_SEG (EMS_driver_adr);
	FP_OFF(EMS_driver_name) = 10;

	for(i=0; i<8; i++) test_name[i] = EMS_driver_name[i];

	if(strncmp(test_name, "EMMXXXX0", 8) == 0) return(0);
	else return(1);

}

/**
*.Name         ems_ver
*.Title        । ᨨ ࠩ EMS
*
*.Descr         㭪 頥  ᨨ
*              ࠩ EMS  筮-筮 ଠ.
*
*.Proto        int ems_ver(char *ver);
*
*.Params       char *ver - 㪠⥫  ,  
*                 㤥 ᠭ  ᨨ.
*
*.Return        ᨨ ࠩ EMS  ଠ BCD
*
*.Sample       ems_test.c
**/

int ems_ver(char *ver) {

	union REGS reg;

	reg.x.ax = 0x4600;
	int86(0x67, &reg, &reg);

	*ver = reg.h.al;
	return(reg.h.ah);
}

int vcpi_ver(char *ver_hi, char *ver_lo) {

	union REGS reg;

	reg.x.ax = 0xDE00;
	int86(0x67, &reg, &reg);

	*ver_hi = reg.h.bh;
	*ver_lo = reg.h.bl;
	return(reg.h.ah);
}
