	IDEAL
	MODEL SMALL
	RADIX	16
	P286

	DATASEG

	include "tos.inc"

	PUBLIC	_beep

;    樠樨 IDTR

	idtr			idtr_struc <,,,0>

;    樠樨 GDTR

	gdt_ptr		dw  (8*15)-1  ; ࠧ GDT, 15 ⮢
	gdt_ptr2		dw  ?
	gdt_ptr4		dw  ?

;     ᥫ ,
;   㤥 ந室 ४祭

	new_task		dw  00h
	new_select  dw  00h

;    ࠭ ॣ஢,
; ᯮ    ॠ ०

	real_ss		dw	?
	real_sp		dw	?
	real_es		dw	?

	protect_sel	dw	?

	init_tss		dw	?

CODESEG

	PUBLIC  _real_mode,_protected_mode,_jump_to_task
	PUBLIC  _load_task_register, _load_idtr, _enable_interrupt

; -------------------------------------------------------------------
; 楤  ४祭   ०.
; ⨯  맮:
;  void protected_mode(unsigned long gdt_ptr, unsigned int gdt_size,
;		 unsigned int cseg, unsigned int dseg)
; -------------------------------------------------------------------

PROC _protected_mode NEAR
		push    bp
		mov     bp,sp

; ࠬ gdt_ptr

		mov     ax,[bp+4] 		; . ᫮  GDT
		mov     dx,[bp+6]			; . ᫮  GDT

		mov     [gdt_ptr4], dx	;   GDT
		mov     [gdt_ptr2], ax

; ࠬ gdt_size

		mov     ax,[bp+8]			; 砥 ࠧ GDT
		mov     [gdt_ptr], ax	;   

; ࠬ cseg  dseg

		mov     ax,[bp+10d]		; 砥 ᥫ ᥣ 
		mov     dx,[bp+12d]		; 砥 ᥫ ᥣ 
		mov     [cs:p_mode_select], ax	;   
		mov	  [protect_sel], dx        ; 室 far jmp

; ⮢    ॠ ०

		push		ds					; ⮢  
		mov		ax,40h			;  񭭮 ०
		mov		ds,ax
		mov		[WORD 67h],OFFSET shutdown_return
		mov		[WORD 69h],cs
		pop		ds

; 頥  ᪨㥬  뢠

		cli
		in			al, INT_MASK_PORT
		and		al, 0ffh
		out		INT_MASK_PORT, al

; 뢠    CMOS-

		mov		al,8f
		out		CMOS_PORT,al
		jmp		delay1
delay1:
		mov		al,5
		out		CMOS_PORT+1,al

		call	enable_a20		; 뢠  A20

		mov		[real_ss],ss	;  ॣ SS  ES
		mov		[real_es],es

; ९ணࠬ㥬 ஫ 뢠
;  ࠡ  񭭮 ०

		mov		dx,MASTER8259A
		mov		ah,20
		call		set_int_ctrlr
		mov		dx,SLAVE8259A
		mov		ah,28
		call		set_int_ctrlr

; 㦠 ॣ IDTR  GDTR

		lidt		[FWORD idtr]
		lgdt    	[QWORD gdt_ptr]

		mov		ax, 0001h	; ४砥 
		lmsw		ax				;   ०

;		jmp	far flush
					db	0eah
					dw	OFFSET flush
p_mode_select 	dw	?

LABEL	flush	FAR

		mov  		dx, [protect_sel]
		mov     	ss, dx
		mov     	ds, dx
		mov     	es, dx

; 塞 ᮤন ॣ LDTR

		mov		ax, 0
		lldt		ax

		pop     bp
		ret
ENDP _protected_mode

; ----------------------------------------------------
;   ॠ ०.
; ⨯  맮
;   void real_mode();
; ----------------------------------------------------

PROC _real_mode   NEAR

;  

		cli
		mov		[real_sp], sp
		mov		al, SHUT_DOWN
		out		STATUS_PORT, al

rmode_wait:
		hlt
		jmp		rmode_wait

LABEL	shutdown_return FAR

; 㫨  ॠ ०

		mov		ax, DGROUP
		mov		ds, ax

assume	ds:DGROUP

		mov	ss,[real_ss]
		mov	sp,[real_sp]

		in	al, INT_MASK_PORT
		and	al, 0
		out	INT_MASK_PORT, al

		call	disable_a20

		mov	ax, DGROUP
		mov	ds, ax
		mov	ss, ax
		mov 	es, ax

		mov	ax,000dh
		out	CMOS_PORT,al
		sti

		ret
ENDP _real_mode

; -------------------------------------------------------
; 㧪 ॣ TR.
; ⨯  맮:
;   void load_task_register(unsigned int tss_selector);
; -------------------------------------------------------

PROC _load_task_register  NEAR
		push    bp
		mov     bp,sp
		ltr	  [bp+4] ; ᥫ  ⥪饩 
		pop     bp
		ret
ENDP _load_task_register

; -------------------------------------------------------
; ४祭  .
; ⨯  맮:
;   void jump_to_task(unsigned int tss_selector);
; -------------------------------------------------------

PROC _jump_to_task   NEAR
		push    bp
		mov     bp,sp
		mov     ax,[bp+4]          ; 砥 ᥫ
											;  
		mov     [new_select],ax    ;  

		jmp     [DWORD new_task]   ; ४砥 
											;  
		pop     bp
		ret
ENDP _jump_to_task

; ------------------------------
; 뢠  A20
; ------------------------------

PROC	enable_a20	NEAR
	push	ax
	mov	al, A20_PORT
	out	STATUS_PORT, al
	mov	al, A20_ON
	out	KBD_PORT_A, al
	pop	ax
	ret
ENDP	enable_a20

; ------------------------------
; 뢠  A20
; ------------------------------

PROC	disable_a20	NEAR
	push	ax
	mov	al, A20_PORT
	out	STATUS_PORT, al
	mov	al ,A20_OFF
	out	KBD_PORT_A, al
	pop	ax
	ret
ENDP	disable_a20

; -----------------------------------------------------------
; ⮢   㧪 ॣ IDTR
; ⨯  맮 㭪樨:
; void load_idtr(unsigned long idt_ptr, word idt_size);
; -----------------------------------------------------------

PROC _load_idtr NEAR
		push    bp

		mov     bp,sp
		mov     ax,[bp+4] ; . ᫮  IDT
		mov     dx,[bp+6] ; . ᫮  IDT
		mov	  bx, OFFSET idtr

;   IDTR  

		mov     [(idtr_struc bx).idt_low], ax
		mov     [(idtr_struc bx).idt_hi], dl

; 砥 । IDT     

		mov		ax, [bp+8]
		mov     [(idtr_struc bx).idt_len], ax

		pop     bp
		ret
ENDP _load_idtr

; ----------------------------------
; ⠭ ஫ 뢠
; ----------------------------------

PROC	set_int_ctrlr	NEAR

	mov	al, 11
	out	dx, al
	jmp	SHORT $+2
	mov	al, ah
	inc	dx
	out	dx, al
	jmp	SHORT $+2
	mov	al, 4
	out	dx, al
	jmp	SHORT $+2
	mov	al, 1
	out	dx, al
	jmp	SHORT $+2
	mov	al, 0ffh
	out	dx, al
	dec	dx
	ret
ENDP	set_int_ctrlr

; --------------------------
; 뤠 㪮 ᨣ
; --------------------------

PROC	_beep	NEAR

	push	ax bx cx

	in	al,KBD_PORT_B
	push	ax
	mov	cx,80

beep0:

	push	cx
	and	al,11111100b
	out	KBD_PORT_B,al
	mov	cx,60

idle1:

	loop	idle1
	or	al,00000010b
	out	KBD_PORT_B,al
	mov	cx,60

idle2:

	loop	idle2
	pop	cx
	loop	beep0

	pop	ax
	out	KBD_PORT_B,al

	pop	cx bx ax
	ret

ENDP	_beep

; -------------------------------
; প 믮 ணࠬ
; -------------------------------

PROC	_pause		NEAR

	push	cx
	mov	cx,10

ploop0:

	push	cx
	xor	cx,cx

ploop1:

	loop	ploop1
	pop	cx
	loop	ploop0

	pop	cx
	ret

ENDP	_pause

; -----------------------
; ᪨஢ 뢠
; -----------------------

PROC	_enable_interrupt NEAR

		in			al, INT_MASK_PORT
		and		al, 0fch
		out		INT_MASK_PORT, al

		sti
		ret
ENDP	_enable_interrupt

	end