#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <stdarg.h>

typedef struct {
	 unsigned long edi, esi, ebp, reserved, ebx, edx, ecx, eax;
	 unsigned flags, es, ds, fs, gs, ip, cs, sp, ss;
} RM_INT_CALL;

#define MONO_MODE           0x07
#define BW_80_MODE          0x02
#define COLOR_80_MODE       0x03

//   ᫥   室 
// ᪮  ॠ쭮 ०

#define ABSADDR(seg, ofs) \
	 ((((unsigned long) seg) << 4) + ((ofs) & 0xFFFF))

typedef struct {						//  㯠
	 unsigned accessed   : 1;
	 unsigned read_write : 1;
	 unsigned conf_exp   : 1;
	 unsigned code       : 1;
	 unsigned xsystem    : 1;
	 unsigned dpl        : 2;
	 unsigned present    : 1;
} ACCESS;

typedef struct {                 // ਯ
	 unsigned        limit;
	 unsigned        addr_lo;
	 unsigned char   addr_hi;
	 ACCESS          access;
	 unsigned        reserved;
} DESCRIPTOR;

//    ଠ樨  

typedef struct {
	unsigned long avail_block;
	unsigned long max_page;
	unsigned long max_locked;
	unsigned long linadr_space;
	unsigned long total_unlocked;
	unsigned long free_pages;
	unsigned long tot_phys_pages;
	unsigned long free_linspace;
	unsigned long size_fp;
	char reserved[12];
} PMI;


void dos_exit(unsigned);
void dpmi_init(void);
void set_pmode(void);
void cdecl pm_printf(const char *, ...);
void pm_puts(char *);
void pm_putch(int);
int  rm_int(unsigned, unsigned , RM_INT_CALL far *);
int  mi_show(void);
unsigned get_sel(void);
int set_descriptor(unsigned pm_sel, DESCRIPTOR far *desc);
void vi_print(unsigned int x, unsigned int y, char *s, char attr);
void vi_hello_msg(void);



void main() {

	clrscr();
	printf("DOS Protected Mode Interface Demo, (C) Frolov A.V., 1992\n\r"
			 "--------------------------------------------------------\n\r\n\r");

// ।塞 ⥪騩 ० 
// ᥣ  

	video_init();

// 樠㥬  ०

	dpmi_init();

	printf("\n\r\n\r\n\r 室   ०   ...");
	getch();

// 室   ०

	set_pmode();

// ࠥ ࠭  뢮 ᮮ饭, 室 
// 񭭮 ०. 㥬 뢮 १
// 㫨㥬 뢠 ॠ쭮 ० DOS

	textcolor(BLACK);	textbackground(LIGHTGRAY);	clrscr();
	pm_printf(" ⠭  ० ࠡ !\n\r"
			  " ----------------------------------------------\n\r\n\r");

// 뢮 ⥪ ଠ  । 

	mi_show();

	pm_printf("\n\r\n\r\n\r  த   ...");
	getch();

	clrscr();

// 砥 ᥫ  ।⢥ 㯠  

	alloc_videosel();

	pm_printf("\n\r\n\r\n\r  த   ...");
	getch();
	clrscr();

// 뢮 ᮮ饭,  ।⢥ 㯮
//  

	vi_hello_msg();
	vi_print(0, 3,
		"    ॠ ०   ", 0x7f);
	getch();

// ᢮ 祭 ᥫ

	free_videosel();

	textcolor(LIGHTGRAY);	textbackground(BLACK);	clrscr();

// 蠥 ࠡ ணࠬ 室  DOS

	dos_exit(0);
}

// -------------------------------------------------
// 楤  襭 ࠡ ணࠬ
// -------------------------------------------------

void dos_exit(unsigned err) {
	 asm mov ax, err
	 asm mov ah, 04ch
	 asm int 21h
}

// -------------------------------------------------
// 樠  ࠡ  DPMI
// -------------------------------------------------

	union REGS inregs, outregs;
	struct SREGS segregs;
	void (far *pm_entry)();
	unsigned hostdata_seg, hostdata_size, dpmi_flags;

void dpmi_init(void) {

// ஢塞 㯭  ࠬ ࢥ DPMI

	inregs.x.ax = 0x1687;
	int86x(0x2F, &inregs, &outregs, &segregs);
	if(outregs.x.ax != 0) {
		printf("ࢥ DPMI  ⨢."); exit(-1);
	}

// ।塞  ࢥ DPMI

	printf(" ࢥ DPMI: \t\t\t%d.%d\n",
		outregs.h.dh, outregs.h.dl);

// ।塞 ⨯ 

	printf(" :\t\t\t\t");
	if(outregs.h.cl == 2) printf("80286");
	else if(outregs.h.cl == 3) printf("80386");
	else if(outregs.h.cl == 4) printf("80486");

// ।塞  ࠡ  32-ࠧ來묨
// ணࠬ

	dpmi_flags = outregs.x.bx;
	printf("\nপ 32-ࠧ來 ணࠬ:\t");
	if(dpmi_flags && 1) printf("");
	else printf("");

// ।塞 ࠧ    ࢥ DPMI

	hostdata_size = outregs.x.si;
	printf("\n   ࢥ DPMI:\t\t%d ",
		hostdata_size * 16);

// ।塞  窨 室   ०

	FP_SEG(pm_entry) = segregs.es;
	FP_OFF(pm_entry) = outregs.x.di;
	printf("\n 窨 室   ०: \t%Fp\n",
		pm_entry);

// 뢠   ࢥ DPMI

	if(hostdata_size) {
		if(_dos_allocmem(hostdata_size, &hostdata_seg) != 0) {
			printf(" ⠭⭮ "); exit(-1);
		}
	}

}

// ------------------------------------------------
// 楤  ⠭ 񭭮 ०
// ------------------------------------------------

void set_pmode() {

// 室   ०

	 asm {
		  mov ax, hostdata_seg
		  mov es, ax
		  mov ax, dpmi_flags
	 }
	 (*pm_entry)();

}

// -------------------------------------------
// 楤 뢮 ᨬ  ࠭ 
// 񭭮 ०
// -------------------------------------------

void pm_putch(int chr) {

//   맮 뢠 
//  ।  ᪠

	 static RM_INT_CALL regs;
	 static RM_INT_CALL far *pregs = (void far *) 0;

//   ࠧ 樠㥬 
//  㪠⥫  

	 if (!pregs) {
		  pregs = &regs;
		  memset(pregs, 0, sizeof(RM_INT_CALL));
		  regs.eax = 0x0200;
	 }
	 regs.edx = chr;

// 뢠 뢠 DOS  뢮 ᨬ

	 rm_int(0x21, 0, pregs);
}

// -------------------------------------------
// 楤 뢮 ப  ࠭ 
// 񭭮 ०
// -------------------------------------------

void pm_puts(char *str_ptr) {
	 while (*str_ptr) { pm_putch(*str_ptr); str_ptr++; }
}

// -------------------------------------------
// 楤 뢮 ப  ࠭ 
// 񭭮 ०,  㭪樨 printf()
// -------------------------------------------

void cdecl pm_printf(const char *fmt, ...)
{
	 char buffer[512], *sptr=buffer;
	 va_list marker;
	 va_start(marker, fmt);
	 vsprintf(buffer, fmt, marker);
	 va_end(marker);
	 while (*sptr) pm_putch(*sptr++);
}

// --------------------------------------------
// 楤 맮 뢠 ॠ쭮 ०
// --------------------------------------------

int rm_int(unsigned int_number,	//  뢠
			  unsigned params,		// ⢮ ᫮ ࠬ஢,
											// । १ ⥪
			  RM_INT_CALL far *rm_call) //  
											//  맮 뢠
{
	 asm {
		  push di
		  push bx
		  push cx
		  mov ax, 0300h      // 㭪 맮 뢠
		  mov bx, int_number
		  mov cx, params;
		  les di, rm_call  	//   ES:DI  
		  int 31h            // 맮 ࢥ DPMI
		  jc error
		  mov ax, 0				// ଠ쭮 襭
		  jmp short rm_int_end
	 }
error:  asm mov ax, 0       // 襭  訡
rm_int_end:   asm pop cx
		  asm pop bx
		  asm pop di
}

// -----------------------------------------------------
// 楤 ⮡ࠦ ⥪饥 ﭨ 
// -----------------------------------------------------

int mi_show(void) {

	 PMI minfo, far *minfoptr = &minfo;
	 unsigned long psize, far *psizeptr=&psize;
	 unsigned sel;
	 void far *fp;


	 get_mi(minfoptr);

	 pm_printf(" ଠ  ᯮ짮 \n\r"
				  " ----------------------------------\n\r"
	 "\r\n  ᨬ쭮 㯭 :\t\t%ld "
	 "\r\n 㯭 䨪஢ ࠭:\t\t%ld",
	 minfo.avail_block,
	 minfo.max_page);

	 pm_printf("\r\n 㯭 䨪஢ ࠭:\t\t%ld"
	 "\r\n   ᭮ ࠭⢠:\t%ld ࠭"
	 "\r\n ᥣ  䨪஢ ࠭:\t%ld",
	 minfo.max_locked,
	 minfo.linadr_space,
	 minfo.total_unlocked);

	 pm_printf("\r\n ⢮ ᢮ ࠭:\t\t\t%ld"
	 "\r\n 饥 ⢮ 䨧᪨ ࠭:\t\t%ld",
	 minfo.free_pages,
	 minfo.tot_phys_pages);

	 pm_printf("\r\n   ᭮ ࠭⢮:\t%ld ࠭"
	 "\r\n  䠩/ࠧ  ࠭筮 :\t%ld ࠭",
	 minfo.free_linspace,
	 minfo.size_fp);

	 get_page_size(psizeptr);
	 pm_printf("\r\n  ࠭:\t\t\t\t%ld \r\n", psize);

// 뢮 ⥪騥 祭 ॣ஢ CS  DS

	 asm mov sel,cs
	 pm_printf("\n\r CS = %04.4X,   ",sel);
	 asm mov sel,ds
	 pm_printf("DS = %04.4X",sel);

// 뢮 祭 ⥪饣 ਮ⭮ 

	 fp = (void far *) main;
	 sel = FP_SEG(fp) & 3;
	 pm_printf("\n\r  ਮ⭮  = %d\n\r",sel);

}

// -----------------------------------------------
// 楤  祭 ଠ樨 
// ᯮ짮 
// -----------------------------------------------

int get_mi(PMI far *minfo) {
	asm {
		  mov ax, 0500h
		  les di, minfo       // ES:DI =   DMI
		  int 31h
		  jc error
		  mov ax, 0
		  jmp short get_mi_end
	}
	error: asm mov ax, 1
	get_mi_end:
}

// ------------------------------------------------
// 楤  祭 ࠧ ࠭ 
// ------------------------------------------------

int get_page_size(long far *page_size) {
	asm {
		  mov ax, 0604h
		  int 31h
		  jc error

		  les di, page_size // ES:DI =  page_size
		  mov es:[di], cx
		  mov es:[di+2], bx

		  mov ax, 0
		  jmp short gps_end
	}
	error: asm mov ax, 1
	gps_end:
}

// --------------------------------------------------
// । ᥣ⭮  
// --------------------------------------------------

unsigned crt_mode, crt_seg;

int video_init(void) {

	union REGS r;

// ।塞 ⥪騩 ०

	r.h.ah=15;
	int86(0x10,&r,&r);
	crt_mode = r.h.al;

	if(crt_mode == MONO_MODE) crt_seg = 0xb000;
	else if(crt_mode == BW_80_MODE || crt_mode == COLOR_80_MODE)
		crt_seg = 0xb800;
	else {
		printf("\n,  ० ⨬.");
		exit(-1);
	}
}

// ---------------------------------------------------
// 祭 ᥫ  樨 
// ---------------------------------------------------

char far *vid_ptr;
DESCRIPTOR d;
unsigned ldtsel;

int alloc_videosel(void) {

	void far *fp;
	unsigned long addr;

	FP_SEG(vid_ptr) = crt_seg;
	FP_OFF(vid_ptr) = 0;
	pm_printf("   ॠ쭮 ०:\t %Fp\r\n", vid_ptr);

// 砥 ᢮ LDT-ᥫ

	if (! (ldtsel = get_sel())) {
	  pm_printf(" 訡  祭 ᥫ");
	  dos_exit(-1);
	}
	pm_printf(" 祭 ᥫ:\t\t\t%04.4X\n\r", ldtsel);

// ⠢ ਯ  祭 ᥫ

	d.limit = 0x2000;
	addr = ABSADDR(crt_seg, 0);
	d.addr_lo = addr & 0xFFFF;
	d.addr_hi = addr >> 16;
	d.access.accessed = 0;      //  ᯮ짮
	d.access.read_write = 1;    // ࠧ襭 ⥭/
	d.access.conf_exp = 0;      //  ⥪
	d.access.code = 0;          //  ᥣ 
	d.access.xsystem = 1;       //  ⥬ ਯ
	d.access.dpl = 3;  			 // ਮ⭮  3
	d.access.present = 1;       // ᥣ   
	d.reserved = 0;

// ⠭ ਯ

	if (!set_descriptor(ldtsel, &d)) {
			pm_printf(" 訡  ⠭ ਯ"); getch();
			dos_exit(-1);
	 }

// 뢮  ࠭  

	 FP_SEG(vid_ptr) = ldtsel;
	 FP_OFF(vid_ptr) = 0;
	 pm_printf("   񭭮 ०:\t%Fp\r\n", vid_ptr);
}

// --------------------------------------------------
// ᢮ ᥫ 
// --------------------------------------------------

int free_videosel(void) {
	 if (!sel_free(ldtsel)) {
			pm_printf(" 訡  ᢮ ᥫ");
			dos_exit(-1);
	 }
}

// ----------------------------------------------
//   ᥫ  LDT
// ----------------------------------------------

unsigned get_sel(void) {
	 asm {
		  mov ax, 0        //  ᥫ
		  mov cx, 1        // 㦥  ᥫ
		  int 31h
		  jc error
		  jmp short gs_end // AX ᮤন  LDT-ᥫ
	 }
error: asm mov ax, 0     // ந諠 訡
gs_end:
}

// --------------------------------------------------
// ⠭ ਯ  LDT-ᥫ
// --------------------------------------------------

int set_descriptor(unsigned pm_sel, DESCRIPTOR far *desc) {

	 asm {
		  push di
		  push bx
		  mov ax, 000Ch
		  mov bx, pm_sel
		  les di, desc  
		  int 31h       
		  jc error
		  mov ax, 1     
		  jmp short sd_end
	  }
error:  asm mov ax, 0      
sd_end: asm pop bx
		  asm pop di
}

// --------------------------------------------------
// ᢮ LDT-ᥫ
// --------------------------------------------------

int sel_free(unsigned pmodesel) {
	 asm {
		  mov ax, 0001h   
		  mov bx, pmodesel
		  int 31h         
		  jc error
		  mov ax, 1       
		  jmp short done
	  }
error: asm mov ax, 0         
done:
}

// -------------------------------------------------------
// 뢮 ᨬ ।⢥   
// -------------------------------------------------------

void vi_putch(unsigned int x, unsigned int y ,char c, char attr) {

	register unsigned int offset;
	char far *vid_ptr;

	offset=(y*160) + (x*2);
	vid_ptr=MK_FP(ldtsel, offset);
	*vid_ptr++=c; *vid_ptr=attr;
}
// -------------------------------------------------------
// 뢮 ப ।⢥   
// -------------------------------------------------------

void vi_print(unsigned int x, unsigned int y, char *s, char attr) {
	while(*s) vi_putch(x++, y, *s++, attr);
}
// -------------------------------------------------------
// 뢮 ᮮ饭 ।⢥   
// -------------------------------------------------------

void vi_hello_msg(void) {

	vi_print(0, 0,
		"  ࠡ  䥩ᮬ "
		"DPMI                  (C) Frolov A.V., 1992 ", 0x30);

}
