#define word unsigned int

// , ।  GDT

#define GDT_SELECTOR        0x08 // 1 - ᥫ  GDT
#define IDT_SELECTOR        0x10 // 2 - ᥫ  IDT
#define DATA_SELECTOR       0x18 // 3 - ᥫ  DS

#define VID_MEM_SELECTOR    0x20 // 4 - ᥫ  ES,
			//     㤥 ᯮ짮  樨 

#define SS_SELECTOR         0x28 // 5 - ᥫ  SS
#define CODE_SELECTOR       0x30 // 6 - ᥫ  CS
#define BIOS_SELECTOR		 0x38 // 7 - ᥫ  樨
											//   BIOS

#define COLOR_VID_MEM       0xb8000L
#define MONO_VID_MEM        0xb0000L
#define MONO_MODE           0x07
#define BW_80_MODE          0x02
#define COLOR_80_MODE       0x03

typedef struct descriptor {
	word limit;
	word base_lo;
	unsigned char base_hi;
	unsigned char type_dpl;
	unsigned reserved;
} descriptor;

typedef struct gate {
	word offset;
	word selector;
	unsigned char count;
	unsigned char type_dpl;
	word reserved;
} gate;

#define DESCRIPTOR_SIZE     (sizeof(descriptor))
#define GATE_SIZE           (sizeof(gate))
#define IDT_SIZE            (sizeof(idt))

#define TYPE_CODE_DESCR     0x18
#define TYPE_DATA_DESCR     0x10
#define TYPE_INTERRUPT_GATE 0x86
#define TYPE_TRAP_GATE      0x87
#define SEG_WRITABLE        0x02
#define SEG_READABLE        0x02
#define SEG_EXPAND_DOWN     0x04
#define SEG_ACCESSED        0x01
#define SEG_PRESENT_BIT     0x80

#define EOI 			0x20
#define MASTER8259A 	0x20
#define SLAVE8259A 	0xA0

#define MK_LIN_ADDR(seg,off) (((unsigned long)(seg))<<4)+(word)(off)