IDEAL
RADIX	16
P286

; ᯮ㥬   LARGE,  ⮬  ࣠㥬
; ᪮쪮 ⤥ ᥣ⮢    ᥣ
; ᮧ ਯ  ⠡ GDT.

MODEL	LARGE

; ------------------------------------------------------------
; ।    ⠭
; ------------------------------------------------------------

STRUC	desc_struc		;  ਯ
	limit	dw	0	; ।
	base_l	dw	0	; . ᫮ 䨧᪮ 
	base_h	db	0	; .  䨧᪮ 
	access	db	0	;  㯠
	rsrv	dw	0	; १ࢨ஢
ENDS	desc_struc

;   㯠

ACC_PRESENT	EQU	10000000b ; ᥣ   
ACC_CSEG	EQU	00011000b ; ᥣ 
ACC_DSEG	EQU	00010000b ; ᥣ 
ACC_EXPDOWN	EQU	00000100b ; ᥣ  
ACC_CONFORM	EQU	00000100b ; ᮣᮢ ᥣ
ACC_DATAWR	EQU	00000010b ; ࠧ襭 

;  ᥣ⮢

; ᥣ 
DATA_ACC = ACC_PRESENT OR ACC_DSEG OR ACC_DATAWR

; ᥣ 
CODE_ACC = ACC_PRESENT OR ACC_CSEG OR ACC_CONFORM

; ᥣ ⥪
STACK_ACC = ACC_PRESENT OR ACC_DSEG OR ACC_DATAWR OR ACC_EXPDOWN


; ⠭

STACK_SIZE	EQU	0400	; ࠧ ⥪
B_DATA_SIZE	EQU	0300	; ࠧ   BIOS
B_DATA_ADDR	EQU	0400	;    BIOS
MONO_SEG	EQU	0b000	; ᥣ  
				;  ஬ 
COLOR_SEG	EQU	0b800	; ᥣ 
				; 梥⭮ 
CRT_SIZE	EQU	4000	; ࠧ ᥣ 
				;  梥⭮ 
MONO_SIZE	EQU	1000	; ࠧ ᥣ 
				;  ஬ 

CRT_LOW		EQU	8000	; .  䨧᪮ 
				;  ᥣ 
				;  梥⭮ 
MONO_LOW	EQU	0000	; .  䨧᪮ 
				;  ᥣ 
				;  ஬ 

CRT_SEG		EQU	0Bh	; .  䨧᪮ 
				;  ᥣ 

; , ।  ⠡ GDT

DS_DESCR	=	(gdt_ds - gdt_0)
CS_DESCR	=	(gdt_cs - gdt_0)
SS_DESCR	=	(gdt_ss - gdt_0)
BIOS_DESCR	=	(gdt_bio - gdt_0)
CRT_DESCR	=	(gdt_crt - gdt_0)
MDA_DESCR	=	(gdt_mda - gdt_0)

CMOS_PORT	EQU	70h	;   㯠  CMOS-
PORT_6845	EQU	0063h	;    BIOS,
				;  ᠭ 祭 
				;  ஫ 6845
COLOR_PORT	EQU	03d4h	;  梥⭮ ஫
MONO_PORT	EQU	03b4h	;  ஬ ஫
STATUS_PORT	EQU	64h	;  ﭨ 
SHUT_DOWN	EQU	0feh	;   
VIRTUAL_MODE	EQU	0001h	;  室   ०
A20_PORT	EQU	0d1h	;  ࠢ  A20
A20_ON		EQU	0dfh	;  A20
A20_OFF		EQU	0ddh	;  A20
KBD_PORT_A	EQU	60h	;  
KBD_PORT_B	EQU	61h	;   ⮢
INT_MASK_PORT	EQU	21h	;   ᪨஢ 뢠

STACK	STACK_SIZE	; ᥣ ⥪

DATASEG			; 砫 ᥣ 

DSEG_BEG	=	THIS WORD

;   ࠭ ॣ஢ SS, SP, ES. ন
;  ॣ஢ 㤥 ᠭ  । 室 
;  ०  ⠭  ᫥ 
;  񭭮 ०  ॠ.

	real_ss dw	?
	real_sp dw	?
	real_es dw	?

; 쭠 ⠡ ਯ஢ GDT,
; ᮤন ᫥騥 ਯ:
;
;	gdt_0	- ਯ  ⮣ ᥫ
;	gdt_gdt - ਯ  GDT
;	gdt_ds	- ਯ  ᥣ, 㥬 DS
;	gdt_cs	- ਯ  ᥣ 
;	gdt_ss	- ਯ  ᥣ ⥪
;	gdt_bio - ਯ    BIOS
;	gdt_crt - ਯ   梥⭮ ᯫ
;	gdt_mda - ਯ   ஬ ᯫ

GDT_BEG		= $
LABEL	gdtr		WORD

	gdt_0	desc_struc	<0,0,0,0,0> 
	gdt_gdt desc_struc	<GDT_SIZE-1,,,DATA_ACC,0>
	gdt_ds	desc_struc	<DSEG_SIZE-1,,,DATA_ACC,0>
	gdt_cs	desc_struc	<CSEG_SIZE-1,,,CODE_ACC,0>
	gdt_ss	desc_struc	<STACK_SIZE-1,,,DATA_ACC,0>
	gdt_bio desc_struc	<B_DATA_SIZE-1,B_DATA_ADDR,0,DATA_ACC,0>
	gdt_crt desc_struc	<CRT_SIZE-1,CRT_LOW,CRT_SEG,DATA_ACC,0>
	gdt_mda desc_struc	<MONO_SIZE-1,MONO_LOW,CRT_SEG,DATA_ACC,0>

GDT_SIZE	= ($ - GDT_BEG) ; ࠧ ⠡ ਯ஢

CODESEG		; ᥣ 

PROC	start

; 樠㥬 ॣ ᥣ 
;  ॠ쭮 ०

	mov	ax,DGROUP
	mov	ds,ax

; ।塞   

	call	set_crt_base

; ࠥ ࠭ ᯫ (⠭  䮭)

	mov	bh, 77h
	call	clrscr

; 믮塞  ⮢⥫ ⢨  室
;   ०  ᯥ祭  
;  ॠ ०

	call	init_protected_mode

; ४砥   ०

	call	set_protected_mode

; --------- * ணࠬ ࠡ⠥  񭭮 ०! * ---------

	call	write_hello_msg	; 뢮 ᮮ饭  ࠭
	call	pause		;  ஥ ६

; 頥  ॠ ०

	call	set_real_mode

; --------- * ணࠬ ࠡ⠥  ॠ쭮 ०! * ---------

; ࠥ ࠭  頥  DOS
	mov	bh, 07h
	call	clrscr
	mov	ah,4Ch
	int	21h

ENDP	start


; ------------------------------------------------------------
; ப    ਯ 24-⮢
;   ᥣ
; ------------------------------------------------------------

MACRO setgdtentry
	mov	[(desc_struc bx).base_l],ax
	mov	[(desc_struc bx).base_h],dl
ENDM

; ------------------------------------------------------------
; 楤 ⮢   室  
; ०  ᫥騬 ⮬  ॠ ०
; ------------------------------------------------------------

PROC	init_protected_mode	NEAR

; 塞  ⠡ ਯ஢ GDT

; 塞 24-⮢   ᥣ 

	mov	ax,DGROUP
	mov	dl,ah
	shr	dl,4
	shl	ax,4

;  dl:ax ᮤঠ  , ࠭塞   di:si

	mov	si,ax
	mov	di,dx

; ⠢ ਯ  GDT

	add	ax,OFFSET gdtr
	adc	dl,0
	mov	bx,OFFSET gdt_gdt
	setgdtentry

; ⠢ ਯ  ᥣ ds

	mov	bx,OFFSET gdt_ds
	mov	ax,si
	mov	dx,di
	setgdtentry

; ⠢ ਯ  ᥣ cs

	mov	bx,OFFSET gdt_cs
	mov	ax,cs
	mov	dl,ah
	shr	dl,4
	shl	ax,4
	setgdtentry

; ⠢ ਯ  ᥣ ⥪

	mov	bx,OFFSET gdt_ss
	mov	ax,ss
	mov	dl,ah
	shr	dl,4
	shl	ax,4
	setgdtentry

; 뢠    ॠ ०  
;  BIOS   0040h:0067h

	push	ds
	mov	ax,40
	mov	ds,ax
	mov	[WORD 67],OFFSET shutdown_return
	mov	[WORD 69],cs
	pop	ds

; ᪨㥬  뢠,  ⮬ ᫥ ᪨㥬.
; 뢠  CMOS-  祩 0Fh  5,
;   ᯥ ᫥ 믮  
; । ࠢ  , ⮢ 
;    BIOS   0040h:0067h.
;  ⮣, ⮡ ᪨㥬 뢠 뫨 饭,
; ⠭  1 訩   । 祩 CMOS.

	cli
	mov	al,8f
	out	CMOS_PORT,al
	jmp	next1		;  প
next1:

	mov	al, 5
	out	CMOS_PORT+1,al	;  

	ret

ENDP	init_protected_mode

; ------------------------------------------------------------
; 楤 ४砥    ०
; ------------------------------------------------------------

PROC	set_protected_mode	NEAR

	mov	ax,[rl_crt]	; 뢠  es ᥣ
	mov	es,ax		;  

	call	enable_a20	; 뢠   A20

	mov	[real_ss],ss	;  㪠⥫ ⥪
	mov	[real_es],es	;  ॠ쭮 ०

; 㦠 ॣ GDTR

	lgdt	[QWORD gdt_gdt]

; ⠭  ० ࠡ 

	mov	ax,VIRTUAL_MODE
	lmsw	ax

;  室  񭭮 ०

; 頥 ७ ।  
; 믮塞  ᥣ⭮ 室,
;  ⢥ ᥫ 㪠뢠 ᥫ ⥪饣
; ᥣ ,  ⢥ ᬥ饭 -  flush

;	jmp	far flush
	db	0ea
	dw	OFFSET flush
	dw	CS_DESCR

LABEL	flush	FAR

; 㦠 ᥣ ॣ SS  DS ᥫࠬ

	mov	ax,SS_DESCR
	mov	ss,ax
	mov	ax,DS_DESCR
	mov	ds,ax
	ret

ENDP	set_protected_mode

; ------------------------------------------------------------
; 楤 頥   ॠ ०
; ------------------------------------------------------------

PROC	set_real_mode	NEAR

;  ᮤন 㪠⥫ ⥪, ⠪  ᫥
;    㤥 ﭮ

	mov	[real_sp],sp

; 믮塞  

	mov	al,SHUT_DOWN
	out	STATUS_PORT,al

;   

wait_reset:
	hlt
	jmp	wait_reset

; ------->>      ᫥  ,
; ⥯  ᭮  ॠ쭮 ०

LABEL	shutdown_return FAR

; 樠㥬 ds ᮬ ᥣ 

	mov	ax,DGROUP
	mov	ds,ax
	assume	ds:DGROUP

; ⠭ 㪠⥫ ⥪

	mov	ss,[real_ss]
	mov	sp,[real_sp]

; ⠭ ᮤন ॣ es

	mov	es,[real_es]

; 뢠   A20

	call	disable_a20

; 蠥  뢠

	mov	ax,000dh	; ࠧ蠥 ᪨㥬 뢠
	out	CMOS_PORT,al

	in	al,INT_MASK_PORT ; ࠧ蠥 ᪨㥬 뢠
	and	al,0
	out	INT_MASK_PORT,al
	sti

	ret
ENDP	set_real_mode

; ------------------------------------------------------------
; 楤 뢠   A20
; ------------------------------------------------------------

PROC	enable_a20	NEAR
	mov	al,A20_PORT
	out	STATUS_PORT,al
	mov	al,A20_ON
	out	KBD_PORT_A,al
	ret
ENDP	enable_a20

; ------------------------------------------------------------
; 楤 뢠   A20
; ------------------------------------------------------------

PROC	disable_a20	NEAR
	mov	al,A20_PORT
	out	STATUS_PORT,al
	mov	al,A20_OFF
	out	KBD_PORT_A,al
	ret
ENDP	disable_a20

; ------------------------------------------------------------
; 楤 믮  ६ প
; ------------------------------------------------------------

PROC	pause		NEAR
	push	cx
	mov	cx,50
ploop0:
	push	cx
	xor	cx,cx
ploop1:
	loop	ploop1
	pop	cx
	loop	ploop0

	pop	cx
	ret
ENDP	pause

; ------------------------------------------------------------
;    楤 㦨 
; ------------------------------------------------------------

DATASEG
	columns	db	80d	; ⢮ ⮫殢  ࠭
	rows	db	25d	; ⢮ ப  ࠭

	rl_crt	dw	COLOR_SEG	; ᥣ  
	vir_crt dw	CRT_DESCR	; ᥫ 

	curr_line	dw	0d	;  ⥪饩 ப

CODESEG

; ------------------------------------------------------------
; ।   
; ------------------------------------------------------------

PROC	set_crt_base	NEAR

; ।塞 ⢮ ⮫殢  ࠭  뢠 
;  ६ columns

	mov	ax,40
	mov	es,ax
	mov	bx,[WORD es:4a]
	mov	[columns],bl

;    ⢠ ப, 뢠  ६ rows

	mov	bl,[BYTE es:84]
	inc	bl
	mov	[rows],bl

;  ⮣ ⮡ । ⨯ ஫ (梥⭮
;  ஬), 뢠  奬 6845

	mov	bx,[WORD es:PORT_6845]
	cmp	bx,COLOR_PORT
	je	set_crt_exit

; ᫨ ஫ ஬, 塞  ᥣ
;  ᥫ,   㬮砭

	mov	[rl_crt],MONO_SEG
	mov	[vir_crt],MDA_DESCR

set_crt_exit:
	ret
ENDP	set_crt_base

; ------------------------------------------------------------
; 뢮 ப  ࠭
; ࠬ:
;	(ax, bx) - न (x, y) 뢮 ப
;	ds:si	-  뢮 ப
;	cx	-  뢮 ப
; 	dh	- ਡ 뢮 ப
; 	es	- ᥣ  ᥫ 
; ------------------------------------------------------------

PROC	writexy		NEAR
	push	si
	push	di

; 塞 ᬥ饭     ப,
; ᯮ㥬  ((y * columns) + x) * 2

	mov	dl,[columns]
	mul	dl
	add	ax,bx
	shl	ax,1
	mov	di,ax
	mov	ah,dh	; 뢠  ah  ਡ

; 믮塞   

wxy_write:
	lodsb	; । ᨬ  al
	stosw	; 뢠   
	loop	wxy_write	; 横   ப

	pop	di
	pop	si
	ret
ENDP	writexy

; ------------------------------------------------------------
; 楤 ࠭ ࠭
;	ࠬ: bh - ਡ   ࠭
; ------------------------------------------------------------


PROC	clrscr		NEAR
	xor	cx,cx
	mov	dl,[columns]
	mov	dh,[rows]
	mov	ax,0600h	
	int	10h
	ret
ENDP	clrscr

DATASEG

hello_msg db " Protected mode monitor *TINY/OS*, v.1.0 for CPU 80286   (C) Frolov A.V., 1992 "

CODESEG

; ------------------------------------------------------------
; 楤 뢮 ᮮ饭  񭭮 ०
; ------------------------------------------------------------

PROC	write_hello_msg	NEAR

	mov	ax,[vir_crt]	; 㦠 ᥫ  
	mov	es,ax		;  ॣ es

; 뢮 ᮮ饭  孨  㣮 ࠭ (x=y=0)

	mov	bx,0		;(X,Y) = (AX,BX)
	mov	ax,[curr_line]
	inc	[curr_line]	; 㢥稢  ⥪饩 ப

; 㦠  뢮 ப   

	mov	si,OFFSET hello_msg
	mov	cx,SIZE hello_msg

	mov	dh,30h	; ਡ -  ⥪  㡮 䮭

	call	writexy ; 뢮 ப

	ret
ENDP	write_hello_msg


CSEG_SIZE	= ($ - start) ; ࠧ ᥣ 

DATASEG

DSEG_SIZE	= ($ - DSEG_BEG) ; ࠧ ᥣ 

	END	start
