// TST_UART.C
// ணࠬ । ⨯ 奬 UART ᨭ஭ 

#define    UART_8250     1
#define    UART_16450    2
#define    UART_16550    3
#define    UART_16550A   4


void main(void) {

	//  ᨭ஭    0  COM1
	//  1  COM2

	int port = 0;

	int test;

	printf("\n(c) Frolov G.V. 1992.   "
		   "ணࠬ । ⨯ UART\n\n");

	printf("\  ᨭ஭  (COM1 - 0, COM2 - 1):");
	scanf( "%d", &port );
	if(( port != 0 ) && ( port != 1 )){
		printf( "ᨭ஭  COM%d  ন\n", port );
		exit( -1 );
	}

	// ஢塞   奬 UART - UART 8250

	if( is_UART_8250(port) == UART_8250 ) {
		printf("㦥 奬 UART 8250\n");
		exit(0);
	}

	// ஢塞 㣨 ⨯ 奬 UART

	if(( test = is_UART_FIFO(port) ) == UART_16550A ) {
		printf("㦥 奬 UART 16550A\n");
		exit(0);
	}

	else if(test == UART_16550) {
		printf("㦥 奬 UART 16550\n");
		exit(0);
	}

	printf("㦥 奬 UART 16450\n");
}


/**
*.Name         is_UART_8250
*
*.Title        । ⨯ UART.
*
*.Descr         㭪 । ⨯ 奬,
*              ᯮ㥬  ᫥⥫ ᨭ஭
*              ஬ (UART).
*
*.Proto        int is_UART_8250( int port );
*
*.Params       int port -  ᨭ஭ :
*                 0 - COM1, 1 - COM2
*
*.Return        UART 8250 - 頥 ⠭ UART_8250,
*               ⠫  頥 0
*
*.Sample       tst_uart.c
**/
int is_UART_8250( int port ) {

	int save_scr, in_scr;

	// ࠭塞 祭 ॣ ७
	save_scr = inp( 0x3ff - 0x100 * port );

	// 뢠  ॣ ७ ᫮ 0x5A
	outp( 0x3ff - 0x100 * port, 0x5A );

	// 뢠 ॣ ७
	in_scr = inp( 0x3ff - 0x100 * port  );

	// ࠭  ᠭ ᫮?
	if( in_scr != 0x5A ) {

		// ᫨   ॣ ७  
		// ᫥⥫쭮 ⨯ 奬 UART 8250

		// ⠭ 祭 ॣ ७
		outp( 0x3ff - 0x100 * port, save_scr );
		return( UART_8250 );
	}

	// 뢠  ॣ ७ 㣮 ᫮ - 0xA5
	outp( 0x3ff - 0x100 * port, 0xA5 );

	// 뢠 ॣ ७
	in_scr = inp( 0x3ff - 0x100 * port  );

	// ⠭ 祭 ॣ ७
	outp( 0x3ff - 0x100 * port, save_scr );

	// ࠭  ᠭ ᫮?
	if( in_scr != 0xA5 )

		// ᫨   ॣ ७  
		// ᫥⥫쭮 ⨯ 奬 UART 8250
		return( UART_8250 );

	//  ⨢ 砥 ॣ ७    믮
	// 쭥襥 ஢  । ⨯ UART
	return( 0 );
}



/**
*.Name         is_UART_FIFO
*
*.Title        । ⨯ UART.
*
*.Descr         㭪 । ⨯ 奬,
*              ᯮ㥬  ᫥⥫ ᨭ஭
*              ஬ (UART).
*
*.Proto        int is_UART_FIFO( int port );
*
*.Params       int port -  ᨭ஭ :
*                 0 - COM1, 1 - COM2
*
*.Return        UART 164550 - 頥 ⠭ UART_16450,
*               UART 16550 - 頥 ⠭ UART_16550,
*               UART 16550A - 頥 ⠭ UART_16550A
*
*.Sample       tst_uart.c
**/
int is_UART_FIFO( int port ) {

	int save_iir, in_iir;

	// ࠭塞 祭 ॣ । 뢠
	save_iir = inp( 0x3fa - 0x100 * port );

	// ࠧ蠥 ᯮ짮 FIFO
	outp( 0x3fa - 0x100 * port, 0x1 );

	// ⠥ 祭 ॣ । 뢠
	in_iir = inp( 0x3fa - 0x100 * port  );

	// ⠭  祭 ॣ । 뢠
	outp( 0x3fa - 0x100 * port, 0x0 );

	// ᫨  D6 ᮤন ,    UART 16550A
	if(( in_iir & 0x40 ) == 1 )
		return( UART_16550A );

	// ᫨  D7 ᮤন ,    UART 16550
	if(( in_iir & 0x80 ) == 1 )
		return( UART_16550 );

	// ᫨  D7  D6 ᮤঠ 㫨,    UART 16450
	// ( FIFO )
	return( UART_16450 );
}

