;
; UART.ASM
;  ࠢ   COM-⮬  ஢
;

;  ।塞 ࠧ  ਥ  ।稪

R_SIZE   EQU   2048     ; ࠧ ਥ 
S_SIZE   EQU   500      ; ࠧ  ।稪


;  ࠡ稪 뢠

INT_COM1 EQU   0Ch      ; COM1
INT_COM2 EQU   0Bh      ; COM2
INT_COM3 EQU   0Ch      ; COM3
INT_COM4 EQU   0Bh      ; COM4


;  ஫ 뢠 8259

OCR   EQU   20H      ; ࠢ騩 ॣ 8259
IMR   EQU   21H      ; ॣ ᪨ 뢠 8259


; ⠭  ࠢ ஫஬ 뢠

E_IRQ4   EQU   00010000B
D_IRQ4   EQU   11101111B
EOI4     EQU   01100100B

E_IRQ3   EQU   00001000B
D_IRQ3   EQU   11110111B
EOI3     EQU   01100011B

;
;  ६ BIOS
;

;   ॣ஢ ᫥⥫ ᨭ஭ ஢

BIOS_VAR  SEGMENT AT 40H

	rs232_base DW  4 DUP(?)

BIOS_VAR  ENDS


;
; ⠡   COM-
;

SP_TAB		STRUC

	port     DB ?  ; 1, 2, 3  4


; ࠬ  ⮣ ஢ 뢠

	int_com  DB ?  ;  뢠
	e_irq    DB ?
	d_irq    DB ?
	eoi      DB ?


; ࠡ稪 뢠  ⮣ ஢

	int_hndlr   DW ?  ; ᬥ饭 ࠡ稪 뢠
	old_com_off DW ?  ; ᬥ饭 ண ࠡ稪 뢠
	old_com_seg DW ?  ; ᥣ ண ࠡ稪 뢠

; ࠬ COM-

	installed      DB ?  ; ⠭    ⮬ ? (1=,0=)
	baud_rate      DW ?
	device_conn    DB ?  ; M(), D(-)
	parity         DB ?  ; N(ONE), O(DD), E(VEN), S(PACE), M(ARK)
	stop_bits      DB ?  ; 1, 2

; 稪 訡

	error_block DW 8 DUP(?)

;  8250

	DATREG   DW ?  ; ॣ 
	IER      DW ?  ; ॣ ࠢ 뢠ﬨ
	IIR      DW ?  ; ॣ 䨪樨 뢠
	LCR      DW ?  ; ॣ ࠢ 
	MCR      DW ?  ; ॣ ࠢ 
	LSR      DW ?  ; ॣ ﭨ 
	MSR      DW ?  ; ॣ ﭨ 

	DLL      EQU   DATREG ; 訩 ॣ ⥫
	DLH      EQU   IER    ; 訩 ॣ ⥫

; 㪠⥫ ஢ FIFO

	;  ࢮ ᨬ   ।稪
	start_s_data DW ?

	;  ࢮ ᢮   ।稪
	end_s_data   DW ?

	;  ࢮ ᨬ   ਥ
	start_r_data DW ?

	;  ࢮ ᢮   ਥ
	end_r_data   DW ?


; 稪 ⢠ ᨬ  

	size_s_data  DW ?  ; ᫮ ᨬ   ।稪
	size_r_data  DW ?  ; ᫮ ᨬ   ਥ


; 

	send_buf       DB    S_SIZE DUP(?)  ;  ।稪
	reciave_buf    DB    R_SIZE DUP(?)  ;  ਥ

SP_TAB      ENDS


EFRAME   EQU   error_block+6  ; 訡 ᨭ஭樨
EPARITY  EQU   error_block+8  ; 訡 ⭮
EOVFLOW  EQU   error_block    ; ந諮 ९ 
EDSR     EQU   error_block+12 ;   ⢥⨫ ᨣ DSR

EOVRUN   EQU   error_block+2  ; 訡 ९
EBREAK   EQU   error_block+4  ; 㦥   뢠

EXMIT    EQU   error_block+10 ; 訡  ।
ECTS     EQU   error_block+14 ;   ⢥⨫ ᨣ CTS



;
;
DGROUP	GROUP _DATA

_DATA SEGMENT public 'DATA'


	DIV50    DW    2304

; ⥪騩    

	CURRENT_AREA   DW AREA1

;     

	AREA1 SP_TAB   <1,INT_COM1,E_IRQ4,D_IRQ4,EOI4>     ;   COM1
	AREA2 SP_TAB   <2,INT_COM2,E_IRQ3,D_IRQ3,EOI3>     ;   COM2
	AREA3 SP_TAB   <3,INT_COM3,E_IRQ4,D_IRQ4,EOI4>     ;   COM3
	AREA4 SP_TAB   <4,INT_COM4,E_IRQ3,D_IRQ3,EOI3>     ;   COM4

_DATA  ENDS



COM_TEXT    SEGMENT PARA public 'CODE'

	ASSUME   cs:COM_TEXT,ds:DGROUP,es:NOTHING

	public   _select_port
	public   _save_com
	public   _install_com
	public   _restore_com
	public   _open_com
	public   _close_com
	public   _dtr_on
	public   _dtr_off
	public   _r_count
	public   _s_count
	public   _receive_com
	public   _send_com
	public   _break_com
	public   _com_errors



;
; 롮 ⨢ 
;  [bp+6] -  

_select_port   PROC FAR

	push  bp
	mov   bp, sp
	mov   ax, [bp+6]  ;砥  ax 㬥 㭪樨

	cmp   al,1     ; ⠭  1?
	je    port1    ; 

	cmp   al,2     ; ⠭  2?
	je    port2    ; 

	cmp   al,3     ; ⠭  3?
	je    port3    ; 

	cmp   al,4     ; ⠭  4?
	je    port4    ; 

	jmp set_carrent_area


port1:
	mov   ax,OFFSET DGROUP:AREA1  ; 롨ࠥ    COM1
	jmp   short set_carrent_area

port2:
	mov   ax,OFFSET DGROUP:AREA2  ; 롨ࠥ    COM2
	jmp   short set_carrent_area

port3:
	mov   ax,OFFSET DGROUP:AREA3  ; 롨ࠥ    COM3
	jmp   short set_carrent_area

port4:
	mov   ax,OFFSET DGROUP:AREA4  ; 롨ࠥ    COM4

set_carrent_area:

	; 뢠  ६ CURRENT_AREA ᬥ饭
	; ⥪饩  

	mov   CURRENT_AREA,ax

	mov sp,bp
	pop bp
	ret

_select_port   ENDP


;
; ࠭ ⥪饣  COM 뢠
;
_save_com	PROC FAR

	push bp
	mov bp,sp
	push si

	; 뢠  si 㪠⥫  ⥪  

	mov   si,CURRENT_AREA
	push  es

	mov   AREA1.int_hndlr,OFFSET int_hndlr1
	mov   AREA2.int_hndlr,OFFSET int_hndlr2
	mov   AREA3.int_hndlr,OFFSET int_hndlr3
	mov   AREA4.int_hndlr,OFFSET int_hndlr4

; ࠭塞   뢠

	mov   ah,35H
	mov   al,int_com[si] ;  뢠
	int   21h

; 뢠  ६ old_com_off  old_com_seg
; ᮮ⢥⢥ ᥣ  ᬥ饭 ண  뢠

	mov   old_com_off[si],bx
	mov   bx,es
	mov   old_com_seg[si],bx

	pop   es

	pop si
	mov sp,bp
	pop bp

	ret

_save_com	ENDP


;
; install_com: ⠭ ⨢ 
;
; 頥  ॣ ax - 1  ᯥ譮 ⠭
;  0  砥 訡
;
_install_com   PROC FAR

	push bp
	mov bp,sp
	push si

	mov   si,CURRENT_AREA

	push  es

	cmp   installed[si],1
	jne   go_install
	jmp   alredy_ok

; 頥 稪 訡

go_install:

	mov   WORD PTR EOVFLOW[si],0  ; ९  ।稪
	mov   WORD PTR EOVRUN[si],0   ; 訡 ९  ਥ
	mov   WORD PTR EBREAK[si],0   ; 㦥   뢠
	mov   WORD PTR EFRAME[si],0   ; 訡 ᨭ஭樨
	mov   WORD PTR EPARITY[si],0  ; 訡 ⭮
	mov   WORD PTR EXMIT[si],0    ; 訡  ।
	mov   WORD PTR EDSR[si],0     ;  祭 ᨣ DSR
	mov   WORD PTR ECTS[si],0     ;  祭 ᨣ CTS


; ।塞   ᯮ㥬 COM 

	mov   bx,BIOS_VAR
	mov   es,bx

	ASSUME   es:BIOS_VAR

	cmp   port[si],1  ;  1?
	je    adr_3F8

	cmp   port[si],2  ;  2?
	je    adr_2F8

	cmp   port[si],3  ;  3?
	je    adr_3E8

	cmp   port[si],4  ;  4?
	je    adr_2E8

	int   20H

adr_3F8:
	mov   ax,3F8H
	jmp   cmp_bios


adr_2F8:
	mov ax,2F8H
	jmp   cmp_bios

adr_3E8:
	cmp   rs232_base+4,0
	je    adr_3E8_A

	mov   ax,rs232_base+4
	jmp   cmp_bios

adr_3E8_A:
	mov   ax,3E8H
	mov   rs232_base+4,ax
	jmp   cmp_bios


adr_2E8:
	cmp   rs232_base+6,0
	je    adr_2E8_A

	mov   ax,rs232_base+6
	jmp   cmp_bios

adr_2E8_A:
	mov   ax,2E8H
	mov rs232_base+6,ax

; ஢塞  ।  ᮮ⢥頠 ६
; BIOS

cmp_bios:
	cmp   ax,rs232_base
	je    set_reg_adr

	cmp   ax,rs232_base+2
	je    set_reg_adr

	cmp   ax,rs232_base+4
	je    set_reg_adr

	cmp   ax,rs232_base+6
	jne   bad_exit


set_reg_adr:

	mov   bx,DATREG
	mov   cx,7

set_next_reg_adr:

	mov   WORD PTR [si][bx],ax
	inc   ax
	add   bx,2
	loop  set_next_reg_adr

; ⠭  뢠   ࠡ稪

	mov   AREA1.int_hndlr,OFFSET int_hndlr1
	mov   AREA2.int_hndlr,OFFSET int_hndlr2
	mov   AREA3.int_hndlr,OFFSET int_hndlr3
	mov   AREA4.int_hndlr,OFFSET int_hndlr4

	mov   ah,25H
	mov   al,int_com[si] ;  뢠
	mov   dx,OFFSET DGROUP:int_hndlr[si]
	push  ds
	push  cs
	pop   ds
	int   21h

	pop   ds

	;  䫠 -  ⠭

alredy_ok:
	mov   installed[si],1
	pop   es

	; 頥 1

	mov ax,1
	pop si
	mov sp,bp
	pop bp
	ret

;   ⠭

bad_exit:
	mov installed[si],0
	pop   es

	; 頥 0

	mov ax,0
	pop si
	mov sp,bp
	pop bp
	ret

_install_com   ENDP


;
; ⠭ ஢ 뢠
;
_restore_com   PROC FAR

	push bp
	mov bp,sp
	push si

; ⬥砥 COM    ⨢

	mov   si,CURRENT_AREA
	mov   installed[si],0

; ⠭  뢠

	mov   ah,25H
	mov   al,int_com[si]
	mov   dx,old_com_off[si]
	mov   bx,old_com_seg[si]
	push  ds
	mov   ds,bx
	int   21h

	pop   ds

	pop   si
	mov   sp,bp
	pop   bp
	ret

_restore_com   ENDP


;
;  COM 
;
;  ஢ ।稪  ਥ,
; 樠 ॣ஢ UART 8250
; ࠧ襭 뢠  UART 8250
; (ணࠬ஢ ஫ 뢠)
;
; [bp+6] = ᪮ 
; [bp+8] = ᯮᮡ ᮥ -  M(), D(-)
; [bp+10] = ⭮ - N(ONE), O(DD), E(VEN), S(PACE), M(ARK)
; [bp+12] = ᫮ ⮯ ⮢ 1, 2
;
_open_com   PROC FAR

	push bp
	mov bp,sp
	push si

	mov   si,CURRENT_AREA

 ; 頥 뢠

	cli
	mov   ax,[bp+6]
	mov   baud_rate[si],ax
	mov   bh,[bp+8]
	mov   device_conn[si],bh
	mov   bl,[bp+10]
	mov   parity[si],bl
	mov   ch,[bp+12]
	mov   stop_bits[si],CH


; 뢠   㪠⥫

	mov   start_s_data[si],0
	mov   end_s_data[si],0
	mov   start_r_data[si],0
	mov   end_r_data[si],0
	mov   size_s_data[si],0
	mov   size_r_data[si],0

	; ஢塞 ⠭  㦥 ࠡ稪 뢠

	test  installed[si],1
	jnz   reset_uart
	jmp   exit_open

reset_uart:

; ⠭ ॣ UART 8250

; 뢠 ॣ ࠢ 

	mov   al,0
	mov   dx,MCR[si]
	out   dx,al
	jmp   $+2

	; 뢠 ॣ ﭨ 

	mov   dx,LSR[si]
	in    al,dx
	jmp   $+2

	; 뢠 ॣ 

	mov   dx,DATREG[si]
	in    al,dx
	jmp   $+2

	; 뢠 ॣ ﭨ 

	mov   dx,MSR[si]
	in    al,dx

	; ।塞 ⥫  ⠪⮢ 

	mov   ax,50
	mul   DIV50
	div   baud_rate[si]
	mov   bx,ax

	; ४砥 ॣ   ॣ ࠢ 뢠ﬨ
	;   ⥫  ⠪⮢ 

	mov   dx,LCR[si]
	mov   al,80H
	out   dx,al
	jmp   $+2

	;  訩  ⥫  ⠪⮢ 

	mov   dx,WORD PTR DLL[si]
	mov   al,bl
	out   dx,al
	jmp   $+2

	;  訩  ⥫  ⠪⮢ 

	mov   dx,WORD PTR DLH[si]
	mov   al,bh
	out   dx,al
	jmp   $+2

; ।塞 ⭮  ᫮ ⮯ ⮢

	mov   al,03H
	cmp   parity[si],'O'
	jne   next1
	mov   al,0ah
	jmp   short next3

next1:
	cmp   parity[si],'E'
	jne   next2
	mov   al,1ah
	jmp   short next3

next2:
	cmp   parity[si],'M'
	jne   next3
	mov   al,2ah

next3:
	test  stop_bits[si],2
	jz stop1
	or al,4

stop1:
	mov   dx,LCR[si]
	out   dx,al

; ࠧ蠥 뢠  8259  8250

	; ⠭ ॣ ᪨ 뢠 ⮡
	; ࠧ 뢠  ᨭ஭ 

	in    al,IMR
	and   al,d_irq[si]
	out   IMR,al

	; ࠧ蠥  뢠  ⮢ ਭ
	; ,  ﭨ "BREAK"   訡

	mov   dx,IER[si]
	mov   al,5
	out   dx,al
	jmp   $+2

	; ⠭ DTR, RTS, OUT2

	mov   dx,MCR[si]
	mov   al,0bh
	out   dx,al

exit_open:

	sti

	pop si
	mov sp,bp
	pop bp
	ret

_open_com	ENDP


;
; 頥 뢠  ᨭ஭ 
;
_close_com	PROC FAR
	push bp
	mov bp,sp
	push si

	mov   si,CURRENT_AREA
	test  installed[si],1
	jz    exit_close

; 頥 뢠 UART 8250

	mov   dx,IER[si]
	mov   al,0
	out   dx,al

; ᪨㥬 뢠  UART

	mov   dx,IMR
	in    al,dx
	or    al,e_irq[si]
	jmp   $+2
	out   dx,al

exit_close:

	pop si
	mov sp,bp
	pop bp
	ret

_close_com	ENDP


;
; ᭨ ᨣ DTR
;

_dtr_off	PROC FAR

	push bp
	mov bp,sp
	push si

	pushf
	push  ax
	push  dx
	push  si

	mov   si,CURRENT_AREA
	test  installed[si],1
	jz    exit_dtr_off

	; ⠭ ॣ ࠢ ,
	; 뢠 ᨣ DTR  RTS

	mov   dx,MCR[si]
	mov   al,08H
	out   dx,al

exit_dtr_off:

	pop   si
	pop   dx
	pop   ax
	popf

	pop si
	mov sp,bp
	pop bp

	ret

_dtr_off	ENDP


;
; ⠭ ᨣ DTR
;

_dtr_on PROC FAR

	push bp
	mov bp,sp
	push si

	pushf
	push  ax
	push  dx
	push  si
	mov   si,CURRENT_AREA
	test  installed[si],1
	jz    exit_dtr_on

	; ⠭ ॣ ࠢ ,
	; ⠭ ᨣ DTR, RTS, OUT2

	mov   dx,MCR[si]
	mov   al,0bh
	out   dx,al

exit_dtr_on:

	pop   si
	pop   dx
	pop   ax
	popf

	pop si
	mov sp,bp
	pop bp

	ret

_dtr_on ENDP


;
; 頥  ॣ ax ᫮ ⮢  ॣ ਥ,
;   ॣ dx 騩 ࠧ  ਥ
;

_r_count	PROC FAR
	push bp
	mov bp,sp
	push si

	pushf
	push  si
	mov   si,CURRENT_AREA

	mov   ax,0
	mov   dx,R_SIZE

	test  installed[si],1
	jz    exit_r_count

	; 뢠  ॣ ax ᫮ ᨬ   ਥ

	mov   ax,size_r_data[si]

exit_r_count:

	pop   si
	popf

	pop si
	mov sp,bp
	pop bp
	ret

_r_count	ENDP


;
; 砥 । ᨬ   ਥ,
; 祭 ᨬ 㤠  
;

_receive_com	PROC FAR

	push bp
	mov bp,sp
	push si

	pushf
	push  bx
	push  si

	mov   si,CURRENT_AREA
	mov   ax,-1

	test  installed[si],1
	jz    exit_receive_com

	; 頥 ᫨  ਥ 

	cmp   size_r_data[si],0
	je    exit_receive_com


	mov   ah,0
	mov   bx,start_r_data[si]
	mov   al,reciave_buf[si][bx]


	cmp   parity[si],'N'
	je no_parity

	; ᫨ ந ઠ  ⭮,  ᪨㥬 訩 

	and   al,7FH

no_parity:

	inc   bx
	cmp   bx,R_SIZE
	jb    rec_ptr_no_max
	mov   bx,0

rec_ptr_no_max:

	mov   start_r_data[si],bx
	dec   size_r_data[si]

exit_receive_com:

	pop   si
	pop   bx
	popf

	pop si
	mov sp,bp
	pop bp

	ret

_receive_com	ENDP



;
; 㭪 頥  ॣ ax ᫮ ᢮  
;  ।稪,   ॣ dx 騩 ࠧ  ।稪
;
_s_count	PROC FAR

	push bp
	mov bp,sp
	push si

	pushf
	push  si

	mov   si,CURRENT_AREA
	mov   ax,0
	mov   dx,S_SIZE

	test  installed[si],1
	jz    exit_s_count

	mov   ax,S_SIZE
	sub   ax,size_s_data[si]

exit_s_count:

	pop   si
	popf

	pop si
	mov sp,bp
	pop bp

	ret

_s_count	ENDP



;
;  ᨬ   ।稪
;  [bp+6] - ᨬ
;
_send_com	PROC FAR

	push bp
	mov bp,sp
	push si

	mov al,[bp+6]

	pushf
	push  ax
	push  bx
	push  dx
	push  si

	mov   si,CURRENT_AREA

	test  installed[si],1
	jz    exit_send_com

	cmp   size_s_data[si],S_SIZE
	jl    no_s_EOVFLOW

	; ந諮 ९  ।稪

	inc   WORD PTR EOVFLOW[si]
	jmp   short exit_send_com

no_s_EOVFLOW:

	mov   bx,end_s_data[si]
	mov   send_buf[si][bx],al
	inc   bx
	cmp   bx,S_SIZE
	jl    no_send_ptr_max
	mov   bx,0

no_send_ptr_max:

	mov   end_s_data[si],bx
	inc   size_s_data[si]

	; 뢠 ॣ ࠢ 뢠ﬨ

	mov   dx,IER[si]
	in    al,dx

	; 蠥 㭪 ᫨ ࠧ襭 뢠 ᫥ । 

	test  al,2
	jnz   exit_send_com

	; ࠧ蠥 뢠 ᫥ । , ᫥ ਨ ,
	;  㦥 ﭨ "BREAK"    訡

	mov   al,7
	out   dx,al

exit_send_com:

	pop   si
	pop   dx
	pop   bx
	pop   ax
	popf

	pop si
	mov sp,bp
	pop bp

	ret

_send_com	ENDP


;
; S_local
;
_send_local PROC FAR
	push bp
	mov bp,sp
	push si

	mov al,[bp+6]
	pushf
	push  ax
	push  bx
	push  si
	mov   si,CURRENT_AREA
	test  installed[si],1
	jz    SLX

	cli
	cmp   size_r_data[si],R_SIZE
	jb    L13A
	inc   WORD PTR EOVFLOW[si]
	jmp   short L14

L13A:
	mov   bx,end_r_data[si]
	mov   reciave_buf[si][bx],al
	inc   bx
	cmp   bx,R_SIZE
	jl    L13
	mov   bx,0

L13:
	mov   end_r_data[si],bx
	inc   size_r_data[si]

L14:
	sti

SLX:
	pop   si
	pop   bx
	pop   ax
	popf
	pop si
	mov sp,bp
	pop bp
	ret
_send_local ENDP



;
; । 㤠  ᨣ "BREAK"
;

_break_com	PROC FAR

	push bp
	mov bp,sp
	push si

	pushf
	push  ax
	push  cx
	push  dx

	mov   si,CURRENT_AREA
	test  installed[si],1
	jz    exit_break_com

	; । ᨣ "BREAK"

	mov   dx,LCR[si]
	in    al,dx
	jmp   $+2
	or    al,40h
	out   dx,al

	mov   cx,0C000h

do_BREAK:
	loop   do_BREAK

	and   al,0BFh
	out   dx,al

exit_break_com:

	pop   dx
	pop   cx
	pop   ax
	popf

	pop si
	mov sp,bp
	pop bp

	ret

_break_com	ENDP



;
; 頥  dx:ax 㪠⥫  稪 訡
;
_com_errors PROC FAR

	push  bp

	mov   bp,sp
	mov   ax,OFFSET DGROUP:CURRENT_AREA
	add   ax,error_block
	mov   dx,ds
	mov   sp,bp

	pop   bp

	ret
_com_errors ENDP


;
; 塞 稪 訡
;

set_err   PROC  NEAR

	test  al,2
	jz    test1
	inc   WORD PTR EOVRUN[si]

test1:
	test  al,4
	jz    test2
	inc   WORD PTR EPARITY[si]

test2:
	test  al,8
	jz    test3
	inc   WORD PTR EFRAME[si]

test3:
	test  al,16
	jz    exit_set_err
	inc   WORD PTR EBREAK[si]

exit_set_err:

	ret

set_err   ENDP


;
; ⮪   । 
;

modem_protocol PROC NEAR

	cmp   device_conn[si],'M'
	jne   no_modem

; ⠭ ᨣ DTR, RTS  OUT2

	mov   dx,MCR[si]
	mov   al,00001011B
	out   dx,al
	jmp   $+2

;    ⢥  ⮢ ᨣ DSR

	mov   cx,1000
	mov   dx,MSR[si]

wait_dsr:
	in    al,dx
	test  al,20H
	jnz   test_cts
	loop  wait_dsr

	;   ⢥⨫ ᨣ DSR

	inc   WORD PTR EDSR[si]
	jmp   short no_modem

test_cts:

;    ⢥  ⮢ ᨣ CTS

	mov   cx,1000

wait_cts:
	in    al,dx
	test  al,10H
	jnz   test_lcr
	loop  wait_cts

	;   ⢥⨫ ᨣ CTS

	inc   WORD PTR ECTS[si]

test_lcr:
no_modem:

	; ஢塞   ॣ ࠭ ।稪

	mov   dx,LSR[si]
	in    al,dx
	test  al,20H
	jnz   s_reg_empty

	; 訡  ।

	inc   WORD PTR EXMIT[si]

s_reg_empty:

	ret

modem_protocol ENDP


;
; ࠡ稪 뢠  COM1
;

int_hndlr1 PROC  FAR

	push  si
	mov   si,OFFSET DGROUP:AREA1
	jmp   short handle_int

;
; ࠡ稪 뢠  COM2
;

int_hndlr2 PROC  FAR

	push  si
	mov   si,OFFSET DGROUP:AREA2
	jmp   short handle_int

;
; ࠡ稪 뢠  COM3
;

int_hndlr3 PROC  FAR

	push  si    ; SAVE si
	mov   si,OFFSET DGROUP:AREA3
	jmp   short handle_int

;
; ࠡ稪 뢠  COM4
;

int_hndlr4 PROC  FAR

	push  si    ; SAVE si
	mov   si,OFFSET DGROUP:AREA4


;
; ࠡ稪 뢠
;

handle_int:

	push  ax
	push  bx
	push  cx
	push  dx
	push  bp
	push  di
	push  ds
	push  es

	mov   ax,DGROUP
	mov   ds,ax

next_pr:

; । ஫ 뢠   ࠡ⪨
; 뢠

	mov   dx,OCR
	mov   al,eoi[si]
	out   dx,al

next_inter:

	; 뢠 祭 ॣ 䨪樨 뢠

	mov   dx,IIR[si]
	in    al,dx

	; ।塞 稭 뢠

	;  ਭ  㯭  ⥭
	cmp   al,4
	je    RX_int

	;  ।稪 
	cmp   al,2
	je    TX_int

	;  ﭨ  CTS, RI, DCD, DSR
	cmp   al,6
	je    LSTAT_int

	; 㦥 ﭨ "BREAK"  ந諠 訡
	cmp   al,0
	je    MSTAT_int

	; 蠥 ࠡ 뢠

	jmp   FAR PTR exit_handler

LSTAT_int:

	; 뢠 ॣ ﭨ   뢠 㭪
	; set_err,  । 稭 뢠

	mov   dx,LSR[si]
	in    al,dx
	call  set_err
	jmp   next_inter

MSTAT_int:

	; 뢠 ॣ ﭨ 

	mov   dx,MSR[si]
	in    al,dx
	jmp   next_inter

TX_int:

	; ᬮਬ     । 

	cmp   size_s_data[si],0

	jg    have_data_for_send

; ᫨  ।稪  ⠭ ॣ
; ࠢ 뢠ﬨ

	mov   dx,IER[si]
	mov   al,5
	out   dx,al
	jmp   next_inter

have_data_for_send:

	; । ᨬ   ᮮ⢥⢨  ﭨ
	;  RS-232-

	call  modem_protocol

	; । । ᨬ   ।稪

	mov   bx,start_s_data[si]
	mov   al,send_buf[si][bx]
	mov   dx,DATREG[si]
	out   dx,al

	inc   bx
	cmp   bx,S_SIZE
	jb    ptr_no_max
	mov   bx,0

ptr_no_max:

	mov   start_s_data[si],bx
	dec   size_s_data[si]
	jmp   next_inter


;  ਭ  㯭  ⥭
RX_int:

	; 뢠 ਭ   ॣ  UART

	mov   dx,DATREG[si]
	in    al,dx

	cmp   size_r_data[si],R_SIZE
	jl    no_r_EOVFLOW

	;  ਥ ९, 㢥稢 ᮮ⢥騩
	; 稪 訡

	inc   WORD PTR EOVFLOW[si]
	jmp   next_inter

no_r_EOVFLOW:

	mov   bx,end_r_data[si]
	mov   reciave_buf[si][bx],al
	inc   size_r_data[si]
	inc   bx

	cmp   bx,R_SIZE
	jb    no_max_r_ptr
	mov   bx,0

no_max_r_ptr:

	mov   end_r_data[si],bx

	jmp   next_inter

exit_handler:

	mov   al,20h
	out   20h,al

	pop   es
	pop   ds
	pop   di
	pop   bp
	pop   dx
	pop   cx
	pop   bx
	pop   ax

	pop   si
	iret

int_hndlr4 ENDP
int_hndlr3 ENDP
int_hndlr2 ENDP
int_hndlr1 ENDP

COM_TEXT ENDS

END
