// TO_MODEM.C

#include "sysp.h"
#include "uart_reg.h"

//  㭪権
int com_out( unsigned, char );
int to_modem( unsigned, char* );

/**
*.Name         to_modem
*
*.Title        ।  ப, 稢 㫥.
*
*.Descr         㭪 ।  ப, 稢 㫥.
*
*.Proto        void to_modem( unsigned base_address, char *out_str );
*
*.Params       unsigned base_address -   ᨭ஭ ,
*               ஬ 室 ;
*
*              char *out_str - ᨢ ᨬ, । ,
*              稢 㫥
*
*.Return       -1, ᫨  ᨣ DSR  
*
*.Sample       to_modem.c
**/

int to_modem( unsigned base_address, char *out_str ) {

	int i;

	// ᫥⥫쭮 ।   ᨬ  ப

	for( i = 0; out_str[i] != '\0'; i++ )
		if( 0 != com_out( base_address, out_str[i] )) return( -1 );

	// 稢 । ப  뫠  
	// ॢ ⪨, 뢠騩 ᯮ  

	com_out( base_address, 13 );
	return( 0 );
}


/**
*.Name         com_out
*
*.Title        ।   ᨬ.
*
*.Descr         㭪 ।  ᨬ.
*
*.Proto        void com_out( unsigned base_address, char out_char )
*
*.Params       unsigned base_address -   ᨭ஭ ,
*               ஬ 室 ;
*
*              char out_char - ᨬ, । ,
*
*.Return       -1, ᫨  ᨣ DSR  
*
*.Sample       to_modem.c
**/

int com_out( unsigned base_address, char out_char ) {

	unsigned char  next;

	int      i;
	LSR      ls_reg;
	MSR      ms_reg;

	//    ᮮ  ᢮ ⮢
	//   DSR

	for( ms_reg.byte = 0, i = 0;
			((ms_reg.bit_reg.dsr == 0) && ( i < 1000)); i++) {

		ms_reg.byte = inp( base_address + MSR_N );
	}

	if( i == 1000 ) return( -1 ); //   ⮢


	//   ᢮ ॣ ।稪
	//   㤥 । ᫥騩 

	for( ls_reg.byte = 0; ls_reg.bit_reg.out_ready == 0; )
		ls_reg.byte = inp( base_address + LSR_N );

	// 뢠 ।   ॣ 
	//  ᫥饩  । 

	outp( base_address, out_char );

	return( 0 );
}

