// UART.H


/**
*.Name         select_port
*
*.Title        롨ࠥ ᯮ㥬 COM-
*
*.Descr         㭪 ।   COM-⮬
*                쭥襬 㤥 ࠡ.
*
*.Proto        void far select_port(int port)
*
*.Params       int port -   (COM1..COM4)
*
*.Return        ᯮ
*
*.Sample       comm.asm
**/
void far select_port(int);


/**
*.Name         save_com
*
*.Title        ࠭塞   뢠 COM-
*
*.Descr         㭪 ࠭  ண ࠡ稪
*              뢠  COM-.
*
*.Proto        void far save_com(void)
*
*.Params        ᯮ
*
*.Return        ᯮ
*
*.Sample       comm.asm
**/
void far save_com(void);


/**
*.Name         restore_com
*
*.Title        ⠭   뢠 COM-
*
*.Descr         㭪 ⠭  ண ࠡ稪
*              뢠  COM-.
*
*.Proto        void far restore_com(void)
*
*.Params        ᯮ
*
*.Return        ᯮ
*
*.Sample       comm.asm
**/
void far restore_com(void);


/**
*.Name         install_com
*
*.Title        ⠭ ᢮ ࠡ稪 뢠 COM-
*
*.Descr         㭪 ⠭  ࠡ稪
*              뢠  COM-.
*
*.Proto        int far install_com(void)
*
*.Params        ᯮ
*
*.Return       頥 1  ᯥ譮 ⠭
*               0  砥 訡
*
*.Sample       comm.asm
**/
int far install_com(void);


/**
*.Name         install_com
*
*.Title        ⠭ ᢮ ࠡ稪 뢠 COM-
*
*.Descr         㭪 ⠭  ࠡ稪
*              뢠  COM-.
*
*.Proto        void far open_com( int baud, int device,
*                                 int parity, int stop_bits )
*
*.Params       int baud       - ᪮ 
*              int device     - ⨯ ந⢠ 裡: M - 
*                               D - -
*              int parity     - ஢ઠ  ⭮: N -  ஢ન
*                                ⭮, O - ஢ઠ  ⭮,
*                               E - ஢ઠ  ⭮, S - Space,
*                               M - Mark
*              int stop_bits  - ⢮ ⮯ ⮢
*
*.Return        ᯮ
*
*.Sample       comm.asm
**/
void far open_com( int, int, int, int );


/**
*.Name         close_com
*
*.Title        頥 뢠  ᨭ஭  COM-
*
*.Descr         㭪 頥 뢠  COM-
*
*.Proto        void far close_com(void)
*
*.Params        ᯮ
*
*.Return        ᯮ
*
*.Sample       comm.asm
**/
void far close_com(void);  /* close com port */


/**
*.Name         dtr_off
*
*.Title        뢠 ᨣ DTR
*
*.Proto        void far dtr_off(void)
*
*.Params        ᯮ
*
*.Return        ᯮ
*
*.Sample       comm.asm
**/
void far dtr_off(void);


/**
*.Name         dtr_on
*
*.Title        ⠭ ᨣ DTR
*
*.Proto        void far dtr_on(void)
*
*.Params        ᯮ
*
*.Return        ᯮ
*
*.Sample       comm.asm
**/
void far dtr_on(void);


/**
*.Name         r_count
*
*.Title        ।塞 ﭨ  ਥ
*
*.Proto        long far r_count(void)
*
*.Params        ᯮ
*
*.Return        襬  ᫮ ⮢   ਥ,
*                襬 騩 ࠧ  ਥ
*
*
*.Sample       comm.asm
**/
long far r_count(void);

// ம। r_count_size 頥
// 騩 ࠧ  ਥ

#define r_count_size() ((int)(r_count() >> 16))

// ம। r_count_pending 頥
// ᫮ ⮢   ਥ

#define r_count_pending() ((int)r_count())


/**
*.Name         receive_com
*
*.Title          ᨬ   ਥ
*
*.Proto        int far receive_com(void)
*
*.Params        ᯮ
*
*.Return       । ᨬ   ਥ
*
*.Sample       comm.asm
**/
int far receive_com(void);


/**
*.Name         s_count
*
*.Title        ।塞 ﭨ  ਥ
*
*.Proto        long far s_count(void)
*
*.Params        ᯮ
*
*.Return        襬  ᫮ ᢮ ⮢   ।稪,
*                襬 騩 ࠧ  ।稪
*
*
*.Sample       comm.asm
**/
long far s_count(void);

// ம। s_count_size 頥
// 騩 ࠧ  ਥ

#define s_count_size() ((int)(s_count() >> 16))

// ம। s_count_pending 頥
// ᫮ ⮢   ਥ

#define s_count_free() ((int)s_count())


/**
*.Name         send_com
*
*.Title        ।  ᨬ   ।稪
*
*.Proto        void far send_com(int ch)
*
*.Params       int ch - । ᨬ
*
*.Return        ᯮ
*
*.Sample       comm.asm
**/
void far send_com(int);


/**
*.Name         break_com
*
*.Title        । ᨣ "BREAK" 㤠 
*
*.Proto        void far break_com(void)
*
*.Params        ᯮ
*
*.Return        ᯮ
*
*.Sample       comm.asm
**/
void far break_com(void);

/**
*.Name         com_errors
*
*.Title        頥 㪠⥫쭠 ᨢ 稪 訡
*
*.Proto        int far *far com_errors(void)
*
*.Params        ᯮ
*
*.Return        ᯮ
*
*.Sample       comm.asm
**/
int far *far com_errors(void);


#define COM_EOVFLOW 0   // ९ 
#define COM_EOVRUN  1   // 訡 ९  ਥ
#define COM_EBREAK  2   // 㦥   뢠
#define COM_EFRAME  3   // 訡 ᨭ஭樨
#define COM_EPARITY 4   // 訡 ⭮
#define COM_EXMIT   5   // 訡  ।
#define COM_EDSR    6   //  祭 ᨣ dsr
#define COM_ECTS    7   //  祭 ᨣ cts
