// DTR.C

#include <conio.h>
#include "uart_reg.h"

/**
*.Name         dtr_on
*
*.Title        ⠭ ᨣ DTR  RTS.
*
*.Descr         㭪 ⠭ ᨣ DTR  RTS
*                COM-.
*
*.Proto        void dtr_on( unsigned base_address );
*
*.Params       unsigned base_address -   ᨭ஭ 
*
*.Return        ᯮ
*
*.Sample       dtr.c
**/

void dtr_on( unsigned base_address ) {

	MCR mc_reg;

	// 뢠 祭 ॣ ࠢ 

	mc_reg.byte = inp( base_address + MCR_N );

	// ⠭ ᨣ DTR  RTS  ⨢ ﭨ

	mc_reg.bit_reg.dtr = mc_reg.bit_reg.rts = 1;

	// 뢠  祭  ॣ ࠢ 

	outp( base_address + MCR_N, mc_reg.byte );
}




/**
*.Name         dtr_off
*
*.Title        뢠 ᨣ DTR  RTS.
*
*.Descr         㭪 뢠 ᨣ DTR  RTS
*                COM-.
*
*.Proto        void dtr_on( unsigned base_address );
*
*.Params       unsigned base_address -   ᨭ஭ 
*
*.Return        ᯮ
*
*.Sample       dtr.c
**/

void dtr_off( unsigned base_address ) {

	MCR mc_reg;


	// 뢠 祭 ॣ ࠢ 

	mc_reg.byte = inp( base_address + MCR_N );

	// 뢠 ᨣ DTR  RTS

	mc_reg.bit_reg.dtr = mc_reg.bit_reg.rts = 0;

	// 뢠  祭  ॣ ࠢ 

	outp( base_address + MCR_N, mc_reg.byte );
}

