// । ⨯ ࢨ筮 

#include <stdio.h>
#include <graph.h>
#include <bios.h>
#include "sysp.h"

unsigned char  get_adapter( void );

void main()
{
	printf("\nࢨ : ");
	switch(get_adapter()) {
		case _MDPA : puts("MDPA."); break;
		case _CGA  : puts("CGA.");  break;
		case _EGA  : puts("EGA.");  break;
		case _VGA  : puts("VGA.");  break;
		case _MCGA : puts("MCGA."); break;
		case _HGC  : puts("HGC.");  break;
		default    : puts(" .");
	}

	getch();
}


/**
*.Name         get_adapter
*
*.Title        । ⨯ ࢨ筮 
*
*.Descr         㭪 ⮡ࠦ ᪨ ࠭
*              㫠 ⥫쭮   䨧᪨.
*
*.Proto        unsigned char  get_adapter(void);
*
*.Params       int phys_pages -  䨧᪮ ࠭
*                  㯠 ( 0  3),   室
*                 ⮡ࠧ  ࠭ 㫠;
*
*              int_log_page -  ᪮ ࠭ 㫠;
*
*              int *handle -  祭 㫠;
*
*.Return        ﭨ ࠩ EMS
*
*.Sample       ems_test.c
**/

unsigned char get_adapter()
{
	union REGS reg;
	unsigned char eg_flag;

	// ।塞 稥 VGA

	reg.x.ax = 0x1A00;
	int86(0x10, &reg, &reg);

	// ᫨ VGA  ࢨ ஬,   ।

	if(reg.h.al == 0x1A && (reg.h.bl == 0x07 || reg.h.bl == 0x08))
		return(_VGA);

	// ᫨ VGA ,  ஢塞 稥 EGA

	reg.h.ah = 0x12;
	reg.h.bl = 0x10;
	int86(0x10, &reg, &reg);

	//  砥 ⢨ EGA 㥬 祩   
	// 0040:0010  ।塞 稥 ஢ CGA  MDA/Hercules

	if(reg.h.bl == 0x10) {
		eg_flag = *((unsigned char*)FP_MAKE(0x0040, 0x0010));
		switch(eg_flag & 0x30) {
			case 0x00 : return(_EGA);
			case 0x10 :
			case 0x20 : return(_CGA);
			case 0x30 : return(_MDPA);
		}
	}

	else return(_EGA);
}
