#include    <graph.h>
#include    "vga_new.h"

/**
*.Name    Set320x400Mode
*
*.Title   ⠭ ० 320400 ᥫ, 256 梥⮢.
*
*.Proto   void Set320x400Mode( void )
*
*.Params   ᯮ.
*
*.Return   ᯮ.
*
*.Sample  e256mres.c
**/

void    Set320x400Mode( void ) {

	_asm  {

		// ࠭塞 ॣ di
		push    di

		// ⠭ ⠭ ० 13h (320x200 ᥫ, 256 梥⮢)
		mov     ax,0013h
		int     10h

		// 롨ࠥ ॣ ।  
		mov     dx,SC_INDEX
		mov     al,MMR
		out     dx,al

		// 뢠 祭 ॣ ।  
		inc     dx
		in      al,dx

		// 뢠  D4
		and     al,11110111b

		// ⠭  D3,  ⮬ 몫砥 ० 樨
		//     ᠬ  ࠧ ᫮ 
		or      al,00000100b

		// 뢠  ॣ  祭
		out     dx,al


		// ᫥ 㧪   ॣ  祭 
		//  ᮮ⢥ ० 10h  12h  ᪫祭
		// ⮣,   ᥫ ᮮ⢥   

		// 롨ࠥ ॣ ० ࠡ ᪮ ஫

		mov     dx,GC_INDEX
		mov     al,MDR
		out     dx,al

		// 뢠  祭
		inc     dx
		in      al,dx
		
		// 몫砥    ᠬ   ᫮,  
		//  ᠬ   ᫮
		and     al,11101111b
		out     dx,al

		// 롨ࠥ ॣ ᬥ蠭 祭 ᪮ ஫
		dec     dx
		mov     al,MIR
		out     dx,al

		// 뢠  祭
		inc     dx
		in      al,dx

		// 뢠  ࠢ騩 楯    ᫮
		and     al,11111101b
		out     dx,al

		// ࠧ蠥      梥⮢ ᫮,
		// 뢠 ᫮ 0fh  ॣ ࠧ襭  梥⮢ ᫮

		mov     dx,SC_INDEX
		mov     al,CPWER
		out     dx,al

		inc     dx
		mov     al,00001111b
		out     dx,al

		// 頥  ࠭ , ⠪  ⠭
		// ন 13h 頥 ⮫쪮  64K

		mov     ax,VGA_SEGMENT
		mov     es,ax

		xor     di,di
		mov     ax,di

		mov     cx,8000h
		cld
		rep     stosb

		// 롨ࠥ ॣ  ᨬ ⥪ ஫ 
		mov     dx,CRTC_INDEX
		mov     al,MSLR
		out     dx,al

		inc     dx
		in      al,dx

		// ⠭  ᨬ ࠢ 
		//!!! and     al,not 1fh

		// 頥  ᪠஢
		and     al,01100000b
		out     dx,al

		// 롨ࠥ ॣ  ન ᨬ
		dec     dx
		mov     al,ULR
		out     dx,al

		// 몫砥 ० 樨    ᫮
		inc     dx
		in      al,dx
		and     al,10111111b
		out     dx,al

		// 롨ࠥ ॣ ࠢ ०
		dec     dx
		mov     al,MCR
		out     dx,al

		// 砥 ⮢ ० 樨
		inc     dx
		in      al,dx
		or      al,01000000b
		out     dx,al

		pop     di
	}
}




/**
*.Name    WritePixel
*
*.Title   ⮡ࠦ ᥫ.
*
*.Descr   㭪 ⮡ࠦ  ࠭ ᥫ   न,
*         । 梥.
*
*.Proto   void WritePixel(unsigned x, unsigned y, unsigned char color)
*
*.Params  x - x-न ᥫ (0-319),
*
*         y - y-न ᥫ (0-399),
*
*         color - 梥 ᥫ (0-255).
*
*.Return   ᯮ.
*
*.Sample  e256mres.c
**/

void  WritePixel(unsigned x, unsigned y, unsigned char color) {

	_asm  {

		push    di

		mov     cx,x
		mov     dx,y
		mov     bl,color

		mov     ax,VGA_SEGMENT
		mov     es,ax

		mov     ax,( SCREEN_WIDTH / 4 )
		mul     dx

		push    cx

		shr     cx,1
		shr     cx,1

		add     ax,cx
		mov     di,ax

		pop     cx

		and     cl,3
		mov     ah,1
		shl     ah,cl

		mov     dx,SC_INDEX
		mov     al,CPWER
		out     dx,ax

		mov     es:[di],bl

		pop     di
	}
}



/**
*.Name    ReadPixel
*
*.Title   । 梥 ᥫ.
*
*.Descr   㭪 頥 祭  , ।饣 ᥫ 
*          묨 न⠬.
*
*.Proto   unsigned char ReadPixel(unsigned x, unsigned y, unsigned char color)
*
*.Params  x - x-न ᥫ (0-319),
*
*         y - y-न ᥫ (0-399).
*
*.Return  梥 ᥫ (0-255).
*
*.Sample  e256mres.c
**/

unsigned char   ReadPixel( unsigned x, unsigned y ) {

	unsigned char  color;

	_asm  {

		push    si

		mov     cx,x
		mov     dx,y

		mov     ax,VGA_SEGMENT
		mov     es,ax

		mov     ax,( SCREEN_WIDTH / 4 )
		mul     dx

		push    cx

		shr     cx,1
		shr     cx,1

		add     ax,cx
		mov     si,ax

		pop     ax

		and     al,3
		mov     ah,al

		mov     dx,GC_INDEX
		mov     al,RPSR
		out     dx,ax

		mov     al,es:[si]
		mov     color,al

		pop     si
	}

	return( color );
}


/**
*.Name    Full_Scr
*
*.Title   訢 ࠭  梥⮬.
*
*.Proto   void Full_Scr( unsigned char color )
*
*.Params  color - 梥 ࠭ (0-255).
*
*.Return   ᯮ.
*
*.Sample  e256mres.c
**/

void Full_Scr( unsigned char color ) {

	_asm {

		;ࠧ蠥      梥⮢ ᫮

		push    di

		mov     dx,SC_INDEX
		mov     al,CPWER
		out     dx,al

		inc     dx
		mov     al,0fh
		out     dx,al


		mov     ax,VGA_SEGMENT
		mov     es,ax

		xor     di,di
		mov     al,color

		mov     cx,32000
		cld
		rep     stosb

		pop     di
	}
}


void main( void ){

	unsigned i;
	char ch = 13;

	struct videoconfig vc;

	// 塞   vc

	printf("\n   (C) Frolov G.V., 1992 \n\n");
	_getvideoconfig( &vc );

	// 蠥 ணࠬ ᫨  VGA 

	if(vc.adapter != _VGA) {
		printf(" 믮 ணࠬ 室  VGA.\n");
		exit(0);
	}

	// ⠭ ० 320400 ᥫ, 256 梥⮢

	Set320x400Mode();

	// 㦠 ॣ  VGA

	LoadVGA256();


	for(i = 0; i < 400; i++)
		WritePixel(160, (unsigned) i, (unsigned char) (i % 256) );

	for(i = 0; i < 320; i++)
		WritePixel((unsigned) i, 200, (unsigned char) (i % 256) );

	ch = getch();
	if( ch == 27 ) exit(1);

	for(i = 0; i < 320; i++)
		WritePixel((unsigned) i, (unsigned) i, (unsigned char) (i % 256) );

	ch = getch();

	for(i = 0; ((i < 256) && (ch != 27)); i++) {
		Full_Scr( (unsigned char) i );
		ch = getch();
	}


	// 頥  ⥪⮢ ०

	_setvideomode(_DEFAULTMODE);

	printf("ਢ ᥬ!!!\n");
}
