/* SYSP.H - include-䠩  ਬ஢, ਢ   */



/**
*.Name      FP_MAKE
*
*.Title       ⠢ FAR-㪠⥫
*
*.Descr      ⠢ FAR-㪠⥫, 
*           祭ﬨ ᥣ  ᬥ饭
*
*.Params    FP_MAKE(seg,off)
*              seg - ᥣ;
*              off - ᬥ饭
*
*.Return    FAR-㪠⥫ seg:off
**/


#define FP_MAKE(seg,off) ((void far *)                         \
					((((unsigned long) (unsigned)(seg)) << 16L) |   \
					((unsigned long) (unsigned) (off))))


/*  ୮ ⠡ 裡 DOS */

#pragma pack(1)

typedef struct _CVT_ {
	unsigned mcb_seg;
	void far *dev_cb;
	void far *file_tab;
	void far *clock_dr;
	void far *con_dr;
	unsigned max_btbl;
	void far *disk_buf;
	void far *drv_info;
	void far *fcb_tabl;
	unsigned fcb_size;
	unsigned char num_bdev;
	unsigned char lastdriv;
} CVT;


/*  ࠢ  MCB */

typedef struct _MCB_ {
	unsigned char type;
	unsigned owner;
	unsigned size;
	char reserve[11];
} MCB;

/* 䨪 ணࠬ ᥣ PSP */

typedef struct _PSP_ {
	unsigned char int20h[2];
	unsigned mem_top;
	unsigned char reserv1;
	unsigned char call_dsp[5];
	void far *term_adr;
	void far *cbrk_adr;
	void far *crit_err;
	unsigned parn_psp;
	unsigned char file_tab[20];
	unsigned env_seg;
	void far *ss_sp;
	unsigned max_open;
	void far *file_tba;
	unsigned char reserv2[24];
	unsigned char disp[3];
	unsigned char reserv3[9];
	unsigned char fcb1[16];
	unsigned char fcb2[20];
	unsigned char p_size;
	unsigned char parm[127];
} PSP;


/*  ࠢ ன⢮ DOS */

typedef struct _DDCB_ {
	unsigned char drv_num;
	unsigned char drv_numd;
	unsigned sec_size;
	unsigned char clu_size;
	unsigned char clu_base;
	unsigned boot_siz;
	unsigned char fat_num;
	unsigned max_dir;
	unsigned data_sec;
	unsigned hi_clust;
	unsigned char fat_size;
	char reserv1;
	unsigned root_sec;
	void far *drv_addr;
	unsigned char media;
	unsigned char acc_flag;
	struct _DDCB_ far *next;
	unsigned reserv2;
	unsigned built;
} DDCB;

/* ࠢ騩  DOS  䠩 */

typedef struct _DFCB_ {
	unsigned handl_num;
	unsigned char access_mode;
	unsigned reserv1;
	unsigned dev_info;
	void far *driver;
	unsigned first_clu;
	unsigned time;
	unsigned date;
	unsigned long fl_size;
	unsigned long offset;
	unsigned reserv2;
	unsigned reserv7;
	unsigned reserv3;
	char reserv4;
	char filename[11];
	char reserv5[6];
	unsigned ownr_psp;
	unsigned reserv6;
	unsigned last_clu;
	char reserv8[4];
} DFCB;

/*  䠩 DOS */

typedef struct _DFT_ {
	struct _DFT_ far *next;
	unsigned file_count;
	DFCB dfcb;
} DFT;


/* ࠢ騩  ᪮  BCB */

typedef struct _BCB_ {
	struct _BCB_ far *next;
	unsigned char drive;
	unsigned char flag;
	unsigned sect_num;
	unsigned reserv1;
	DDCB far *ddcb;
	unsigned reserv2;
} BCB;

/* ଠ  ᪥ */

typedef struct _DINFO_ {
	char path[64];
	unsigned reserv1;
	unsigned reserv2;
	unsigned char reserv3;
	DDCB far *ddcb;
	unsigned cdir_clu;
	unsigned reserv4;
	unsigned reserv5;
	unsigned reserv6;
	unsigned char reserv7[7];
} DINFO;


/*  EXE-ணࠬ */

typedef struct _EXE_HDR_ {
	unsigned signature;
	unsigned part_pag;
	unsigned file_size;
	unsigned rel_item;
	unsigned hdr_size;
	unsigned min_mem;
	unsigned max_mem;
	unsigned ss_reg;
	unsigned sp_reg;
	unsigned chk_summ;
	unsigned ip_reg;
	unsigned cs_reg;
	unsigned relt_off;
	unsigned overlay;
} EXE_HDR;


/* ⠡ ᯮ ᥣ⮢ EXE-ணࠬ */

typedef struct _RELOC_TAB_ {
	unsigned offset;
	unsigned segment;
} RELOC_TAB;


#pragma pack()



void far *get_cvt(void); /*   ୮ ⠡ 裡 */
CVT  far *get_mcvt(void); /*   ୮ ⠡ 裡 */

MCB  far *get_fmcb(CVT far *); /*   ࢮ MCB */
MCB  far *get_nmcb(MCB far *); /*   ᫥饣 MCB */

DDCB  far *get_fddcb(CVT far *); /*   ࢮ DDCB */
DDCB  far *get_nddcb(DDCB far *); /*   ᫥饣 DDCB */
DDCB  far *get_ddcb(unsigned char); /*   DDCB  ᪠ */

DFT  far *get_fdft(CVT far *); /*   ࢮ DFT */
DFT  far *get_ndft(DFT far *); /*   ᫥饩 DFT */

BCB  far *get_fbcb(CVT far *); /*   ࢮ BCB */
BCB  far *get_nbcb(BCB far *); /*   ᫥饣 BCB */

int get_exeh(EXE_HDR *,RELOC_TAB **, FILE *); /*   EXE */
