unit UserScr;

interface

const
  vmT36x14c9x14 = 0;  { 32 ࠭ }
  vmT40x14c8x14 = 1;  { 25 ࠭ }
  vmT40x14c9x14 = 2;  { 25 ࠭ }
  vmT46x14c8x14 = 3;  { 21 ࠭ }

  vmT36x15c9x16 = 4;  { 25 ࠭ }
  vmT40x15c8x16 = 5;  { 25 ࠭ }
  vmT40x15c9x16 = 6;  { 25 ࠭ }
  vmT46x15c8x16 = 7;  { 21 ࠭ }

  vmT36x17c9x14 = 8;  { 25 ࠭ }
  vmT40x17c8x14 = 9;  { 21 ࠭ }
  vmT40x17c9x14 = 10; { 21 ࠭ }
  vmT46x17c8x14 = 11; { 18 ࠭ }

  vmT36x22c9x16 = 12; { 18 ࠭ }
  vmT40x22c8x16 = 13; { 18 ࠭ }
  vmT40x22c9x16 = 14; { 18 ࠭ }
  vmT46x22c8x16 = 15; { 16 ࠭ }
  vmT70x22c9x16 = 16; {  9 ࠭ }
  vmT80x22c8x16 = 17; {  9 ࠭ }
  vmT80x22c9x16 = 18; {  9 ࠭ }
  vmT90x22c8x16 = 19; {  8 ࠭ }

  vmT36x25c9x16 = 20; { 16 ࠭ }
  vmT40x25c8x16 = 21; { 16 ࠭ }
  vmT40x25c9x16 = 22; { 16 ࠭ }
  vmT46x25c8x16 = 23; { 12 ࠭ }
  vmT70x25c9x16 = 24; {  9 ࠭ }
  vmT80x25c8x16 = 25; {  8 ࠭ }
  vmT80x25c9x16 = 26; {  8 ࠭ }
  vmT90x25c8x16 = 27; {  7 ࠭ }

  vmT46x29c8x14 = 28; { 11 ࠭ }
  vmT70x29c9x14 = 29; {  8 ࠭ }
  vmT80x29c8x14 = 30; {  6 ࠭ }
  vmT80x29c9x14 = 31; {  6 ࠭ }
  vmT90x29c8x14 = 32; {  6 ࠭ }

  vmT70x30c9x16 = 33; {  7 ࠭ }
  vmT80x30c8x16 = 34; {  6 ࠭ }
  vmT80x30c9x16 = 35; {  6 ࠭ }
  vmT90x30c8x16 = 36; {  5 ࠭ }

  vmT70x34c9x14 = 37; {  6 ࠭ }
  vmT80x34c8x14 = 38; {  5 ࠭ }
  vmT80x34c9x14 = 39; {  5 ࠭ }
  vmT90x34c8x14 = 40; {  5 ࠭ }

  vmT70x44c9x8  = 41; {  5 ࠭ }
  vmT80x44c8x8  = 42; {  4 ࠭ }
  vmT80x44c9x8  = 43; {  4 ࠭ }
  vmT90x44c8x8  = 44; {  4 ࠭ }

  vmT70x50c9x8  = 45; {  4 ࠭ }
  vmT80x50c8x8  = 46; {  4 ࠭ }
  vmT80x50c9x8  = 47; {  4 ࠭ }
  vmT90x50c8x8  = 48; {  3 ࠭ }

  vmT70x60c9x8  = 49; {  3 ࠭ }
  vmT80x60c8x8  = 50; {  3 ࠭ }
  vmT80x60c9x8  = 51; {  3 ࠭ }
  vmT90x60c8x8  = 52; {  3 ࠭ }

procedure LoadUserVideoMode(m: byte);
  {  ணࠬ   m ०.  頥 ࠭.
     ਬ: LoadUserVideoMode(vmT80x25c9x16);  }

procedure LoadProperBIOSFont;
  {  㦠  ⥪饣 _⥪⮢_ ० ᮮ⢥騩 
     ᨬ  ࠧ   BIOS. 室 ᯮ짮 ࠧ
     ᫥ 믮 SetUserVideoMode. }

procedure ClearUserScreen;
  {  頥 ⥪ ࠭ ⥪⮢ ࠭.  }

procedure ClearUserScreenPage(p: byte);
  {  頥   p ࠭ ⥪⮢ ࠭.  ४祭
     ࠭ ᯮ ᮮ⢥騥 㭪樨 BIOS.  }

procedure ProperInitMouse;
  {  樠 ࠩ   ⠭ ࠢ ࠭
     ࠭  ਧ⠫  ⨪. 室 ᯮ짮 ࠧ
     ᫥ 믮 SetUserVideoMode.
     ਬ砭: 設⢮ ࠩ஢   ६ BIOS,
                 騥 ࠧ ࠭,  । ࠧ ࠭
                  ६ CRT_MOD  ᮬ [0040:0049],  ⠪ 
                 ⨯ ०: ⥪⮢  ᪨. 楤
                 SetUserVideoMode   ᮤন ⮩ ६.
                 ⮬   ஡  㪠⥫ 
                 ஡   祭 ⮩ ६ __
                 믮  楤,   ࠩ .
                 ࠩ Microsoft Mouse v10.00 ࠡ⠥ ४⭮ 
                 ᥬ ० ஬ 40啕.
                 ᠫ  ᯮᮡ  ⠭ ᢮
                 ࠡ稪 ᮡ⨩ ,  ᠬ ࠢ
                 ࠦ 設 㪠⥫.  }

procedure LoadUserFont(Bank, Start, CharSize: byte;
          Count: word; var Font);
  {  㦠  짮⥫,   Font,    ஬ Bank
     ( 0  3), 稭  ᨬ   Start,   Count ᨬ
      ࠧ஬   CharSize ப. 楤 ࠡ⠥ ⠪ 
     饭 ०.  }

procedure SetUserVideoMode(m: byte);
  {  ⠭   m ०.
     頥 ࠭.
     㦠 ᮮ⢥騩   BIOS.
     ਭ㤨⥫쭮 樠  (ࠢ  墠뢠
     뢠 10h  樠  ᬥ ०,  ᪮
      ⠭ ०  ᯮ 뢠 10h, 室
     樠஢  ਭ㤨⥫쭮).

     ਬ: SetUserVideoMode(vmT80x25c9x16);  }

implementation

procedure LoadUserVideoMode(m: byte);
{$I userscr.inc}
var i,j: word; p: pointer;
begin
  p := @vtab;
  asm
    mov     ah, m
    xor     al, al
    shr     ax, 1
    shr     ax, 1
    les     si,p
    add     si,ax       {  ES:SI 㪠⥫  ⠡ ० m }

        MOV     DX,3CCH
	IN	AL,DX
	MOV	DL,0D4H
	TEST	AL,1
	JNZ	@@L1
	MOV	DL,0B4H
@@L1:
	ADD	DX,6
	IN	AL,DX
	XOR	AL,AL
	MOV	DX,3C0H
	OUT	DX,AL

        mov     ax,100h
        mov     dx,3c4h
        out     dx,ax

	ADD	SI,5
	MOV	CX,4
	MOV	AL,1
	MOV	DX,3C4H
@@L2:
	MOV	AH,ES:[SI]
	INC	SI
	OUT	DX,AX
	INC	AL
	LOOP	@@L2

	MOV	AL,ES:[SI]
	INC	SI
	MOV	DX,3C2H
	OUT	DX,AL

        mov     dx,3c4h
        mov     ax,300h
        out     dx,ax

	MOV	DX,3CCH
	IN	AL,DX
	MOV	DL,0D4H
	TEST	AL,1
	JNZ	@@L3
	MOV	DL,0B4H
@@L3:
	push	es
        mov     ax,40h
        mov     es,ax
        mov     word ptr es:[63h],dx
	pop	es

	MOV	AL,11H
	OUT	DX,AL
	INC	DX
	MOV	AH,AL
	IN	AL,DX
	DEC	DX
	XCHG	AL,AH

	AND	AH,7FH
	OUT	DX,AX
	MOV	CX,19H
	MOV	AL,0

@@L4:
	MOV	AH,ES:[SI]
	INC	SI
	OUT	DX,AX
	INC	AL
	LOOP	@@L4

	ADD	DX,6
	IN	AL,DX
	XOR	AH,AH
	MOV	CX,14H
	MOV	DX,3C0H
@@L5:
	MOV	AL,AH
	OUT	DX,AL
	INC	AH
	mov	al,ES:[SI]
        inc     si
	OUT	DX,AL
	LOOP	@@L5

	XOR	AL,AL
	MOV	CX,9
	MOV	DX,3CEH
@@L11:
	MOV	AH,ES:[SI]
	INC	SI
	OUT	DX,AX
	INC	AL
        loop    @@L11

        mov     dx,3c0h
        mov     al,32
        out     dx,al

  end;
  mem[Seg0040:$4A] := vtab[m, 1];
  mem[Seg0040:$84] := vtab[m, 2];
  mem[Seg0040:$85] := vtab[m, 3];
  mem[Seg0040:$4C] := vtab[m, 4];
  mem[Seg0040:$4D] := vtab[m, 5];

  for i := $4E to $5F do
    begin memw[Seg0040:i] := 0; inc(i) end;
  mem[Seg0040:$60] := vtab[m, 21];
  mem[Seg0040:$61] := vtab[m, 22];
  mem[Seg0040:$62] := 0;
end;

procedure LoadProperBIOSFont;
var I: byte;
begin
  case mem[Seg0040:$85] of
    8:  I := 2;
    14: I := 1;
    16: I := 4;
    else I := 0;
  end;
  if I<>0 then
  asm
    mov    ah, 11h
    mov    al, I
    xor    bx, bx
    int    16
  end
end;

procedure ClearUserScreen;
var o, c: word;
begin
  c := memw[Seg0040:$4C];
  o := memw[Seg0040:$4E];
  if (o+c) <= 32768 then FillChar(ptr(SegB800, o)^, c, 0)
end;

procedure ClearUserScreenPage(p: byte);
var o, c: word;
begin
  c := memw[Seg0040:$4C];
  o := c * p;
  if (o+c) <= 32768 then FillChar(ptr(SegB800, o)^, c, 0)
end;

procedure ProperInitMouse; assembler;
asm
    mov    ax, 0
    int    33h
    or     ax, ax
    je     @@1
    mov    ax, Seg0040
    mov    es, ax
    mov    dx, es:[4Ah]
    mov    cl, 3
    shl    dx, cl
    dec    dx
    xor    cx, cx
    mov    ax, 7
    push   dx
    int    33h
    mov    al, es:[84h]
    inc    al
    shl    ax, 1
    shl    ax, 1
    shl    ax, 1
    dec    ax
    mov    dx, ax
    xor    cx, cx
    mov    ax, 8
    int    33h
    pop    cx
    shr    cx, 1
    shr    dx, 1
    mov    ax, 4
    int    33h
@@1:
end;

procedure LoadUserFont(Bank, Start, CharSize: byte;
          Count: word; var Font); assembler;
asm
        cli

        mov     dx,3C4h
        mov     ax,402h
        out     dx,ax
        mov     ax,604h
        out     dx,ax

        mov     dl,0CEh
        mov     ax,204h
        out     dx,ax
        mov     ax,5
        out     dx,ax
        mov     ax,0C06h
        out     dx,ax

        push    ds
        mov     di, SegB800
        mov     es, di
        mov     al, Bank
        and     ax, 3
        mov     cl, 13
        shl     ax, cl
        mov     di, ax
        mov     al, Start
        xor     ah, ah
        mov     cl, 5
        shl     ax, cl
        add     di, ax
        lds     si, Font

        mov     dx, Count
        xor     ch, ch
@@1:    push    di
        mov     cl, CharSize
        rep     movsb
        pop     di
        add     di, 32
        dec     dx
        jne     @@1

        mov     dx,3CEh
        mov     ax,4
        out     dx,ax
        mov     ax,1005h
        out     dx,ax
        mov     ax,0E06h
        out     dx,ax

        mov     dl,0C4h
        mov     ax,302h
        out     dx,ax
        mov     ax,204h
        out     dx,ax

        sti
        pop     ds
end;

procedure SetUserVideoMode(m: byte);
begin
  LoadUserVideoMode(m);
  ClearUserScreen;
  LoadProperBIOSFont;
  ProperInitMouse;
end;

end.
